/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DatabaseTest;
import netjfwatcher.engine.model.action.ActionBuilderDatabase;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import netjfwatcher.engine.model.action.EngineThreadList;
import netjfwatcher.engine.model.thread.ManageEngineThread;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.OidGetInfo;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.server.holdperiod.ThreadPeriodHoldCheck;
import netjfwatcher.engine.server.protocol.control.ListQueueDefaultSnmpMibControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePingControl;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.server.protocol.control.QueueForDefaultSnmpMib;
import netjfwatcher.engine.server.protocol.control.QueueForPing;
import netjfwatcher.engine.server.protocol.control.QueueForStatisticsMib;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;



/**
 * GWĎThreadԂ\ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EngineThreadView extends ViewPart {
    /* Scroll Composite size */
    private static final int[] SCROLL_COMPOSITE_SIZE = { 900, 700 };

    /* Label  */
    private static final int LABEL_WIDTH = 150;

    /* Xe[^XAvpeB\Text */
    private static final int TEXT_WIDTH = 120;

    /* m[hAQueueTCY\Text */
    private static final int COUNT_TEXT_WIDTH = 80;

    /* Engine Active */
    private static final String ACITIVE = "Active";

    /* Engine InActive */
    private static final String INACITIVE = "InActive";

    /* Thread AliveDescription */
    private static final String THREAD_ALIVE = " is Alive";

    /* Thread No AliveDescription */
    private static final String THREAD_NOALIVE = " is NoAlive";

    /* m[hList Width Hint */
    private static final int LIST_WIDTHHINT = 300;

    /* List Vertical Span */
    private static final int LIST_VERTICAL_SPAN = 5;

    /* List Height Hint */
    private static final int LIST_HEIGHT_HINT = 8;

    /* Thread List */
    private static final int LIST_SHORT_WIDTHHINT = 200;

    /* MO */
    private static Logger logger;

    /* Xe[^XC}l[W */
    private SubStatusLineManager statusLineManager;

    /* f[^x[X\Text */
    private Text databaseNameText;

    /* f[^x[XXe[^X\Text */
    private Text databaseStatusText;

    /* R}hM|[g\Text */
    private Text commandReceivePortText;

    /* R}hMXe[^X\Text */
    private Text commandReceiveStatusText;

    /* XML Socket|[g\Text */
    private Text xmlSocketPortText;

    /* XML SocketXe[^X\Text */
    private Text xmlSocketStatusText;

    /* MailK[h^C\Text */
    private Text mailGuardTimeText;

    /* MailK[hXe[^X\Text */
    private Text mailGuardStatusText;

    /* ێThread\Text */
    private Text dataHoldPeriodThreadPeriodText;

    /* ێThreadXe[^X\Text */
    private Text dataHoldPeriodThreadStatusText;

    /* TrapM|[g\Text */
    private Text trapReceivePortText;

    /* TrapMXe[^X\Text */
    private Text trapReceiveStatusText;

    /* XV{^ */
    private Button refreshButton;

    /* PingĎm[h\Text */
    private Text pingCheckNodeText;

    /* PingĎm[hXg */
    private List pingCheckNodeList;

    /* PingĎQueue\Text */
    private Text pingCheckQueueLengthText;

    /* PingĎThreadXg */
    private List pingCheckThreadList;

    /* SNMPĎm[h\Text */
    private Text snmpCheckNodeText;

    /* SNMPĎm[hXg */
    private List snmpCheckNodeList;

    /* SNMPĎQueue\Text */
    private Text snmpCheckQueueLengthText;

    /* SNMPĎThreadXg */
    private List snmpCheckThreadList;

    /* SNMPvĎm[h\Text */
    private Text snmpStatisticsCheckNodeText;

    /* SNMPvĎm[hXg */
    private List snmpStatisticsCheckNodeList;

    /* SNMPvĎQueue\Text */
    private Text snmpStatisticsCheckQueueLengthText;

    /* SNMPvĎThreadXg */
    private List snmpStatisticsCheckThreadList;

    /*
     * GWANV
     */
    private ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();

    /* EditorPartANV */
    private ActionBuilderEditorsPartClose actionBuilderEditorPart =
        new ActionBuilderEditorsPartClose();

    /*
     * GWĎThreadԂ\ViewNXCX^X
     * ܂B
     */
    private ActionBuilderDatabase actionBuilderDatabase =
        new ActionBuilderDatabase();

    /**
     * GWĎThreadԂ\ViewNXCX^X𐶐܂B
     *
     */
    public EngineThreadView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * PartControl𐶐܂B
     *
     * parent Composite
     */
    public void createPartControl(Composite parent) {
        fillActionBars();

        setStatusLine();

        ResourceInfo info =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();

        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridData gridData = null;

        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite baseComposite = new Composite(scrollComposite, SWT.NONE);
        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(new GridData());

        GridLayout gridLayout = new GridLayout(5, false);
        Composite composite1 = new Composite(baseComposite, SWT.NULL);
        composite1.setLayout(gridLayout);
        composite1.setLayoutData(new GridData());

        GridLayout gridLayout2 = new GridLayout(4, false);
        Composite composite2 = new Composite(baseComposite, SWT.NONE);
        composite2.setLayoutData(new GridData());
        composite2.setLayout(gridLayout2);

        GridLayout gridLayout3 = new GridLayout(4, false);
        Composite composite3 = new Composite(baseComposite, SWT.NONE);
        composite3.setLayoutData(new GridData());
        composite3.setLayout(gridLayout3);

        GridLayout gridLayout4 = new GridLayout(4, false);
        Composite composite4 = new Composite(baseComposite, SWT.NONE);
        composite4.setLayoutData(new GridData());
        composite4.setLayout(gridLayout4);

        refreshButton = new Button(composite1, SWT.NONE);
        refreshButton.setText("Refresh");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        refreshButton.setLayoutData(gridData);

        Label label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        gridData = new GridData();

        label = new Label(composite1, SWT.NONE);
        label.setText("Database");
        label.setLayoutData(new GridData());

        label = new Label(composite1, SWT.NONE);
        label.setText("status");
        label.setLayoutData(new GridData());

        databaseStatusText = new Text(composite1, SWT.BORDER);
        databaseStatusText.setText(INACITIVE);

        String[] testResult = null;
        DatabaseTest databaseTest = new DatabaseTest(info.getDatabaseName());
        testResult =
            databaseTest.checkDatabase(
                info.getDatabaseDriver(), info.getDatabaseUrl(),
                info.getDatabaseUser(), info.getDatabasePassword());

        int okPos = 0;
        databaseStatusText.setText(ACITIVE);

        for (int i = 0; i < testResult.length; i++) {
            logger.info("Phase " + i + " : " + testResult[i]);
            okPos = testResult[i].indexOf("OK");

            if (okPos < 0) {
                if (i == 0) {
                    continue;
                }

                databaseStatusText.setText(INACITIVE);

                break;
            }
        }

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databaseStatusText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Database name");
        label.setLayoutData(new GridData());
        databaseNameText = new Text(composite1, SWT.BORDER);
        databaseNameText.setText(info.getDatabaseName());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databaseNameText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Command receive server");
        label.setLayoutData(new GridData());

        label = new Label(composite1, SWT.NONE);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData(gridData);
        commandReceiveStatusText = new Text(composite1, SWT.BORDER);

        Thread commandThread =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.COMMAND_RECEIVE_THREAD);

        if (commandThread == null) {
            commandReceiveStatusText.setText(INACITIVE);
        } else {
            if (commandThread.isAlive()) {
                commandReceiveStatusText.setText(ACITIVE);
            } else {
                commandReceiveStatusText.setText(INACITIVE);
            }
        }

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        commandReceiveStatusText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Command recive port");
        label.setLayoutData(new GridData());
        commandReceivePortText = new Text(composite1, SWT.BORDER);
        commandReceivePortText.setText(info.getEnginePort());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        commandReceivePortText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Trap receive server");
        label.setLayoutData(new GridData());

        label = new Label(composite1, SWT.NONE);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData(gridData);
        trapReceiveStatusText = new Text(composite1, SWT.BORDER);

        Thread trapThread =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.TRAP_RECEIVE_THREAD);

        if (trapThread == null) {
            trapReceiveStatusText.setText(INACITIVE);
        } else {
            if (trapThread.isAlive()) {
                trapReceiveStatusText.setText(ACITIVE);
            } else {
                trapReceiveStatusText.setText(INACITIVE);
            }
        }

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        trapReceiveStatusText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Snmp Trap receive port");
        label.setLayoutData(new GridData());
        trapReceivePortText = new Text(composite1, SWT.BORDER);
        trapReceivePortText.setText(Integer.toString(info.getSnmpTrapPort()));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        trapReceivePortText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("XML socket server");
        label.setLayoutData(new GridData());
        label = new Label(composite1, SWT.NONE);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData(gridData);
        xmlSocketStatusText = new Text(composite1, SWT.BORDER);

        Thread xmlThread =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.XML_SOCKET_THREAD);

        if (xmlThread == null) {
            xmlSocketStatusText.setText(INACITIVE);
        } else {
            if (xmlThread.isAlive()) {
                xmlSocketStatusText.setText(ACITIVE);
            } else {
                xmlSocketStatusText.setText(INACITIVE);
            }
        }

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        xmlSocketStatusText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("XML Socket port");
        label.setLayoutData(new GridData());
        xmlSocketPortText = new Text(composite1, SWT.BORDER);
        xmlSocketPortText.setText(info.getXmlSocketPort());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        xmlSocketPortText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Mail guard thread");
        label.setLayoutData(new GridData());
        label = new Label(composite1, SWT.NONE);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData(gridData);
        mailGuardStatusText = new Text(composite1, SWT.BORDER);

        Thread mailGuardThread =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.MAIL_GUARD_THREAD);

        if (mailGuardThread == null) {
            mailGuardStatusText.setText(INACITIVE);
        } else {
            if (mailGuardThread.isAlive()) {
                mailGuardStatusText.setText(ACITIVE);
            } else {
                mailGuardStatusText.setText(INACITIVE);
            }
        }

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        mailGuardStatusText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Mail guard time(sec)");
        label.setLayoutData(new GridData());
        mailGuardTimeText = new Text(composite1, SWT.BORDER);
        mailGuardTimeText.setText(info.getMailGuardTime());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        mailGuardTimeText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Data hold period thread");
        label.setLayoutData(new GridData());
        label = new Label(composite1, SWT.NONE);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData(gridData);
        dataHoldPeriodThreadStatusText = new Text(composite1, SWT.BORDER);

        Thread dataHoldPeriodThraed =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.DATABASE_LIMIT_CHECK_THREAD);

        if (dataHoldPeriodThraed == null) {
            dataHoldPeriodThreadStatusText.setText(INACITIVE);
        } else {
            if (dataHoldPeriodThraed.isAlive()) {
                dataHoldPeriodThreadStatusText.setText(ACITIVE);
            } else {
                dataHoldPeriodThreadStatusText.setText(INACITIVE);
            }
        }

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        dataHoldPeriodThreadStatusText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Datahold period thread period(sec)");
        label.setLayoutData(new GridData());
        dataHoldPeriodThreadPeriodText = new Text(composite1, SWT.BORDER);
        dataHoldPeriodThreadPeriodText.setText(
            Long.toString(ThreadPeriodHoldCheck.WATCH_PERIOD / 1000));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        dataHoldPeriodThreadPeriodText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Ping check node");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Ping check queue");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Ping check thread");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        label.setLayoutData(gridData);

        pingCheckNodeText = new Text(composite2, SWT.BORDER | SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COUNT_TEXT_WIDTH;
        pingCheckNodeText.setLayoutData(gridData);

        pingCheckNodeList =
            new List(
                composite2,
                SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);

        // GridData data = new GridData(GridData.FILL_BOTH);
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
        data.horizontalSpan = 1;
        data.verticalSpan = LIST_VERTICAL_SPAN;
        data.widthHint = LIST_WIDTHHINT;
        data.heightHint = pingCheckNodeList.getItemHeight() * LIST_HEIGHT_HINT;
        pingCheckNodeList.setLayoutData(data);

        pingCheckQueueLengthText = new Text(composite2, SWT.BORDER | SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COUNT_TEXT_WIDTH;
        pingCheckQueueLengthText.setLayoutData(gridData);

        pingCheckThreadList =
            new List(
                composite2,
                SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
        data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = LIST_VERTICAL_SPAN;
        data.widthHint = LIST_SHORT_WIDTHHINT;
        data.heightHint =
            pingCheckThreadList.getItemHeight() * LIST_HEIGHT_HINT;
        pingCheckThreadList.setLayoutData(data);

        label = new Label(composite3, SWT.NONE);
        label.setText("Snmp check node");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite3, SWT.NONE);
        label.setText("Snmp check queue");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        label.setLayoutData(gridData);

        label = new Label(composite3, SWT.NONE);
        label.setText("Snmp check thread");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        label.setLayoutData(gridData);

        snmpCheckNodeText = new Text(composite3, SWT.BORDER | SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COUNT_TEXT_WIDTH;
        snmpCheckNodeText.setLayoutData(gridData);

        snmpCheckNodeList =
            new List(
                composite3,
                SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);

        data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = LIST_VERTICAL_SPAN;
        data.widthHint = LIST_WIDTHHINT;
        data.heightHint = pingCheckNodeList.getItemHeight() * LIST_HEIGHT_HINT;
        snmpCheckNodeList.setLayoutData(data);

        snmpCheckQueueLengthText = new Text(composite3, SWT.BORDER | SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COUNT_TEXT_WIDTH;
        snmpCheckQueueLengthText.setLayoutData(gridData);

        snmpCheckThreadList =
            new List(
                composite3,
                SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
        data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = LIST_VERTICAL_SPAN;
        data.widthHint = LIST_SHORT_WIDTHHINT;
        data.heightHint =
            pingCheckThreadList.getItemHeight() * LIST_HEIGHT_HINT;
        snmpCheckThreadList.setLayoutData(data);

        label = new Label(composite4, SWT.NONE);
        label.setText("Snmp statistics check node");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite4, SWT.NONE);
        label.setText("Snmp statistics check queue");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        label.setLayoutData(gridData);

        label = new Label(composite4, SWT.NONE);
        label.setText("Snmp statistics check thread");
        gridData = new GridData();
        gridData.widthHint = LABEL_WIDTH;
        label.setLayoutData(gridData);

        snmpStatisticsCheckNodeText =
            new Text(composite4, SWT.BORDER | SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COUNT_TEXT_WIDTH;
        snmpStatisticsCheckNodeText.setLayoutData(gridData);
        snmpStatisticsCheckNodeList =
            new List(
                composite4,
                SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);

        data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = LIST_VERTICAL_SPAN;
        data.widthHint = LIST_WIDTHHINT;
        data.heightHint = pingCheckNodeList.getItemHeight() * LIST_HEIGHT_HINT;
        snmpStatisticsCheckNodeList.setLayoutData(data);

        snmpStatisticsCheckQueueLengthText =
            new Text(composite4, SWT.BORDER | SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COUNT_TEXT_WIDTH;
        snmpStatisticsCheckQueueLengthText.setLayoutData(gridData);

        snmpStatisticsCheckThreadList =
            new List(
                composite4,
                SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
        data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = LIST_VERTICAL_SPAN;
        data.widthHint = LIST_SHORT_WIDTHHINT;
        data.heightHint =
            pingCheckThreadList.getItemHeight() * LIST_HEIGHT_HINT;
        snmpStatisticsCheckThreadList.setLayoutData(data);

        /*
         * Scroll CompositeZbg
         */
        scrollComposite.setContent(baseComposite);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /*
         * XV{^Listener
         */
        refreshButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent e) {
                    logger = Logger.getLogger(this.getClass().getName());

                    refreshButton.setEnabled(false);
                    refreshView();
                    refreshButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.IWorkbenchPart#setFocus()
     */
    public void setFocus() {
    }

    /*
     * ViewXV܂B
     *
     */
    private void refreshView() {
        /* f[^x[XғeXgԃZbg */
        setDatabaseStatus();

        Thread trapThread =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.TRAP_RECEIVE_THREAD);

        if (trapThread == null) {
            trapReceiveStatusText.setText(INACITIVE);
        } else {
            if (trapThread.isAlive()) {
                trapReceiveStatusText.setText(ACITIVE);
            } else {
                trapReceiveStatusText.setText(INACITIVE);
            }
        }

        Thread commandThread =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.COMMAND_RECEIVE_THREAD);

        if (commandThread == null) {
            commandReceiveStatusText.setText(INACITIVE);
        } else {
            if (commandThread.isAlive()) {
                commandReceiveStatusText.setText(ACITIVE);
            } else {
                commandReceiveStatusText.setText(INACITIVE);
            }
        }

        Thread xmlThread =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.XML_SOCKET_THREAD);

        if (xmlThread == null) {
            xmlSocketStatusText.setText(INACITIVE);
        } else {
            if (xmlThread.isAlive()) {
                xmlSocketStatusText.setText(ACITIVE);
            } else {
                xmlSocketStatusText.setText(INACITIVE);
            }
        }

        Thread mailGuardThread =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.MAIL_GUARD_THREAD);

        if (mailGuardThread == null) {
            mailGuardStatusText.setText(INACITIVE);
        } else {
            if (mailGuardThread.isAlive()) {
                mailGuardStatusText.setText(ACITIVE);
            } else {
                mailGuardStatusText.setText(INACITIVE);
            }
        }

        Thread dataHoldPeriodThraed =
            (Thread) EngineThreadList.getInstance().getThread(
                EngineThreadList.DATABASE_LIMIT_CHECK_THREAD);

        if (dataHoldPeriodThraed == null) {
            dataHoldPeriodThreadStatusText.setText(INACITIVE);
        } else {
            if (dataHoldPeriodThraed.isAlive()) {
                dataHoldPeriodThreadStatusText.setText(ACITIVE);
            } else {
                dataHoldPeriodThreadStatusText.setText(INACITIVE);
            }
        }

        pingCheckNodeList.removeAll();

        Map list = ListQueuePingControl.getInstance().getPingHashMap();
        Iterator it = null;

        for (it = list.keySet().iterator(); it.hasNext();) {
            String key = (String) it.next();
            NodeWatchInfo nodeWatchInfo = (NodeWatchInfo) list.get(key);
            String work =
                nodeWatchInfo.getNodename() + "("
                + nodeWatchInfo.getIpaddress() + ")" + " period="
                + nodeWatchInfo.getPingPeriod() + "sec";
            pingCheckNodeList.add(work);
        }

        pingCheckNodeText.setText(
            Integer.toString(pingCheckNodeList.getItemCount()));

        /*
         * Snmp Config
         */
        snmpCheckNodeList.removeAll();
        list =
            ListQueueDefaultSnmpMibControl.getInstance()
                                          .getDefaultSnmpMibHashMap();
        it = null;

        for (it = list.keySet().iterator(); it.hasNext();) {
            String key = (String) it.next();
            NodeWatchInfo nodeWatchInfo = (NodeWatchInfo) list.get(key);
            String work =
                nodeWatchInfo.getNodename() + "("
                + nodeWatchInfo.getIpaddress() + ") period="
                + nodeWatchInfo.getSnmpPeriod() + "sec";
            snmpCheckNodeList.add(work);
        }

        snmpCheckNodeText.setText(
            Integer.toString(snmpCheckNodeList.getItemCount()));

        /*
         * Snmp Statistics
         */
        snmpStatisticsCheckNodeList.removeAll();
        list =
            ListQueueStatisticsMibControl.getInstance().getStatisticsMibHashMap();

        for (it = list.keySet().iterator(); it.hasNext();) {
            String key = (String) it.next();
            StatisticsMibInfo nodeWatchInfo = (StatisticsMibInfo) list.get(key);

            if (nodeWatchInfo.getOidList().size() > 0) {
                Iterator oidIt;
                Map oidList = nodeWatchInfo.getOidList();

                for (oidIt = oidList.keySet().iterator(); oidIt.hasNext();) {
                    String oidKey = (String) oidIt.next();
                    OidGetInfo oidGetInfo = (OidGetInfo) oidList.get(oidKey);
                    String work =
                        nodeWatchInfo.getNodeName() + "("
                        + nodeWatchInfo.getTargetIpAddress() + ") OID="
                        + oidKey + " period(sec)="
                        + oidGetInfo.getGetMibPeriod();
                    snmpStatisticsCheckNodeList.add(work);
                }
            }
        }

        snmpStatisticsCheckNodeText.setText(
            Integer.toString(snmpStatisticsCheckNodeList.getItemCount()));

        getThreadStatus();
    }

    /*
     * f[^x[XғeXgԂZbg܂B
     *
     */
    private void setDatabaseStatus() {
        ResourceInfo info =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();

        DatabaseTest databaseTest = new DatabaseTest(info.getDatabaseName());
        String[] testResult =
            databaseTest.checkDatabase(
                info.getDatabaseDriver(), info.getDatabaseUrl(),
                info.getDatabaseUser(), info.getDatabasePassword());

        int okPos = 0;
        databaseStatusText.setText(ACITIVE);

        for (int i = 0; i < testResult.length; i++) {
            logger.info("Phase " + i + " : " + testResult[i]);
            okPos = testResult[i].indexOf("OK");

            if (okPos < 0) {
                if (i == 0) {
                    continue;
                }

                databaseStatusText.setText(INACITIVE);

                break;
            }
        }
    }

    /*
     * ThraedXe[^XԂZbg܂B
     *
     */
    private void getThreadStatus() {
        String threadKey = null;
        Thread checkThread = null;

        /* Ping threadXgU폜 */
        pingCheckThreadList.removeAll();

        /* PingsThread queueTCYZbg */
        java.util.List queuelist =
            QueueForPing.getInstance().getPingQueueList();

        if (queuelist != null) {
            pingCheckQueueLengthText.setText(
                Integer.toString(queuelist.size()));
        }

        /* Ping thread map擾KeyZbg */
        threadKey = EngineThreadList.PING_QUEUE_THREAD;
        checkThread = (Thread) EngineThreadList.getInstance().getThread(threadKey);

        /* Ping Queue threadԃZbg */
        if (checkThread != null) {
            if (checkThread.isAlive()) {
                pingCheckThreadList.add(threadKey + THREAD_ALIVE);
            } else {
                pingCheckThreadList.add(threadKey + THREAD_NOALIVE);
            }
        }

        /* PingsthreadԃZbg */
        for (int i = 0; i < ManageEngineThread.PING_CHECK_THREAD_NO; i++) {
            threadKey = EngineThreadList.PING_EXEC_THREAD + i;
            checkThread =
                (Thread) EngineThreadList.getInstance().getThread(threadKey);

            if (checkThread != null) {
                if (checkThread.isAlive()) {
                    pingCheckThreadList.add(threadKey + THREAD_ALIVE);
                } else {
                    pingCheckThreadList.add(threadKey + THREAD_NOALIVE);
                }
            }
        }

        /*
         * SnmpftHg擾ThreadsqueueTCYZbg
         */
        queuelist =
            QueueForDefaultSnmpMib.getInstance().getSnmpConfigQueueList();

        if (queuelist != null) {
            snmpCheckQueueLengthText.setText(
                Integer.toString(queuelist.size()));
        }

        /* Snmp\ThreadXgU폜 */
        snmpCheckThreadList.removeAll();

        /*
         * Snmp\擾Threadmap擾
         */
        threadKey = EngineThreadList.SNMP_CONFIG_QUEUE_THREAD;
        checkThread = (Thread) EngineThreadList.getInstance().getThread(threadKey);

        /* Snmp\queue threadԃZbg */
        if (checkThread != null) {
            if (checkThread.isAlive()) {
                snmpCheckThreadList.add(threadKey + THREAD_ALIVE);
            } else {
                snmpCheckThreadList.add(threadKey + THREAD_NOALIVE);
            }
        }

        /* Snmp\̎ThreadԂXgɃZbg */
        for (int i = 0; i < ManageEngineThread.DEFAULT_SNMP_THREAD_NO; i++) {
            threadKey = EngineThreadList.SNMP_CONFIG_THREAD + i;
            checkThread =
                (Thread) EngineThreadList.getInstance().getThread(threadKey);

            if (checkThread != null) {
                if (checkThread.isAlive()) {
                    snmpCheckThreadList.add(threadKey + THREAD_ALIVE);
                } else {
                    snmpCheckThreadList.add(threadKey + THREAD_NOALIVE);
                }
            }
        }

        /* Snmpv̎ThreadsqueueTCYZbg */
        queuelist = QueueForStatisticsMib.getInstance().getSnmpStatisticsList();

        if (queuelist != null) {
            snmpStatisticsCheckQueueLengthText.setText(
                Integer.toString(queuelist.size()));
        }

        /* Snmpv̎ThreadXgU폜 */
        snmpStatisticsCheckThreadList.removeAll();

        /*
         * Snmpv̎Threadmap擾
         */
        threadKey = EngineThreadList.SNMP_STATISTICS_QUEUE_THREAD;
        checkThread = (Thread) EngineThreadList.getInstance().getThread(threadKey);

        /* Snmpv̎queue threadԃZbg */
        if (checkThread != null) {
            if (checkThread.isAlive()) {
                snmpStatisticsCheckThreadList.add(threadKey + THREAD_ALIVE);
            } else {
                snmpStatisticsCheckThreadList.add(threadKey + THREAD_NOALIVE);
            }
        }

        /* Snmpv̎ThreadԂXgɃZbg */
        for (int i = 0; i < ManageEngineThread.STATISTICS_MIB_THREAD_NO; i++) {
            threadKey = EngineThreadList.SNMP_STATISTICS_THREAD + i;
            checkThread =
                (Thread) EngineThreadList.getInstance().getThread(threadKey);

            if (checkThread != null) {
                if (checkThread.isAlive()) {
                    snmpStatisticsCheckThreadList.add(threadKey + THREAD_ALIVE);
                } else {
                    snmpStatisticsCheckThreadList.add(
                        threadKey + THREAD_NOALIVE);
                }
            }
        }
    }

    /**
     * Xe[^XC\Zbg܂B
     *
     */
    protected void setStatusLine() {
        /* Xe[^XC\ */
        statusLineManager =
            (SubStatusLineManager) (getViewSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(false);
    }

    /*
     * GWANVԂ܂B
     *
     * @return actionBuilderEngine GWANV
     */
    private ActionBuilderEngine getEngineActionBuilder() {
        return actionBuilderEngine;
    }

    /*
     * f[^x[XANVԂ܂B
     *
     * @return actionBuilderDatabase f[^x[XANV
     */
    private ActionBuilderDatabase getDatabaseActionBuilder() {
        return actionBuilderDatabase;
    }

    /*
     * ActionBarsZbg܂B
     */
    private void fillActionBars() {
        IActionBars actionBars = getViewSite().getActionBars();

        /* Engine ToolBarZbg */
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(getEngineActionBuilder().getActionStartEngine());
        toolBar.add(getEngineActionBuilder().getActionStopEngine());

        /* EditorPart CloseANV */
        toolBar.add(actionBuilderEditorPart.actionCloseAllEditors());

        IMenuManager menu = actionBars.getMenuManager();

        menu.add(getDatabaseActionBuilder().getActionStartHSQLDB());
        menu.add(getDatabaseActionBuilder().getActionStopHSQLDB());

        menu.add(new Separator());

        IMenuManager databaseSubMenu = new MenuManager("HSQLDB Manager");

        menu.add(databaseSubMenu);
        databaseSubMenu.add(
            getDatabaseActionBuilder().getActionStartHSQLDBManager());
        databaseSubMenu.add(
            getDatabaseActionBuilder().getActionStopHSQLDBManager());

        menu.add(new Separator());
        menu.add(getDatabaseActionBuilder().getActionStartDatabase());
    }
}
