/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view;

import java.io.IOException;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.model.DatabaseTest;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.database.access.model.hsqldb.HsqldbException;
import netjfwatcher.engine.command.control.CommnadReceiveServer;
import netjfwatcher.engine.mail.ThreadMailSendGuard;
import netjfwatcher.engine.model.action.ActionBuilderApacheDerby;
import netjfwatcher.engine.model.action.ActionBuilderDatabase;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.engine.model.action.EngineThreadList;
import netjfwatcher.engine.model.thread.TrapReceiveThread;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.server.holdperiod.ThreadPeriodHoldCheck;
import netjfwatcher.engine.server.protocol.control.QueueForDefaultSnmpMib;
import netjfwatcher.engine.server.protocol.control.QueueForHTTP;
import netjfwatcher.engine.server.protocol.control.QueueForPing;
import netjfwatcher.engine.server.protocol.control.QueueForPop3;
import netjfwatcher.engine.server.protocol.control.QueueForSmtp;
import netjfwatcher.engine.server.protocol.control.QueueForStatisticsMib;
import netjfwatcher.engine.server.xmlsocket.XMLSocketServer;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.snmpmanager.trap.TrapListenerImpl;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

/**
 * GWԂ̕\yѐsViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class GenericResourceView extends ViewPart {
	/** Text */
	public static final int TEXT_WIDTH = 120;

	/** ThreadԂAlive̎Description */
	public static final String ACITIVE = "Active";

	/** ThreadԂAlivełȂDescription */
	public static final String INACITIVE = "InActive";

	/** ĎGWAwakeԂłDescription */
	public static final String AWAKE = "awake";

	/** ĎGWSleepԂłDescription */
	public static final String SLEEP = "sleep";

	/* MO */
	private static Logger logger;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* VXe\[X */
	private ResourceInfo info;

	/* Engineԕ\Text */
	private Text engineStatusText;

	/* GWStart{^ */
	private Button engineStartButton;

	/* GWStop{^ */
	private Button engineStopButton;

	/* GWXV{^ */
	private Button refreshButton;

	/* f[^x[X\Text */
	private Text databaseNameText;

	/* f[^x[Xғԕ\text */
	private Text databaseStatusText;

	/* R}hM|[gԍ\Text */
	private Text commandReceivePortText;

	/* R}hMThreadԕ\Text */
	private Text commandReceiveStatusText;

	/* XML SocketM|[gԍ\Text */
	private Text xmlSocketPortText;

	/* XML SocketMThreadԕ\Text */
	private Text xmlSocketStatusText;

	/* MailMK[hԕ\Text */
	private Text mailGuardTimeText;

	/* MailMK[hԃJEgThreadԕ\Text */
	private Text mailGuardStatusText;

	/* A[/vێԊĎ\Text */
	private Text dataHoldPeriodThreadPeriodText;

	/* A[/vێԊĎThreadԕ\Text */
	private Text dataHoldPeriodThreadStatusText;

	/* TrapM|[gԍ\Text */
	private Text trapReceivePortText;

	/* TrapMThreadԕ\Text */
	private Text trapReceiveStatusText;

	/* f[^x[XN{^ */
	private Button databaseStartButton;

	/* f[^x[X~{^ */
	private Button databaseStopButton;

	/* R}hMThreadN{^ */
	private Button commandReceiveStartButton;

	/* R}hMThread~{^ */
	private Button commandReceiveStopButton;

	/* TrapMThreadN{^ */
	private Button trapReceiveStartButton;

	/* TrapMThread~{^ */
	private Button trapReceiveStopButton;

	/* XML SocketMThreadN{^ */
	private Button xmlSocketReceiveStartButton;

	/* XML SocketMThread~{^ */
	private Button xmlSocketReceiveStopButton;

	/* MailMK[h^CJEgThreadN{^ */
	private Button mailGuardStartButton;

	/* MailMK[h^CJEgThread~{^ */
	private Button mailGuardStopButton;

	/* A[/vێԃ`FbNThreadN{^ */
	private Button dataHoldPeriodStopButton;

	/* A[/vێԃ`FbNThread~{^ */
	private Button dataHoldPeriodStartButton;

	/* SNMPĎԕ\Text */
	private Text snmpStatusText;

	/* PingĎԕ\Text */
	private Text pingStatusText;

	/* HttpĎԕ\Text */
	private Text httpStatusText;

	/* SmtpĎԕ\Text */
	private Text smtpStatusText;

	/* Pop3Ďԕ\Text */
	private Text pop3StatusText;

	/* SNMPĎawake{^ */
	private Button snmpAwakeButton;

	/* SNMPĎsleep{^ */
	private Button snmpSleepButton;

	/* PingĎawake{^ */
	private Button pingAwakeButton;

	/* PingĎsleep{^ */
	private Button pingSleepButton;

	/* HTTPĎawake{^ */
	private Button httpAwakeButton;

	/* HTTPĎsleep{^ */
	private Button httpSleepButton;

	/* SMTPĎawake{^ */
	private Button smtpAwakeButton;

	/* SMTPĎsleep{^ */
	private Button smtpSleepButton;

	/* Pop3PĎawake{^ */
	private Button pop3AwakeButton;

	/* Pop3Ďsleep{^ */
	private Button pop3SleepButton;

	/*
	 * GWɊւANVr_[
	 */
	private ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();

	/* EditorPartANV */
	private ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();

	/*
	 * f[^x[XɊւANVr_[
	 */
	private ActionBuilderDatabase actionBuilderDatabase = new ActionBuilderDatabase();

	/*
	 * ApacheDerbyɊւANVr_[
	 */
	private ActionBuilderApacheDerby actionBuilderApacheDerby = new ActionBuilderApacheDerby();

	/**
	 * GWԂ̕\yѐsViewNXCX^X ܂B
	 */
	public GenericResourceView() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * PartControl𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* ANVo[Zbg */
		fillActionBars();

		/* Xe[^XCZbg */
		setStatusLine();

		/* VXe\[Xǂݍ */
		info = SystemResourceConfig.getInstance().getResourceFileParse()
				.getResourceInfo();

		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);
		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridLayout gridLayoutBase = new GridLayout(1, false);
		Composite baseComposite = new Composite(scrollComposite, SWT.LEFT);
		baseComposite.setLayout(gridLayoutBase);
		baseComposite.setLayoutData(new GridData(
				GridData.VERTICAL_ALIGN_BEGINNING));

		gridLayoutBase = new GridLayout(1, false);

		Composite subBaseComposite = new Composite(baseComposite, SWT.NULL);
		subBaseComposite.setLayout(gridLayoutBase);
		subBaseComposite.setLayoutData(new GridData());

		GridLayout gridLayout0 = new GridLayout(5, false);
		Composite composite0 = new Composite(subBaseComposite, SWT.NULL);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData());

		Group composite1 = new Group(subBaseComposite, SWT.NONE);
		composite1.setText("Engine Detail");
		composite1.setLayout(new GridLayout(7, false));
		composite1.setLayoutData(new GridData());

		Group composite2 = new Group(subBaseComposite, SWT.NONE);
		composite2.setText("Protocol Detail");
		composite2.setLayout(new GridLayout(4, false));
		composite2.setLayoutData(new GridData());

		Label label0 = new Label(composite0, SWT.NONE);
		label0.setText("Engine status");
		label0.setLayoutData(new GridData());
		engineStatusText = new Text(composite0, SWT.BORDER);

		GridData gridDataa = new GridData();
		gridDataa.horizontalSpan = 1;
		gridDataa.verticalSpan = 1;
		gridDataa.widthHint = TEXT_WIDTH;
		engineStatusText.setLayoutData(gridDataa);

		engineStartButton = new Button(composite0, SWT.NONE);
		engineStartButton.setText("start");
		gridDataa = new GridData();
		gridDataa.horizontalSpan = 1;
		gridDataa.verticalSpan = 1;
		engineStartButton.setLayoutData(gridDataa);
		engineStopButton = new Button(composite0, SWT.NONE);
		engineStopButton.setText("stop");
		gridDataa = new GridData();
		gridDataa.horizontalSpan = 1;
		gridDataa.verticalSpan = 1;
		engineStopButton.setLayoutData(gridDataa);

		/* Refresh{^zu */
		refreshButton = new Button(composite0, SWT.NONE);
		refreshButton.setText("Refresh");
		gridDataa = new GridData();
		gridDataa.horizontalSpan = 1;
		gridDataa.verticalSpan = 1;
		refreshButton.setLayoutData(gridDataa);

		/* Dummy */
		label0 = new Label(composite0, SWT.NONE);
		label0.setText("");
		label0.setLayoutData(new GridData());

		GridData gridData = new GridData();

		Label label = new Label(composite1, SWT.NONE);
		label.setText("Database");
		label.setLayoutData(new GridData());

		label = new Label(composite1, SWT.NONE);
		label.setText("status");
		label.setLayoutData(new GridData());

		databaseStatusText = new Text(composite1, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		databaseStatusText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Database name");
		label.setLayoutData(new GridData());
		databaseNameText = new Text(composite1, SWT.BORDER);
		databaseNameText.setText(info.getDatabaseName());
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		databaseNameText.setLayoutData(gridData);

		databaseStartButton = new Button(composite1, SWT.NONE);
		databaseStartButton.setText("start");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		databaseStartButton.setLayoutData(gridData);
		databaseStopButton = new Button(composite1, SWT.NONE);
		databaseStopButton.setText("stop");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		databaseStopButton.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Command receive server");
		label.setLayoutData(new GridData());

		label = new Label(composite1, SWT.NONE);
		label.setText("status");
		gridData = new GridData();
		label.setLayoutData(gridData);
		commandReceiveStatusText = new Text(composite1, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		commandReceiveStatusText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Command recive port");
		label.setLayoutData(new GridData());
		commandReceivePortText = new Text(composite1, SWT.BORDER);
		commandReceivePortText.setText(info.getEnginePort());
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		commandReceivePortText.setLayoutData(gridData);

		commandReceiveStartButton = new Button(composite1, SWT.NONE);
		commandReceiveStartButton.setText("start");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		commandReceiveStartButton.setLayoutData(gridData);
		commandReceiveStopButton = new Button(composite1, SWT.NONE);
		commandReceiveStopButton.setText("stop");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		commandReceiveStopButton.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Trap receive server");
		label.setLayoutData(new GridData());

		label = new Label(composite1, SWT.NONE);
		label.setText("status");
		gridData = new GridData();
		label.setLayoutData(gridData);
		trapReceiveStatusText = new Text(composite1, SWT.BORDER);

		Thread trapThread = (Thread) EngineThreadList.getInstance().getThread(
				EngineThreadList.TRAP_RECEIVE_THREAD);

		if (trapThread == null) {
			trapReceiveStatusText.setText(INACITIVE);
		} else {
			if (trapThread.isAlive()) {
				trapReceiveStatusText.setText(ACITIVE);
			} else {
				trapReceiveStatusText.setText(INACITIVE);
			}
		}

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		trapReceiveStatusText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Snmp Trap receive port");
		label.setLayoutData(new GridData());
		trapReceivePortText = new Text(composite1, SWT.BORDER);
		trapReceivePortText.setText(Integer.toString(info.getSnmpTrapPort()));
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		trapReceivePortText.setLayoutData(gridData);

		trapReceiveStartButton = new Button(composite1, SWT.NONE);
		trapReceiveStartButton.setText("start");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		trapReceiveStartButton.setLayoutData(gridData);
		trapReceiveStopButton = new Button(composite1, SWT.NONE);
		trapReceiveStopButton.setText("stop");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		trapReceiveStopButton.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("XML socket server");
		label.setLayoutData(new GridData());
		label = new Label(composite1, SWT.NONE);
		label.setText("status");
		gridData = new GridData();
		label.setLayoutData(gridData);
		xmlSocketStatusText = new Text(composite1, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		xmlSocketStatusText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("XML Socket port");
		label.setLayoutData(new GridData());
		xmlSocketPortText = new Text(composite1, SWT.BORDER);
		xmlSocketPortText.setText(info.getXmlSocketPort());
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		xmlSocketPortText.setLayoutData(gridData);

		xmlSocketReceiveStartButton = new Button(composite1, SWT.NONE);
		xmlSocketReceiveStartButton.setText("start");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		xmlSocketReceiveStartButton.setLayoutData(gridData);
		xmlSocketReceiveStopButton = new Button(composite1, SWT.NONE);
		xmlSocketReceiveStopButton.setText("stop");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		xmlSocketReceiveStopButton.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Mail guard thread");
		label.setLayoutData(new GridData());
		label = new Label(composite1, SWT.NONE);
		label.setText("status");
		gridData = new GridData();
		label.setLayoutData(gridData);
		mailGuardStatusText = new Text(composite1, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		mailGuardStatusText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Mail guard time(sec)");
		label.setLayoutData(new GridData());
		mailGuardTimeText = new Text(composite1, SWT.BORDER);
		mailGuardTimeText.setText(info.getMailGuardTime());
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		mailGuardTimeText.setLayoutData(gridData);

		mailGuardStartButton = new Button(composite1, SWT.NONE);
		mailGuardStartButton.setText("start");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		mailGuardStartButton.setLayoutData(gridData);
		mailGuardStopButton = new Button(composite1, SWT.NONE);
		mailGuardStopButton.setText("stop");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		mailGuardStopButton.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Data hold period thread");
		label.setLayoutData(new GridData());
		label = new Label(composite1, SWT.NONE);
		label.setText("status");
		gridData = new GridData();
		label.setLayoutData(gridData);
		dataHoldPeriodThreadStatusText = new Text(composite1, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		dataHoldPeriodThreadStatusText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Datahold period thread period(sec)");
		label.setLayoutData(new GridData());
		dataHoldPeriodThreadPeriodText = new Text(composite1, SWT.BORDER);
		dataHoldPeriodThreadPeriodText.setText(Long
				.toString(ThreadPeriodHoldCheck.WATCH_PERIOD / 1000));
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		dataHoldPeriodThreadPeriodText.setLayoutData(gridData);

		dataHoldPeriodStartButton = new Button(composite1, SWT.NONE);
		dataHoldPeriodStartButton.setText("start");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		dataHoldPeriodStartButton.setLayoutData(gridData);
		dataHoldPeriodStopButton = new Button(composite1, SWT.NONE);
		dataHoldPeriodStopButton.setText("stop");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		dataHoldPeriodStopButton.setLayoutData(gridData);

		setEngineComposite(composite2);

		scrollComposite.setContent(baseComposite);
		scrollComposite.setMinSize(700, 400);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		refreshView(true);

		setSelectionListener();
	}

	/*
	 * EngineĎԕ\CompositeZbg܂B
	 * 
	 * @param composite2 Composite
	 */
	private void setEngineComposite(Composite composite2) {
		/* SNMPĎ */
		Label label = new Label(composite2, SWT.NONE);
		label.setText("SNMP status");
		label.setLayoutData(new GridData());
		snmpStatusText = new Text(composite2, SWT.BORDER);

		GridData gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		snmpStatusText.setLayoutData(gridData);

		snmpAwakeButton = new Button(composite2, SWT.NONE);
		snmpAwakeButton.setText("Awake");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		snmpAwakeButton.setLayoutData(gridData);
		snmpSleepButton = new Button(composite2, SWT.NONE);
		snmpSleepButton.setText("Sleep");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		snmpSleepButton.setLayoutData(gridData);

		/* PingĎ */
		label = new Label(composite2, SWT.NONE);
		label.setText("Ping status");
		label.setLayoutData(new GridData());
		pingStatusText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		pingStatusText.setLayoutData(gridData);

		pingAwakeButton = new Button(composite2, SWT.NONE);
		pingAwakeButton.setText("Awake");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		pingAwakeButton.setLayoutData(gridData);
		pingSleepButton = new Button(composite2, SWT.NONE);
		pingSleepButton.setText("Sleep");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		pingSleepButton.setLayoutData(gridData);

		/* HTTPĎ */
		label = new Label(composite2, SWT.NONE);
		label.setText("HTTP status");
		label.setLayoutData(new GridData());
		httpStatusText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		httpStatusText.setLayoutData(gridData);

		httpAwakeButton = new Button(composite2, SWT.NONE);
		httpAwakeButton.setText("Awake");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		httpAwakeButton.setLayoutData(gridData);
		httpSleepButton = new Button(composite2, SWT.NONE);
		httpSleepButton.setText("Sleep");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		httpSleepButton.setLayoutData(gridData);

		/* SMTPĎ */
		label = new Label(composite2, SWT.NONE);
		label.setText("SMTP status");
		label.setLayoutData(new GridData());
		smtpStatusText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		smtpStatusText.setLayoutData(gridData);

		smtpAwakeButton = new Button(composite2, SWT.NONE);
		smtpAwakeButton.setText("Awake");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		smtpAwakeButton.setLayoutData(gridData);
		smtpSleepButton = new Button(composite2, SWT.NONE);
		smtpSleepButton.setText("Sleep");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		smtpSleepButton.setLayoutData(gridData);

		/* Pop3Ď */
		label = new Label(composite2, SWT.NONE);
		label.setText("Pop3 status");
		label.setLayoutData(new GridData());
		pop3StatusText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		pop3StatusText.setLayoutData(gridData);

		pop3AwakeButton = new Button(composite2, SWT.NONE);
		pop3AwakeButton.setText("Awake");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		pop3AwakeButton.setLayoutData(gridData);
		pop3SleepButton = new Button(composite2, SWT.NONE);
		pop3SleepButton.setText("Sleep");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		pop3SleepButton.setLayoutData(gridData);
	}

	/*
	 * {^SelectionListenerZbg܂B
	 * 
	 */
	private void setSelectionListener() {
		engineStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				engineStartButton.setEnabled(false);

				getEngineActionBuilder().getActionStartEngine().run();

				refreshView(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		engineStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				engineStopButton.setEnabled(false);

				getEngineActionBuilder().getActionStopEngine().run();
				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * f[^x[XJn{^Xi[
		 */
		databaseStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				databaseStartButton.setEnabled(false);

				startDatabase();

				refreshView(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * f[^x[X~{^Xi[
		 */
		databaseStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				databaseStopButton.setEnabled(false);

				stopDatabase();

				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		commandReceiveStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				commandReceiveStartButton.setEnabled(false);

				try {
					EngineThreadList.getInstance().removeThreadList(
							EngineThreadList.COMMAND_RECEIVE_THREAD);

					CommnadReceiveServer.getInstance().startThread();
					EngineThreadList.getInstance().setThreadList(
							EngineThreadList.COMMAND_RECEIVE_THREAD,
							CommnadReceiveServer.getInstance()
									.getCommandReceiveThread());
				} catch (IOException e1) {
					Shell shell = new Shell();
					MessageDialog.openError(shell,
							"Abort command receive thread start ", e1
									.getMessage());
					logger.warning("Abort command receive thread start "
							+ e1.getMessage());
					shell.dispose();
				}

				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		commandReceiveStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				commandReceiveStopButton.setEnabled(false);
				CommnadReceiveServer.getInstance().stopReceiving();
				EngineThreadList.getInstance().removeThreadList(
						EngineThreadList.COMMAND_RECEIVE_THREAD);
				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		trapReceiveStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				trapReceiveStartButton.setEnabled(false);

				// TrapMThread
				TrapReceiveThread trapthread;

				TrapListenerImpl listener = TrapListenerImpl.getInstance();
				trapthread = TrapReceiveThread.getInstance();

				// TrapMXi[iTrapM̎s\bhjo^
				try {
					EngineThreadList.getInstance().removeThreadList(
							EngineThreadList.TRAP_RECEIVE_THREAD);
					trapthread.startReceiving();
					trapthread.addTrapListener(listener);
					EngineThreadList.getInstance().setThreadList(
							EngineThreadList.TRAP_RECEIVE_THREAD,
							trapthread.getTrapReceiveThread());
				} catch (SocketException e1) {
					Shell shell = new Shell();
					MessageDialog
							.openError(shell,
									"Abort trap receive thread start ", e1
											.getMessage());
					logger.warning("Abort trap receive thread start "
							+ e1.getMessage());
					shell.dispose();
				}

				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		trapReceiveStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				trapReceiveStopButton.setEnabled(false);
				EngineThreadList.getInstance().removeThreadList(
						EngineThreadList.TRAP_RECEIVE_THREAD);

				TrapReceiveThread trapthread;
				trapthread = TrapReceiveThread.getInstance();

				trapthread.stopReceiving();

				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		xmlSocketReceiveStartButton
				.addSelectionListener(new SelectionListener() {
					public void widgetSelected(SelectionEvent event) {
						xmlSocketReceiveStartButton.setEnabled(false);

						try {
							EngineThreadList.getInstance().removeThreadList(
									EngineThreadList.XML_SOCKET_THREAD);
							XMLSocketServer.getInstance()
									.startXMLSocketServerThread();
							EngineThreadList.getInstance().setThreadList(
									EngineThreadList.XML_SOCKET_THREAD,
									XMLSocketServer.getInstance()
											.getXmlSocketServerThread());
						} catch (IOException e1) {
							Shell shell = new Shell();
							MessageDialog.openError(shell,
									"Abort XML socket receive thread start ",
									e1.getMessage());
							logger
									.warning("Abort XML socket receive thread start "
											+ e1.getMessage());
							shell.dispose();
						}

						refreshView(false);
					}

					public void widgetDefaultSelected(SelectionEvent event) {
					}
				});
		xmlSocketReceiveStopButton
				.addSelectionListener(new SelectionListener() {
					public void widgetSelected(SelectionEvent event) {
						xmlSocketReceiveStopButton.setEnabled(false);
						XMLSocketServer.getInstance()
								.stopXMLSocketServerReceiving();
						EngineThreadList.getInstance().removeThreadList(
								EngineThreadList.XML_SOCKET_THREAD);
						refreshView(false);
					}

					public void widgetDefaultSelected(SelectionEvent event) {
					}
				});
		mailGuardStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				mailGuardStartButton.setEnabled(false);
				EngineThreadList.getInstance().removeThreadList(
						EngineThreadList.MAIL_GUARD_THREAD);

				if (ThreadMailSendGuard.getInstance().startThread()) {
					EngineThreadList.getInstance().setThreadList(
							EngineThreadList.MAIL_GUARD_THREAD,
							ThreadMailSendGuard.getInstance()
									.getMailGuardThread());
				} else {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Abort Mail send guard time thread start");
					logger.warning("Abort XML socket receive thread start");
				}

				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		mailGuardStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				mailGuardStopButton.setEnabled(false);

				ThreadMailSendGuard.getInstance().stopReceiving();

				EngineThreadList.getInstance().removeThreadList(
						EngineThreadList.MAIL_GUARD_THREAD);

				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		dataHoldPeriodStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				dataHoldPeriodStartButton.setEnabled(false);

				EngineThreadList.getInstance().removeThreadList(
						EngineThreadList.DATABASE_LIMIT_CHECK_THREAD);

				ThreadPeriodHoldCheck.getInstance().startThread();

				EngineThreadList.getInstance().setThreadList(
						EngineThreadList.DATABASE_LIMIT_CHECK_THREAD,
						ThreadPeriodHoldCheck.getInstance()
								.getPeriodHoldCheckThread());

				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		dataHoldPeriodStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				dataHoldPeriodStopButton.setEnabled(false);
				ThreadPeriodHoldCheck.getInstance().stopReceiving();
				EngineThreadList.getInstance().removeThreadList(
						EngineThreadList.DATABASE_LIMIT_CHECK_THREAD);
				refreshView(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * XV{^Listener
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				logger = Logger.getLogger(this.getClass().getName());

				refreshButton.setEnabled(false);
				refreshView(true);
				refreshButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		snmpAwakeButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForDefaultSnmpMib.getInstance().setPause(false);
				QueueForStatisticsMib.getInstance().setPause(false);
				snmpStatusText.setText(AWAKE);
				snmpAwakeButton.setEnabled(false);
				snmpSleepButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		snmpSleepButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForDefaultSnmpMib.getInstance().setPause(true);
				QueueForStatisticsMib.getInstance().setPause(true);
				snmpStatusText.setText(SLEEP);
				snmpAwakeButton.setEnabled(true);
				snmpSleepButton.setEnabled(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		pingAwakeButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForPing.getInstance().setPause(false);

				pingStatusText.setText(AWAKE);
				pingAwakeButton.setEnabled(false);
				pingSleepButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		pingSleepButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForPing.getInstance().setPause(true);

				pingStatusText.setText(SLEEP);
				pingAwakeButton.setEnabled(true);
				pingSleepButton.setEnabled(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		httpAwakeButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForHTTP.getInstance().setPause(false);

				httpStatusText.setText(AWAKE);
				httpAwakeButton.setEnabled(false);
				httpSleepButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		httpSleepButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForHTTP.getInstance().setPause(true);

				httpStatusText.setText(SLEEP);
				httpAwakeButton.setEnabled(true);
				httpSleepButton.setEnabled(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		smtpAwakeButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForSmtp.getInstance().setPause(false);

				smtpStatusText.setText(AWAKE);
				smtpAwakeButton.setEnabled(false);
				smtpSleepButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		smtpSleepButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForSmtp.getInstance().setPause(true);

				smtpStatusText.setText(SLEEP);
				smtpAwakeButton.setEnabled(true);
				smtpSleepButton.setEnabled(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		pop3AwakeButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForPop3.getInstance().setPause(false);

				pop3StatusText.setText(AWAKE);
				pop3AwakeButton.setEnabled(false);
				pop3SleepButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		pop3SleepButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				QueueForPop3.getInstance().setPause(true);

				pop3StatusText.setText(SLEEP);
				pop3AwakeButton.setEnabled(true);
				pop3SleepButton.setEnabled(false);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void setFocus() {

		refreshButton.setEnabled(false);
		refreshView(true);
		refreshButton.setEnabled(true);
	}

	/**
	 * {^SĉsƂ܂B
	 * 
	 */
	public void setDisableAllButton() {
		engineStartButton.setEnabled(false);
		engineStopButton.setEnabled(false);
		databaseStartButton.setEnabled(false);
		databaseStopButton.setEnabled(false);
		trapReceiveStartButton.setEnabled(false);
		trapReceiveStopButton.setEnabled(false);
		commandReceiveStartButton.setEnabled(false);
		commandReceiveStopButton.setEnabled(false);
		xmlSocketReceiveStartButton.setEnabled(false);
		xmlSocketReceiveStopButton.setEnabled(false);
		mailGuardStartButton.setEnabled(false);
		mailGuardStopButton.setEnabled(false);
		dataHoldPeriodStartButton.setEnabled(false);
		dataHoldPeriodStopButton.setEnabled(false);
		snmpAwakeButton.setEnabled(false);
		snmpSleepButton.setEnabled(false);
		pingAwakeButton.setEnabled(false);
		pingSleepButton.setEnabled(false);
		httpAwakeButton.setEnabled(false);
		httpSleepButton.setEnabled(false);
		smtpAwakeButton.setEnabled(false);
		smtpSleepButton.setEnabled(false);
		pop3AwakeButton.setEnabled(false);
		pop3SleepButton.setEnabled(false);
	}

	/**
	 * GWԕ\XV܂B
	 * 
	 * @param isDatabaseTest
	 *            GWԕ\XVɂ f[^x[Xsۂ
	 */
	public void refreshView(boolean isDatabaseTest) {
		info = SystemResourceConfig.getInstance().getResourceFileParse()
				.getResourceInfo();

		if (EngineStatus.getInstance().isEngine()) {
			engineStatusText.setText(ACITIVE);
			engineStartButton.setEnabled(false);
			engineStopButton.setEnabled(true);
		} else {
			engineStatusText.setText(INACITIVE);
			engineStartButton.setEnabled(true);
			engineStopButton.setEnabled(false);
		}

		databaseNameText.setText(info.getDatabaseName());

		commandReceivePortText.setText(info.getEnginePort());
		xmlSocketPortText.setText(info.getXmlSocketPort());

		trapReceivePortText.setText(Integer.toString(info.getSnmpTrapPort()));

		mailGuardTimeText.setText(info.getMailGuardTime());
		dataHoldPeriodThreadPeriodText.setText(Long
				.toString(ThreadPeriodHoldCheck.WATCH_PERIOD / 1000));

		/*
		 * f[^x[Xs`FbN
		 */
		if (isDatabaseTest) {
			/* f[^x[Xs */
			DatabaseTest databaseTest = new DatabaseTest(info.getDatabaseName());
			String[] testResult = databaseTest.checkDatabase(info
					.getDatabaseDriver(), info.getDatabaseUrl(), info
					.getDatabaseUser(), info.getDatabasePassword());

			int okPos = 0;
			databaseStatusText.setText(ACITIVE);

			for (int i = 0; i < testResult.length; i++) {
				/*
				 * f[^x[Xł̃tF[Y̌ʃR[h 'OK'񂪊܂܂ΎOKŊ܂܂Ȃ
				 * ΃f[^x[Xғ󋵂ƂĂInactive
				 */
				logger.info("Phase " + i + " : " + testResult[i]);
				okPos = testResult[i].indexOf("OK");

				if (okPos < 0) {
					if (i == 0) {
						continue;
					}

					databaseStatusText.setText(INACITIVE);

					break;
				}
			}
		}

		String databaseKind = info.getDatabaseName();

		if (databaseKind.equals(AbstractDataAccessObject.HSQLDB)
				|| databaseKind.equals(AbstractDataAccessObject.DERBY)
				|| databaseKind.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
			/*
			 * f[^x[XHSQLDBAApache DerbyyEmbedded Derby̏ꍇ́A
			 * f[^x[XN/~͉\Ȃ̂ ̂ŋN/~{^NԂɂ킹ăZbg
			 */
			if (databaseStatusText.getText().equals(ACITIVE)) {
				databaseStartButton.setEnabled(false);
				databaseStopButton.setEnabled(true);
			} else {
				databaseStartButton.setEnabled(true);
				databaseStopButton.setEnabled(false);
			}
		} else {
			/*
			 * f[^x[XHSQLDBȊȌꍇ́A f[^x[XN/~͕s ̂ŋN/~{^fBXG[u
			 */
			databaseStartButton.setEnabled(false);
			databaseStopButton.setEnabled(false);
		}

		Thread trapThread = (Thread) EngineThreadList.getInstance().getThread(
				EngineThreadList.TRAP_RECEIVE_THREAD);

		/*
		 * TrapMThreadԂɂ킹ĕ\yу{^Zbg
		 */
		if (trapThread == null) {
			trapReceiveStatusText.setText(INACITIVE);
			trapReceiveStartButton.setEnabled(true);
			trapReceiveStopButton.setEnabled(false);
		} else {
			if (trapThread.isAlive()) {
				trapReceiveStatusText.setText(ACITIVE);
				trapReceiveStartButton.setEnabled(false);
				trapReceiveStopButton.setEnabled(true);
			} else {
				trapReceiveStatusText.setText(INACITIVE);
				trapReceiveStartButton.setEnabled(true);
				trapReceiveStopButton.setEnabled(false);
			}
		}

		/*
		 * R}hMThreadԂɂ킹ĕ\yу{^Zbg
		 */
		Thread commandThread = (Thread) EngineThreadList.getInstance()
				.getThread(EngineThreadList.COMMAND_RECEIVE_THREAD);

		if (commandThread == null) {
			commandReceiveStatusText.setText(INACITIVE);
			commandReceiveStartButton.setEnabled(true);
			commandReceiveStopButton.setEnabled(false);
		} else {
			if (commandThread.isAlive()) {
				commandReceiveStatusText.setText(ACITIVE);
				commandReceiveStartButton.setEnabled(false);
				commandReceiveStopButton.setEnabled(true);
			} else {
				commandReceiveStatusText.setText(INACITIVE);
				commandReceiveStartButton.setEnabled(true);
				commandReceiveStopButton.setEnabled(false);
			}
		}

		/*
		 * XML SocketMThreadԂɂ킹ĕ\yу{^Zbg
		 */
		Thread xmlThread = (Thread) EngineThreadList.getInstance().getThread(
				EngineThreadList.XML_SOCKET_THREAD);

		if (xmlThread == null) {
			xmlSocketStatusText.setText(INACITIVE);
			xmlSocketReceiveStartButton.setEnabled(true);
			xmlSocketReceiveStopButton.setEnabled(false);
		} else {
			if (xmlThread.isAlive()) {
				xmlSocketStatusText.setText(ACITIVE);
				xmlSocketReceiveStartButton.setEnabled(false);
				xmlSocketReceiveStopButton.setEnabled(true);
			} else {
				xmlSocketStatusText.setText(INACITIVE);
				xmlSocketReceiveStartButton.setEnabled(true);
				xmlSocketReceiveStopButton.setEnabled(false);
			}
		}

		/*
		 * MailMK[h^CJEgThreadԂɂ킹ĕ\ yу{^Zbg
		 */
		Thread mailGuardThread = (Thread) EngineThreadList.getInstance()
				.getThread(EngineThreadList.MAIL_GUARD_THREAD);

		if (mailGuardThread == null) {
			mailGuardStatusText.setText(INACITIVE);
			mailGuardStartButton.setEnabled(true);
			mailGuardStopButton.setEnabled(false);
		} else {
			if (mailGuardThread.isAlive()) {
				mailGuardStatusText.setText(ACITIVE);
				mailGuardStartButton.setEnabled(false);
				mailGuardStopButton.setEnabled(true);
			} else {
				mailGuardStatusText.setText(INACITIVE);
				mailGuardStartButton.setEnabled(true);
				mailGuardStopButton.setEnabled(false);
			}
		}

		/*
		 * A[/vێԃ`FbNThreadԂɂ킹 \yу{^Zbg
		 */
		Thread dataHoldPeriodThraed = (Thread) EngineThreadList.getInstance()
				.getThread(EngineThreadList.DATABASE_LIMIT_CHECK_THREAD);

		if (dataHoldPeriodThraed == null) {
			dataHoldPeriodThreadStatusText.setText(INACITIVE);
			dataHoldPeriodStartButton.setEnabled(true);
			dataHoldPeriodStopButton.setEnabled(false);
		} else {
			if (dataHoldPeriodThraed.isAlive()) {
				dataHoldPeriodThreadStatusText.setText(ACITIVE);
				dataHoldPeriodStartButton.setEnabled(false);
				dataHoldPeriodStopButton.setEnabled(true);
			} else {
				dataHoldPeriodThreadStatusText.setText(INACITIVE);
				dataHoldPeriodStartButton.setEnabled(true);
				dataHoldPeriodStopButton.setEnabled(false);
			}
		}

		if (QueueForDefaultSnmpMib.getInstance().isPause()
				&& QueueForStatisticsMib.getInstance().isPause()) {
			snmpStatusText.setText(SLEEP);
			snmpAwakeButton.setEnabled(true);
			snmpSleepButton.setEnabled(false);
		} else {
			snmpStatusText.setText(AWAKE);
			snmpAwakeButton.setEnabled(false);
			snmpSleepButton.setEnabled(true);
		}

		if (QueueForPing.getInstance().isPause()) {
			pingStatusText.setText(SLEEP);
			pingAwakeButton.setEnabled(true);
			pingSleepButton.setEnabled(false);
		} else {
			pingStatusText.setText(AWAKE);
			pingAwakeButton.setEnabled(false);
			pingSleepButton.setEnabled(true);
		}

		if (QueueForHTTP.getInstance().isPause()) {
			httpStatusText.setText(SLEEP);
			httpAwakeButton.setEnabled(true);
			httpSleepButton.setEnabled(false);
		} else {
			httpStatusText.setText(AWAKE);
			httpAwakeButton.setEnabled(false);
			httpSleepButton.setEnabled(true);
		}

		if (QueueForSmtp.getInstance().isPause()) {
			smtpStatusText.setText(SLEEP);
			smtpAwakeButton.setEnabled(true);
			smtpSleepButton.setEnabled(false);
		} else {
			smtpStatusText.setText(AWAKE);
			smtpAwakeButton.setEnabled(false);
			smtpSleepButton.setEnabled(true);
		}

		if (QueueForPop3.getInstance().isPause()) {
			pop3StatusText.setText(SLEEP);
			pop3AwakeButton.setEnabled(true);
			pop3SleepButton.setEnabled(false);
		} else {
			pop3StatusText.setText(AWAKE);
			pop3AwakeButton.setEnabled(false);
			pop3SleepButton.setEnabled(true);
		}
	}

	/*
	 * f[^x[XN܂B
	 * 
	 */
	private void startDatabase() {
		String databaseKind = info.getDatabaseName();

		if (databaseKind.equals(AbstractDataAccessObject.HSQLDB)) {
			logger.info("HSQLDB Start task");

			try {
				HsqldbControl.getInstance().startHsqlDB();
			} catch (HsqldbException e3) {
				Shell shell = new Shell();
				MessageDialog.openInformation(shell, "Hsqldb Status", e3
						.getMessage());
				shell.dispose();
			}
		} else if (databaseKind.equals(AbstractDataAccessObject.DERBY)) {
			try {
				ApacheDerbyNetworkServer.getInstance()
						.startDerbyNetworkServer();
			} catch (Exception e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error",
						"Abort start Apache Derby " + e.getMessage());
				shell.dispose();
			}
		} else if (databaseKind.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
			try {
				ApacheDerbyEmbeddedDerby.getInstance().startEmbeddedDerby();
			} catch (Exception e) {
				Shell shell = new Shell();
				MessageDialog.openInformation(shell, "Apache Derby Status", e
						.getMessage());
				shell.dispose();
			}
		}
	}

	/*
	 * f[^x[X~܂B
	 * 
	 */
	private void stopDatabase() {
		String databaseKind = info.getDatabaseName();

		if (databaseKind.equals(AbstractDataAccessObject.HSQLDB)) {
			try {
				HsqldbControl.getInstance().stopHsqlDB();
				databaseStatusText.setText(INACITIVE);
			} catch (ClassNotFoundException e3) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e3.getMessage());
				shell.dispose();
			} catch (SQLException e3) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e3.getMessage());
				shell.dispose();
			}
		} else if (databaseKind.equals(AbstractDataAccessObject.DERBY)) {
			try {
				ApacheDerbyNetworkServer.getInstance().stopDerbyNetworkServer();
			} catch (Exception e) {
				e.printStackTrace();

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e.getMessage());
				shell.dispose();
			}
		} else if (databaseKind.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
			try {
				ApacheDerbyEmbeddedDerby.getInstance().stopEmbeddedDerby();
			} catch (Exception e) {
				e.printStackTrace();

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e.getMessage());
				shell.dispose();
			}
		}
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\ */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(false);
	}

	/*
	 * GWɊւANVԂ܂B
	 * 
	 * @return actionBuilderEngine GWɊւANV
	 */
	private ActionBuilderEngine getEngineActionBuilder() {
		return actionBuilderEngine;
	}

	/*
	 * ANVBarZbg܂B
	 * 
	 */
	private void fillActionBars() {
		IActionBars actionBars = getViewSite().getActionBars();

		/* Engine ToolBarZbg */
		IToolBarManager toolBar = actionBars.getToolBarManager();
		toolBar.add(getEngineActionBuilder().getActionStartEngine());
		toolBar.add(getEngineActionBuilder().getActionStopEngine());

		/* EditorPart CloseANV */
		toolBar.add(actionBuilderEditorPart.actionCloseAllEditors());

		IMenuManager menu = actionBars.getMenuManager();

		/* HSQLDB Start/Stop */
		IMenuManager hsqldbSubMenu = new MenuManager("HSQLDB");
		menu.add(hsqldbSubMenu);
		hsqldbSubMenu.add(getDatabaseActionBuilder().getActionStartHSQLDB());
		hsqldbSubMenu.add(getDatabaseActionBuilder().getActionStopHSQLDB());

		/* HSQLDB Manager */
		IMenuManager hsqldbManagerSubMenu = new MenuManager("HSQLDB Manager");
		hsqldbSubMenu.add(hsqldbManagerSubMenu);
		hsqldbManagerSubMenu.add(getDatabaseActionBuilder()
				.getActionStartHSQLDBManager());
		hsqldbManagerSubMenu.add(getDatabaseActionBuilder()
				.getActionStopHSQLDBManager());

		menu.add(new Separator());

		/* Embedded Apache Derby Start/Stop */
		IMenuManager embeddedApacheDerbySubMenu = new MenuManager(
				"Embedded Apache Derby");
		menu.add(embeddedApacheDerbySubMenu);
		embeddedApacheDerbySubMenu.add(getApacheDerbyActionBuilder()
				.getActionEmbeddedStartApacheDerby());
		embeddedApacheDerbySubMenu.add(getApacheDerbyActionBuilder()
				.getActionEmbeddedStopApacheDerby());

		menu.add(new Separator());

		/* Apache Derby Network server Start/Stop */
		IMenuManager apacheDerbySubMenu = new MenuManager(
				"Apache Derby Network server");
		menu.add(apacheDerbySubMenu);
		apacheDerbySubMenu.add(getApacheDerbyActionBuilder()
				.getActionStartApacheDerby());
		apacheDerbySubMenu.add(getApacheDerbyActionBuilder()
				.getActionStopApacheDerby());
		apacheDerbySubMenu.add(getApacheDerbyActionBuilder()
				.getActionSysInfoApacheDerby());

		menu.add(new Separator());

		/* Database Start */
		menu.add(getDatabaseActionBuilder().getActionStartDatabase());
	}

	/*
	 * f[^x[XɊւANVԂ܂B
	 * 
	 * @return actionBuilderDatabase f[^x[XɊւANV
	 */
	private ActionBuilderDatabase getDatabaseActionBuilder() {
		return actionBuilderDatabase;
	}

	/*
	 * Apache DerbyɊւANVԂ܂B
	 * 
	 * @return actionBuilderApacheDerby Apache DerbyɊւANV
	 */
	private ActionBuilderApacheDerby getApacheDerbyActionBuilder() {
		return actionBuilderApacheDerby;
	}
}
