/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.node;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.nodecontrol.NodeAdd;
import netjfwatcher.engine.nodecontrol.NodeDelete;
import netjfwatcher.engine.nodecontrol.NodeEdit;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.snmp.preference.SnmpPreference;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;



/**
 * m[h̒ǉAҏWyэ폜sViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeOperationView extends ViewPart {
    /** ftHgm[hO[v */
    public static final String INITIAL_NODE_GROUP = "Default Group";

    /** ftHgGWAhX */
    public static final String INITIAL_ENGINE_ADDRESS = "localhost";

    /** ftHgPingĎ */
    public static final String INITIAL_NODE_PING_PERIOD = "0";

    /** ftHgPingĎ臒l */
    public static final String INITIAL_NODE_PING_THRESHOLD = "20";

    /** ftHgSNMPĎ */
    public static final String INITIAL_NODE_SNMP_PERIOD = "300";

    /** ftHgHTTPĎ */
    public static final String INITIAL_NODE_HTTP_PERIOD = "0";

    /** ftHgHTTPĎ|[g */
    public static final String INITIAL_NODE_HTTP_PORT = "80";

    /** ftHgHTTPĎURL */
    public static final String INITIAL_NODE_HTTP_URL = "http://";

    /** ftHgSMTPĎ */
    public static final String INITIAL_NODE_SMTP_PERIOD = "0";

    /** ftHgPop3Ď */
    public static final String INITIAL_NODE_POP_PERIOD = "0";

    /** ftHgSNMPkÎx */
    public static final String INITIAL_NODE_SNMP_LEVEL = "0";

    /** ftHgSNMP ReadR~jeB */
    public static final String INITIAL_NODE_SNMP_ROCOMMUNITY = "public";

    /** ftHgSNMP WriteR~jeB */
    public static final String INITIAL_NODE_SNMP_RWCOMMUNITY = "private";

    /** SNMP Agent List */
    public static final int AGENT_LIST_WIDTH = 200;

    /** SNMP Agent ListXp */
    public static final int AGENT_LIST_VERTICALSPAN = 7;

    /** eLXg */
    public static final int TEXT_WIDTH1 = 120;

    /* MO */
    private static Logger logger;

    /*
     * f[^x[X擾m[hĎ
     * i[Xg
     */
    private ArrayList nodeInfoFromDatabaseList;

    /*
     * AgentAhXǉAҏWyэ폜
     * AhX`FbNXg
     */
    private HashMap checkAddressList = new HashMap();

    /* AgentAhXXg\Xg */
    private List agentAddressList;

    /* m[h\eLXg */
    private Text nodeNameText;

    /* m[hIP Address\eLXg */
    private Text nodeIPAddressText;

    /* m[hO[v\eLXg */
    private Text nodeGroupText;

    /* m[hʕ\eLXg */
    private Combo nodeKindCombo;

    /* PingĎ\eLXg */
    private Text pingPeriodText;

    /* PingĎ臒l\eLXg */
    private Text pingThresholdText;

    /* SNMP Version\ComboBox */
    private Combo snmpVersionCombo;

    /* SNMPĎx\ComboBox */
    private Combo snmpLevelCombo;

    /* SNMPĎ\eLXg */
    private Text snmpPeriodText;

    /* SNMP ReadR~jeB\eLXg */
    private Text snmpROCommunityText;

    /* SNMP R/WR~jeB\eLXg */
    private Text snmpRWCommunityText;

    /* HTTPĎURL\eLXg */
    private Text httpUrlText;

    /* HTTPĎ|[g\eLXg */
    private Text httpPortText;

    /* HTTPĎ\eLXg */
    private Text httpPeriodText;

    /* POPĎ\eLXg */
    private Text pop3PeriodText;

    /* SMTPĎ\eLXg */
    private Text smtpPeriodText;

    /* AgentXg[h{^ */
    private Button loadAgentAddressListButton;

    /* m[hǉ{^ */
    private Button addButton;

    /* m[hҏW{^ */
    private Button editButton;

    /* m[h폜{^ */
    private Button deleteButton;

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridData gridData = null;

        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite(scrollComposite, SWT.NONE);
        composite0.setLayout(gridLayout0);
        composite0.setLayoutData(
            new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.VERTICAL_ALIGN_FILL));

        GridLayout gridLayout = new GridLayout(4, true);
        Composite composite1 = new Composite(composite0, SWT.NONE);
        composite1.setLayout(gridLayout);
        composite1.setLayoutData(
            new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.VERTICAL_ALIGN_FILL));

        GridLayout gridLayout2 = new GridLayout(5, false);
        Composite composite2 = new Composite(composite0, SWT.NONE);
        composite2.setLayoutData(
            new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.VERTICAL_ALIGN_FILL));
        composite2.setLayout(gridLayout2);

        gridData = new GridData();

        Label label = new Label(composite1, SWT.NONE);
        label.setText("Agent address list");
        label.setLayoutData(new GridData());

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        agentAddressList =
            new List(composite1, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);

        GridData data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = AGENT_LIST_VERTICALSPAN;
        data.widthHint = AGENT_LIST_WIDTH;
        data.heightHint = agentAddressList.getItemHeight() * 8;

        agentAddressList.select(0);
        agentAddressList.setLayoutData(data);

        /* Button */
        loadAgentAddressListButton = new Button(composite1, SWT.NONE);
        loadAgentAddressListButton.setText("Agent address list load");
        data = new GridData();
        data.horizontalSpan = 3;
        loadAgentAddressListButton.setLayoutData(data);

        addButton = new Button(composite1, SWT.NONE);
        addButton.setText("Node Add");
        data = new GridData();
        data.horizontalSpan = 3;
        addButton.setLayoutData(data);

        editButton = new Button(composite1, SWT.NONE);
        editButton.setText("Node Edit");
        data = new GridData();
        data.horizontalSpan = 3;
        editButton.setLayoutData(data);

        deleteButton = new Button(composite1, SWT.NONE);
        deleteButton.setText("Node Delete");
        data = new GridData();
        data.horizontalSpan = 3;
        deleteButton.setLayoutData(data);

        label = new Label(composite2, SWT.NONE);
        label.setText("Node Name");
        gridData = new GridData();
        label.setLayoutData(gridData);

        nodeNameText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeNameText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Ping");

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pingPeriodText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pingPeriodText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Node IPAddress");
        gridData = new GridData();
        label.setLayoutData(gridData);

        nodeIPAddressText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeIPAddressText.setLayoutData(gridData);

        // Ping label verticalSpan dummy
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Threshold");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pingThresholdText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pingThresholdText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Group");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        nodeGroupText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeGroupText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Snmp");

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Version");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpVersionCombo = new Combo(composite2, SWT.DROP_DOWN | SWT.READ_ONLY);

        snmpVersionCombo.add("V1");
        snmpVersionCombo.add("V2");
        snmpVersionCombo.add("V3");
        snmpVersionCombo.select(0);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpVersionCombo.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Node Kind");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        nodeKindCombo = new Combo(composite2, SWT.DROP_DOWN | SWT.READ_ONLY);

        HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();
        Iterator it;

        for (it = nodeIconMap.keySet().iterator(); it.hasNext();) {
            String key = (String) it.next();
            nodeKindCombo.add(key);
        }

        nodeKindCombo.select(0);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeKindCombo.setLayoutData(gridData);

        // Snmp label verticalSpan dummy
        label = new Label(composite2, SWT.NONE);
        label.setText("");

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 4;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Level");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        // snmpLevelText = new Text(composite2, SWT.BORDER);
        snmpLevelCombo = new Combo(composite2, SWT.DROP_DOWN | SWT.READ_ONLY);

        snmpLevelCombo.add(SnmpPreference.SNMP_LEVEL0_DESCRIPTION);
        snmpLevelCombo.add(SnmpPreference.SNMP_LEVEL1_DESCRIPTION);
        snmpLevelCombo.add(SnmpPreference.SNMP_LEVEL2_DESCRIPTION);
        snmpLevelCombo.select(0);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpLevelCombo.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpPeriodText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpPeriodText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("RO Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpROCommunityText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpROCommunityText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("RW Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpRWCommunityText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpRWCommunityText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Http");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("URL");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        httpUrlText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        httpUrlText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        httpPortText = new Text(composite2, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        httpPortText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        httpPeriodText = new Text(composite2, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        httpPeriodText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Pop3");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pop3PeriodText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pop3PeriodText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("SMTP");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpPeriodText = new Text(composite2, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpPeriodText.setLayoutData(gridData);

        scrollComposite.setContent(composite0);
        scrollComposite.setMinSize(800, 600);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /* VieweLXgɃftHglZbg */
        setTextDefaultNodeInfo();

        /*
         * AgentAhX[hăXgɕ\{^
         * Listener
         */
        loadAgentAddressListButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    loadAgentAddressListButton.setEnabled(false);
                    addButton.setEnabled(false);
                    editButton.setEnabled(false);
                    deleteButton.setEnabled(false);

                    try {
                        setAgentNodeList();
                    } finally {
                        addButton.setEnabled(true);
                        editButton.setEnabled(true);
                        deleteButton.setEnabled(true);
                        loadAgentAddressListButton.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /* AgentAhXXgIListener */
        agentAddressList.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    int index = agentAddressList.getSelectionIndex();

                    NodeInformation nodeInfo =
                        (NodeInformation) nodeInfoFromDatabaseList.get(index);

                    if (
                        (nodeInfo.getPingPeriod() == null)
                            || nodeInfo.getPingPeriod().equals("--")
                            || nodeInfo.getPingPeriod().equals("null")) {
                        nodeInfo.setPingPeriod("0");
                    }

                    if (
                        (nodeInfo.getSnmpPeriod() == null)
                            || nodeInfo.getSnmpPeriod().equals("--")
                            || nodeInfo.getSnmpPeriod().equals("null")) {
                        nodeInfo.setSnmpPeriod("0");
                    }

                    if (
                        (nodeInfo.getPopPeriod() == null)
                            || nodeInfo.getPopPeriod().equals("--")
                            || nodeInfo.getPopPeriod().equals("null")) {
                        nodeInfo.setPopPeriod("0");
                    }

                    if (
                        (nodeInfo.getSmtpPeriod() == null)
                            || nodeInfo.getSmtpPeriod().equals("--")
                            || nodeInfo.getSmtpPeriod().equals("null")) {
                        nodeInfo.setSmtpPeriod("0");
                    }

                    if (
                        (nodeInfo.getHttpPeriod() == null)
                            || nodeInfo.getHttpPeriod().equals("--")
                            || nodeInfo.getHttpPeriod().equals("null")) {
                        nodeInfo.setHttpPeriod("0");
                    }

                    if (
                        (nodeInfo.getHttpPort() == null)
                            || nodeInfo.getHttpPort().equals("--")
                            || nodeInfo.getHttpPort().equals("null")) {
                        nodeInfo.setHttpPort("");
                    }

                    setTextNodeInfo(nodeInfo);
                }
            });

        /* Agentǉ{^Xi[ */
        addButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    addButton.setEnabled(false);
                    editButton.setEnabled(false);
                    deleteButton.setEnabled(false);
                    loadAgentAddressListButton.setEnabled(false);

                    String addIPAddress = nodeIPAddressText.getText();

                    try {
                        setAgentNodeList();

                        if ((addIPAddress == null) || addIPAddress.equals("")) {
                            MessageDialog.openError(
                                getSite().getShell(), "Error",
                                "Illegal IP Address");

                            return;
                        }

                        if (checkAddressList.containsKey(addIPAddress)) {
                            MessageDialog.openError(
                                getSite().getShell(), "Error",
                                "Already IP Address = " + addIPAddress);

                            return;
                        }

                        NodeInformation addNodeInfo = createNodeInfo();

                        NodeAdd nodeAddInstance = NodeAdd.getInstance();
                        nodeAddInstance.addNode(addNodeInfo, true);

                        setAgentNodeList();
                        setTextDefaultNodeInfo();
                    } finally {
                        addButton.setEnabled(true);
                        editButton.setEnabled(true);
                        deleteButton.setEnabled(true);
                        loadAgentAddressListButton.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /* AgentҏW{^Xi[ */
        editButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    addButton.setEnabled(false);
                    editButton.setEnabled(false);
                    deleteButton.setEnabled(false);
                    loadAgentAddressListButton.setEnabled(false);

                    String addIPAddress = nodeIPAddressText.getText();

                    try {
                        if ((addIPAddress == null) || addIPAddress.equals("")) {
                            MessageDialog.openError(
                                getSite().getShell(), "Error",
                                "Illegal IP Address");

                            return;
                        }

                        if (!checkAddressList.containsKey(addIPAddress)) {
                            MessageDialog.openError(
                                getSite().getShell(), "Error",
                                "Not found IP Address = " + addIPAddress);

                            return;
                        }

                        NodeInformation addNodeInfo = createNodeInfo();
                        NodeEdit editNodeInstance = NodeEdit.getInstance();

                        try {
                            editNodeInstance.editNodeInfo(addNodeInfo);
                            setAgentNodeList();
                        } catch (DatabaseConnectionException e1) {
                            MessageDialog.openError(
                                getSite().getShell(), "Error",
                                "DatabaseConnectionException " + e1
                                + " IP Address = " + addIPAddress);
                        } catch (SQLException e1) {
                            MessageDialog.openError(
                                getSite().getShell(), "Error",
                                "SQLException " + e1.getMessage()
                                + " IP Address = " + addIPAddress);
                        }
                    } finally {
                        addButton.setEnabled(true);
                        editButton.setEnabled(true);
                        deleteButton.setEnabled(true);
                        loadAgentAddressListButton.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /* Agent폜{^Xi[ */
        deleteButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    addButton.setEnabled(false);
                    editButton.setEnabled(false);
                    deleteButton.setEnabled(false);
                    loadAgentAddressListButton.setEnabled(false);

                    try {
                        String addIPAddress = nodeIPAddressText.getText();

                        if ((addIPAddress == null) || addIPAddress.equals("")) {
                            Shell shell = new Shell();
                            MessageDialog.openError(
                                shell, "Error", "Illegal IP Address");
                            deleteButton.setEnabled(true);

                            return;
                        }

                        if (!checkAddressList.containsKey(addIPAddress)) {
                            Shell shell = new Shell();
                            MessageDialog.openError(
                                shell, "Error",
                                "Not found IP Address = " + addIPAddress);
                            deleteButton.setEnabled(true);

                            return;
                        }

                        NodeDelete del = NodeDelete.getInstance();
                        del.removeThreadList(addIPAddress);
                        setAgentNodeList();
                    } finally {
                        addButton.setEnabled(true);
                        editButton.setEnabled(true);
                        deleteButton.setEnabled(true);
                        loadAgentAddressListButton.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    /*
     * Text\Zbg܂B
     */
    private void setTextDefaultNodeInfo() {
        nodeKindCombo.select(0);
        snmpVersionCombo.select(0);
        snmpLevelCombo.select(0);

        nodeGroupText.setText(INITIAL_NODE_GROUP);
        pingPeriodText.setText(INITIAL_NODE_PING_PERIOD);
        pingThresholdText.setText(INITIAL_NODE_PING_THRESHOLD);
        snmpPeriodText.setText(INITIAL_NODE_SNMP_PERIOD);
        snmpROCommunityText.setText(INITIAL_NODE_SNMP_ROCOMMUNITY);
        snmpRWCommunityText.setText(INITIAL_NODE_SNMP_RWCOMMUNITY);
        httpUrlText.setText(INITIAL_NODE_HTTP_URL);
        httpPortText.setText(INITIAL_NODE_HTTP_PORT);
        httpPeriodText.setText(INITIAL_NODE_HTTP_PERIOD);
        pop3PeriodText.setText(INITIAL_NODE_POP_PERIOD);
        smtpPeriodText.setText(INITIAL_NODE_SMTP_PERIOD);
    }

    /*
     * Agentm[hXgZbg܂B
     *
     */
    private void setAgentNodeList() {
        /* Agentm[hXgUClear */
        agentAddressList.removeAll();

        if (nodeInfoFromDatabaseList != null) {
            nodeInfoFromDatabaseList.clear();
        }

        checkAddressList.clear();

        nodeInfoFromDatabaseList = getNodeList();

        for (int i = 0; i < nodeInfoFromDatabaseList.size(); i++) {
            NodeInformation nodeInfo =
                (NodeInformation) nodeInfoFromDatabaseList.get(i);

            /* Agent Address ListZbg */
            agentAddressList.add(
                nodeInfo.getNodename() + " : " + nodeInfo.getIpaddress());

            /* m[hǉAҏWyэ폜AddressL`FbNListZbg */
            checkAddressList.put(nodeInfo.getIpaddress(), nodeInfo);
        }
    }

    /*
     * View Textf[^Ƀm[hĎ𐶐ĕԂ܂B
     *
     * @return workNodeInfo m[hĎ
     */
    private NodeInformation createNodeInfo() {
        NodeInformation workNodeInfo = new NodeInformation();

        workNodeInfo.setIpaddress(nodeIPAddressText.getText());
        workNodeInfo.setNodename(nodeNameText.getText());

        String engineAddress = INITIAL_ENGINE_ADDRESS;

        try {
            /*
             * gAddressGWAddressƂ
             */
            engineAddress = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            logger.warning(e.getMessage());
        }

        workNodeInfo.setEngineAddress(engineAddress);
        workNodeInfo.setGroup(nodeGroupText.getText());

        workNodeInfo.setNodeKind(nodeKindCombo.getText());

        workNodeInfo.setPingPeriod(pingPeriodText.getText());
        workNodeInfo.setPingThreshold(pingThresholdText.getText());
        workNodeInfo.setSnmpPeriod(snmpPeriodText.getText());
        workNodeInfo.setRoCommunity(snmpROCommunityText.getText());
        workNodeInfo.setRwCommunity(snmpRWCommunityText.getText());

        int snmpVersion = snmpVersionCombo.getSelectionIndex();

        switch (snmpVersion) {
        case 0:
            workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV1_DESCRIPTION);

            break;

        case 1:
            workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV2_DESCRIPTION);

            break;

        case 2:
            workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV3_DESCRIPTION);

            break;

        default:
            logger.warning("Illegal SNMP Version Index " + snmpVersion);
        }

        String snmpLevel = snmpLevelCombo.getText();

        if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL0_DESCRIPTION)) {
            workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL0_CODE_STRING);
        } else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL1_DESCRIPTION)) {
            workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL1_CODE_STRING);
        } else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL2_DESCRIPTION)) {
            workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL2_CODE_STRING);
        } else {
            workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL0_CODE_STRING);
        }

        workNodeInfo.setHttpUrl(httpUrlText.getText());
        workNodeInfo.setHttpPort(httpPortText.getText());
        workNodeInfo.setHttpPeriod(httpPeriodText.getText());
        workNodeInfo.setPopPeriod(pop3PeriodText.getText());
        workNodeInfo.setSmtpPeriod(smtpPeriodText.getText());

        return workNodeInfo;
    }


    private void setTextNodeInfo(NodeInformation refreshNodeInfo) {
        nodeNameText.setText(refreshNodeInfo.getNodename());
        nodeIPAddressText.setText(refreshNodeInfo.getIpaddress());
        nodeGroupText.setText(refreshNodeInfo.getGroup());

        if (refreshNodeInfo.getNodeKind() != null) {
            nodeKindCombo.setText(refreshNodeInfo.getNodeKind());
        }

        if (refreshNodeInfo.getPingPeriod() != null) {
            pingPeriodText.setText(refreshNodeInfo.getPingPeriod());
        }

        if (refreshNodeInfo.getPingThreshold() != null) {
            pingThresholdText.setText(refreshNodeInfo.getPingThreshold());
        }

        if (refreshNodeInfo.getSnmpVersion() != null) {
            if (
                refreshNodeInfo.getSnmpVersion().equals(
                        SnmpPreference.SNMPV1_DESCRIPTION)) {
                snmpVersionCombo.select(0);
            } else if (
                refreshNodeInfo.getSnmpVersion().equals(
                        SnmpPreference.SNMPV2_DESCRIPTION)) {
                snmpVersionCombo.select(1);
            } else if (
                refreshNodeInfo.getSnmpVersion().equals(
                        SnmpPreference.SNMPV3_DESCRIPTION)) {
                snmpVersionCombo.select(2);
            }
        }

        if (refreshNodeInfo.getSnmpLevel() != null) {
            if (
                refreshNodeInfo.getSnmpLevel().equals(
                        SnmpPreference.SNMP_LEVEL0_CODE_STRING)) {
                snmpLevelCombo.select(0);
            } else if (
                refreshNodeInfo.getSnmpLevel().equals(
                        SnmpPreference.SNMP_LEVEL1_CODE_STRING)) {
                snmpLevelCombo.select(1);
            } else if (
                refreshNodeInfo.getSnmpLevel().equals(
                        SnmpPreference.SNMP_LEVEL2_CODE_STRING)) {
                snmpLevelCombo.select(2);
            }
        }

        if (refreshNodeInfo.getSnmpPeriod() != null) {
            snmpPeriodText.setText(refreshNodeInfo.getSnmpPeriod());
        }

        if (refreshNodeInfo.getRoCommunity() != null) {
            snmpROCommunityText.setText(refreshNodeInfo.getRoCommunity());
        }

        if (refreshNodeInfo.getRwCommunity() != null) {
            snmpRWCommunityText.setText(refreshNodeInfo.getRwCommunity());
        }

        if (refreshNodeInfo.getHttpUrl() != null) {
            httpUrlText.setText(refreshNodeInfo.getHttpUrl());
        }

        if (refreshNodeInfo.getHttpPort() != null) {
            httpPortText.setText(refreshNodeInfo.getHttpPort());
        }

        if (refreshNodeInfo.getHttpPeriod() != null) {
            httpPeriodText.setText(refreshNodeInfo.getHttpPeriod());
        }

        if (refreshNodeInfo.getPopPeriod() != null) {
            pop3PeriodText.setText(refreshNodeInfo.getPopPeriod());
        }

        if (refreshNodeInfo.getSmtpPeriod() != null) {
            smtpPeriodText.setText(refreshNodeInfo.getSmtpPeriod());
        }
    }

    /**
     * tH[JXZbgꂽ̏łB
     */
    public void setFocus() {
    }

    /**
     * m[hĎ񃊃XgԂ܂B
     *
     * @return m[hĎ񃊃Xg
     */
    private ArrayList getNodeList() {
        DBTableNodeRegister nodeRegisterDBTable =
            DBTableNodeRegister.getInstance();
        ArrayList nodeList = null;

        try {
            nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
        } catch (SQLException e1) {
            MessageDialog.openError(
                getSite().getShell(), "Node List import error", e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();
        } catch (Exception e1) {
            MessageDialog.openError(
                getSite().getShell(), "Node List import error", e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();
        } finally {
            nodeRegisterDBTable = null;
        }

        return nodeList;
    }
}
