/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.integer;

import java.math.BigInteger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
 * ASN.1 Type(^O)ɂCOUNTER64(^O)ɑΉ64-bitJE^SNMPIuWFNg
 * 삷郁\bhNXłB
 *
 * @see netjfwatcher.snmp.snmpobject.integer.SnmpGauge32
 * @see netjfwatcher.snmp.snmpobject.integer.SnmpCounter32
 */
public class SnmpCounter64 extends SnmpInteger {
    // maximum value is 2^64 - 1; using approximation!!
    private static BigInteger maxValue = new BigInteger("18446744070000000000");

    /**
     * l0SNMP COUNTER64IuWFNg𐶐܂B
     */
    public SnmpCounter64() {
        this(0); // initialize value to 0
        tag = SnmpBERCodec.SNMPCOUNTER64_TAG;
        tagDescription = SnmpBERCodec.SNMPCOUNTER64;
    }

    /**
     * w̒lSNMP COUNTER64IuWFNg𐶐܂B
     *
     * @param newValue l
     */
    public SnmpCounter64(long newValue) {
        integerValue = new BigInteger(Long.toString(newValue));

        // wrap if value > maxValue
        integerValue = integerValue.mod(maxValue);
        tag = SnmpBERCodec.SNMPCOUNTER64_TAG;
        tagDescription = SnmpBERCodec.SNMPCOUNTER64;
    }

    /**
     * ASN.1 BER encodingf[^ɂSNMP COUNTER64IuWFNg𐶐܂B
     *
     * @param enc ASN.1 BER encodingf[^
     * @throws SnmpBadValueException SNMP COUNTER64IuWFNgɎsꍇ
     */
    public SnmpCounter64(byte[] enc) throws SnmpBadValueException {
        extractValueFromBEREncoding(enc);

        // wrap if value > maxValue
        integerValue = integerValue.mod(maxValue);
        tag = SnmpBERCodec.SNMPCOUNTER64_TAG;
        tagDescription = SnmpBERCodec.SNMPCOUNTER64;
    }

    /**
     * SNMP COUNTER64IuWFNgɃf[^Zbg܂B
    *
    * @param newValue ZbgIuWFNgl
    * @throws SnmpBadValueException f[^ZbgɎsꍇ
     */
    public void setValue(Object newValue) throws SnmpBadValueException {
        if (newValue instanceof BigInteger) {
            integerValue = (BigInteger) newValue;
            integerValue = integerValue.mod(maxValue); // wrap when value exceeds 2^64
        } else if (newValue instanceof Integer) {
            integerValue = new BigInteger(newValue.toString());
            integerValue = integerValue.mod(maxValue); // wrap when value exceeds 2^64
        } else if (newValue instanceof String) {
            try {
                integerValue = new BigInteger((String) newValue);
                integerValue = integerValue.mod(maxValue); // wrap when value exceeds 2^64
            } catch (NumberFormatException e) {
                throw new SnmpBadValueException(
                    " Counter64: bad object supplied to set value ");
            }
        } else {
            throw new SnmpBadValueException(
                " Counter64: bad object supplied to set value ");
        }
    }
}
