/*
 * Created on 2004/03/18
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.process;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.logging.Logger;

import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpPreference;

import org.jdom.Document;


/**
 * SNMP^G[WFgƂĂThreadNXłB
 * ^G[WFgƂThread삵A}l[W̃R}hMA
 * Ԃ\bh܂B
 * ܂ASNMPV3^G[WFgƂẮAEngine SysupTimeyEngineBoots
 * 񐔂Ǘ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ThreadAgent extends DataStringDisplay implements Runnable {
    // MO
    private static Logger logger;

    /* SnmppUDP Socket */
    private DatagramSocket dSocket;

    /* \[XɋLqꂽڑ}l[WIP Address */
    private String allowHost;

    /* ^G[WFgThread */
    private Thread agentThread;

    /* Snmp V3pEngine SysupTime */
    private long startEngineTime = System.currentTimeMillis();

    /* SnmppUDP Socket Portԍ */
    private int snmpPort = SnmpPreference.SNMP_PORT;

    /**
     * SnmpG[WFgThreadCX^X𐶐܂B
     * \[XڑzXgAhXǂݍ݂܂B
     * ܂ASnmp V3pEngine BootsJEgAbv܂B
     */
    private ThreadAgent() {
        logger = Logger.getLogger(this.getClass().getName());

        /*
         * \[XڑzXgAhXǂݍ
         */
        SnmpAgentConfigInfo info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();
        allowHost = info.getAllowHost();
    }

    /**
     * Trap receive thread̏ԂԂ܂B
     *
     * @return Trap receive thread
     * true :ThreadN
     * false:Thread~
     */
    public boolean checkThread() {
        if ((agentThread == null) || !agentThread.isAlive()) {
            return false;
        }

        return true;
    }

    /**
     * SNMPG[WFgThreadX^[g܂B
     *
     * @return ThreadN boolean
     * true :ThreadN
     * false:ThreadNs
     * @throws SocketException SocketɎsꍇ
     */
    public synchronized boolean startThread(boolean isExceptionThrow)
        throws SocketException {
        if ((agentThread == null) || !agentThread.isAlive()) {
            if (dSocket == null) {
                try {
                    /* Snmp Portԍ\[X񂩂擾 */
                    snmpPort =
                        SystemResourceConfig.getInstance().getResourceFileParse()
                                            .getResourceInfo().getSnmpPort();
                    dSocket = new DatagramSocket(snmpPort);
                    logger.info("Socket create, port=" + snmpPort);
                    dSocket.setSoTimeout(0);
                } catch (SocketException e) {
                    logger.warning(
                        "Abort start agnet thread : " + e.getMessage()
                        + " Snmp port=" + snmpPort);
                    e.printStackTrace();

                    if (isExceptionThrow) {
                        throw e;
                    }

                    return false;
                }
            } else {
                logger.info("Already Socket create, port =" + snmpPort);
            }

            logger.info("Agent Thread Start");
            agentThread = new Thread(getInstance());
            agentThread.start();

            /* SNMP AgentX^[gBoots񐔂JEgAbv */
            SnmpAgentConfigInfo info =
                SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                                 .getSnmpAgentResourceInfo();
            updateSnmpEngineBoots(info);
        }

        return true;
    }

    /**
     * SnmpG[WFgThread~܂B
     *
     */
    public void stopReceiving() {
        logger.info("Agent thread stop");

        // interrupt receive thread so it will die a natural death
        if (agentThread != null) {
            agentThread.interrupt();

            agentThread = null;
        }

        if (dSocket != null) {
            dSocket.close();

            dSocket = null;
        }
    }

    /**
    * Permits setting timeout value for underlying datagram
    * socket (in milliseconds).
    *
    * @param socketTimeout Socket Timeoutݒl
    * @throws SocketException Socket Timeoutݒ肪sꍇ
    */
    public void setSocketTimeout(final int socketTimeout)
        throws SocketException {
        dSocket.setSoTimeout(socketTimeout);
    }

    /**
    * Close the "connection" with the devive.
    */
    public void closeConnection() {
        dSocket.close();
    }

    /**
     * SNMP}l[W烊NGXgM҂܂B
     *
     */
    public void run() {
        /*
         * SNMP}l[W̃R}hM҂[v
         */
        while ((agentThread != null) && !agentThread.isInterrupted()) {
            DatagramPacket inPacket =
                new DatagramPacket(
                    new byte[SnmpPreference.IN_DATA_PACKET_MAX],
                    SnmpPreference.IN_DATA_PACKET_MAX);

            AgentDispatcher agentDispacher = new AgentDispatcher(dSocket);

            try {
                dSocket.receive(inPacket);

                String remoteIPAddress = inPacket.getAddress().getHostAddress();

                logger.info("allowHost : " + allowHost);
                logger.info(
                    "Remote IP Address(Manager IP Address) : "
                    + remoteIPAddress);

                boolean isAllowClient = true;

                if (
                    !allowHost.equals("all")
                        && !remoteIPAddress.equals("127.0.0.1")) {
                    /*
                     * ڑzXgAll̎Ɛڑ悪localhost
                     * ꍇȊOł́Aڑ`FbN
                     */
                    String[] checkRemoteAddress =
                        remoteIPAddress.split("[.]", 4);
                    String[] allowRemoteAddress = allowHost.split("[.]", 4);

                    for (int i = 0; i < allowRemoteAddress.length; i++) {
                        if (!allowRemoteAddress[i].equals("*")) {
                            if (
                                !allowRemoteAddress[i].equals(
                                        checkRemoteAddress[i])) {
                                /* ڑĂȂzXgAhX */
                                logger.info(
                                    "Reject Connect Remote address : "
                                    + remoteIPAddress);
                                logger.info(
                                    "Reject Allow host address : " + allowHost);
                                isAllowClient = false;

                                break;
                            }
                        }
                    }
                }

                if (!isAllowClient) {
                    // ڑzXgłȂꍇAClient ڑ
                    logger.info("Client connect reject : " + remoteIPAddress);
                    dSocket.close();
                } else {
                    /*
                     * ڑzXg̏ꍇAMf[^́AN
                     */
                    byte[] encodedMessage = inPacket.getData();

                    agentDispacher.dispath(
                        inPacket, encodedMessage, inPacket.getLength());
                }
            } catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
            } catch (SocketException e) {
                logger.warning(e.getMessage());

                e.printStackTrace();

                break;
            } catch (IOException e) {
                logger.warning(e.getMessage());

                e.printStackTrace();

                break;
            } catch (Exception e) {
                logger.warning(e.getMessage());

                e.printStackTrace();

                break;
            }
        } // ڑ҂while loop
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ThreadAgent getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * SnmpG[WFgƂč\t@CBoot񐔂ǂݏoăJEgAbvA
     * t@CXV܂B
     *
     * @param info SNMP Agent\
     */
    private void updateSnmpEngineBoots(final SnmpAgentConfigInfo info) {
        /*  */
        SnmpV3AgentConfigInfo snmpV3ConfigInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();
        int engineBoots = 0;

        try {
            engineBoots =
                Integer.parseInt(snmpV3ConfigInfo.getSnmpEngineBoots());
        } catch (NumberFormatException e1) {
            logger.warning("snmpEngineBoots illegal");
        }

        engineBoots++;
        snmpV3ConfigInfo.setSnmpEngineBoots(Integer.toString(engineBoots));

        Document dom =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .updateDocument(info, snmpV3ConfigInfo);

        // t@Co̓obt@
        BufferedWriter bufWriter = null;
        bufWriter =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getResourceFileWriter();

        // XMLt@Co
        SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                         .outputXMLFile(bufWriter, dom);

        if (bufWriter != null) {
            try {
                bufWriter.close();
            } catch (IOException e) {
                logger.warning(
                    "Abort close BufferedWriter for snmp V3 EngineBoots : "
                    + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * SnmpG[WFgNԂԂ܂B
     *
     * @return startEngineTime SnmpG[WFgN
     */
    public long getStartEngineTime() {
        return startEngineTime;
    }

    /**
     * SnmpG[WFgNԂZbg܂B
     *
     * @param startEngineTime SnmpG[WFgN
     */
    public void setStartEngineTime(final long startEngineTime) {
        this.startEngineTime = startEngineTime;
    }

    /*
     *  (non-Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (dSocket != null) {
            dSocket.close();

            dSocket = null;
        }

        agentThread = null;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ThreadAgent RESOURCE = new ThreadAgent();
    }
}
