/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionExportAlarmInfoSocket;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarmSocket;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionShowNodeViewSocket;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionShowNodeSnmpViewSocket;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionSnmpStatisticsSetSocket;
import netjfwatcher.engine.nodemaneger.list.NodeListTableView;
import netjfwatcher.engine.nodemaneger.list.NodeListTableViewContentProvider;
import netjfwatcher.engine.nodemaneger.list.NodeListTableViewLabelProvider;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchActionConstants;



/**
 * lbg[NoRł̃m[hXge[u ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetworkClientNodeListTableView extends NodeListTableView {
    /* MO */
    private static Logger logger = null;

    /* Xe[^XC}l[W */
    private SubStatusLineManager statusLineManager;

    /**
     * lbg[NoRł̃m[hXge[u ViewNX
     * CX^X𐫃Z܂B
     */
    public NetworkClientNodeListTableView() {
        logger = Logger.getLogger(this.getClass().getName());
        textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
    }

    /**
     * r[ꂽƂɂ܂sꃁ\bhłB
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {

        /* m[hList Table */
        createTable(parent);
        viewer = new TableViewer(table);
        viewer.setUseHashlookup(true);

        /* m[hList Table ContentProviderZbg */
        viewer.setContentProvider(new NodeListTableViewContentProvider());

        /* xEtHgȂǂݒ */
        viewer.setLabelProvider(new NodeListTableViewLabelProvider());

        /* m[hXgbZ[WJImage */
        createImage();

        /* ContextMenuZbg */
        createContextMenu();

        /* ToolBarZbg */
        setToolBarActions();

        /* m[hĎ񃊃XgZbg */
        setNodeListView(false);

        /*
         * TableōsNbNꂽꍇ̏
         */
        table.addSelectionListener(
            new TableColumnControlTableListener(
                table, NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS));
    }

    /**
     * ContextMenu𐶐܂B
     *
     */
    private void createContextMenu() {
        /* j[}l[W */
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);

        /* j[}l[WXi[Zbg */
        mm.addMenuListener(
            new IMenuListener() {
                /**
                 * j[Xi[łB
                 *
                 * @param manager IMenuManager
                 */
                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);
                }
            });

        /*
         * ReLXgj[𐶐Zbg
         */
        Menu menu = mm.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        getSite().registerContextMenu(mm, viewer);
    }

    /**
     * j[o[
     * preWindowOpenɌĂ΂܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

        /* m[hList\j[ǉ */
        manager.add(nodeListAction.getActionShowNodeListTable());

        /* m[hImport(m[hꊇo^)j[ǉ */
        manager.add(nodeListAction.getActionImportNodeListFileSocket());

        /* m[hExportj[ǉ */
        manager.add(nodeListAction.getActionExportNodeListFileSocket());

        /* m[h상j[ǉ */
        // manager.add(nodeListAction.getActionNodeOperation());
        /* m[hǉEҏWE폜j[ǉ */
        manager.add(actionBuilderNodeOperation.getActionNodeOperationSocket());

        // nodeListAction.setSelectIPAddress(null);

        /*
         * m[hListe[uI񒊏o
         */
        if ((table.getSelectionIndex() >= 0) && (table.getSelection() != null)) {
            TableItem[] item = table.getSelection();

            // for (int i = 0; i < item.length; i++) {
            String[] nodeInfo = (String[]) item[0].getData();
            selectIPAddress =
                nodeInfo[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_IPADDRESS];

            NodeInformation targetNodeInfo =
                (NodeInformation) nodeInfoIPAddressMap.get(selectIPAddress);

            ((ActionNodeOperation) actionBuilderNodeOperation
            .getActionNodeOperation()).setNodeInfo(targetNodeInfo);

            /* m[h\\j[ǉ */
            ((ActionShowNodeViewSocket) actionBuilderNodeOperation
            .getActionShowNodeViewSocket()).setNodeInfo(targetNodeInfo);
            manager.add(
                actionBuilderNodeOperation.getActionShowNodeViewSocket());

            /* m[hSNMP\j[ǉ */
            ((ActionShowNodeSnmpViewSocket) snmpAction.getActionSnmpInfoSocket())
            .setNodeInfo(targetNodeInfo);
            manager.add(snmpAction.getActionSnmpInfoSocket());

            /* m[hAlarm\j[ǉ */
            ((ActionOpenEditorPartPersonalNodeAlarmSocket) alarmAction
            .getActionOpenEditorPartPersonalNodeAlarmSocket()).setNodeInfo(
                targetNodeInfo);
            manager.add(
                alarmAction.getActionOpenEditorPartPersonalNodeAlarmSocket());

            /* m[hAlarm ExportANV */
            ((ActionExportAlarmInfoSocket) alarmAction
            .getActionExportAlarmSocket()).setIpAddress(selectIPAddress);
            manager.add(alarmAction.getActionExportAlarmSocket());

            /* m[hPingj[ǉ */
            nodePingMenu.createPingMenu(manager, targetNodeInfo, true);

            /* m[hSnmpv\j[ǉ */
            nodeSnmpStatisticsMenu.createSnmpStatisticsMenu(
                manager, targetNodeInfo, true);

            /*
             * m[hSnmpvZbgj[j[}l[W
             * ɒǉ
             */
            ((ActionSnmpStatisticsSetSocket) snmpAction
            .getActionSnmpStatisticsSetSocket()).setNodeInfo(targetNodeInfo);
            manager.add(snmpAction.getActionSnmpStatisticsSetSocket());
        }

        /* Sm[hAlarm\ */
        manager.add(alarmAction.getActionShowAllNodeAlarmListTableSocket());

        /* Snmpv\ */
        manager.add(snmpAction.getActionSnmpStatisticsSocket());
    }

    /**
     * ToolBarANV̏s܂B
     *
     */
    private void setToolBarActions() {
        IToolBarManager toolBarManager =
            getViewSite().getActionBars().getToolBarManager();

        /* ToolBarManagerɃANVZbg */
        toolBarManager.add(nodeListAction.getActionShowNodeListTable());
        toolBarManager.add(nodeListAction.getActionImportNodeListFileSocket());
        toolBarManager.add(nodeListAction.getActionExportNodeListFileSocket());
        toolBarManager.add(
            alarmAction.getActionShowAllNodeAlarmListTableSocket());

        /* Alarm ExportANV */
        ((ActionExportAlarmInfoSocket) alarmAction.getActionExportAlarmSocket())
        .setIpAddress(DBTableAlarm.ALL_NODE);
        toolBarManager.add(alarmAction.getActionExportAlarmSocket());

        /* Editor part closeANV */
        toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
    }

    /**
     * f[^x[XNode listǂݍŕԂ܂B
     *
     * @return nodeList m[hXg
     */
    public ArrayList getNodeList() {
        ArrayList nodeList = null;
        String engineAddress =
            ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();

        try {
            ConnectionNodeInformation connectNodeInfo =
                new ConnectionNodeInformation(engineAddress);
            nodeList = connectNodeInfo.getNodeInformationList(null, null);
        } catch (EngineConnectException e) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Node List import error",
                e.getMessage() + " Engine = " + engineAddress);
            logger.warning("Node List import error" + e.getMessage());
            shell.dispose();
            e.printStackTrace();
        } catch (IOException e) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Node List import error",
                e.getMessage() + " Engine = " + engineAddress);
            logger.warning("Node List import error" + e.getMessage());
            shell.dispose();
            e.printStackTrace();
        }

        return nodeList;
    }
    

}
