/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSCoreFileModificationValidator;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSResourceRuleFactory;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.EditorsInfo;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Commit;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.AdminKSubstListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.EditorsListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistoryProvider;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.MoveDeleteHook;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;
import org.eclipse.team.internal.ccvs.core.util.SyncFileWriter;
import org.eclipse.team.internal.core.streams.CRLFtoLFInputStream;
import org.eclipse.team.internal.core.streams.LFtoCRLFInputStream;

public class CVSTeamProvider
extends RepositoryProvider {
    private static final ResourceRuleFactory RESOURCE_RULE_FACTORY = new CVSResourceRuleFactory();
    private static final boolean IS_CRLF_PLATFORM = Arrays.equals(System.getProperty("line.separator").getBytes(), new byte[]{13, 10});
    public static final IStatus OK = new Status(0, "org.eclipse.team.cvs.core", 0, CVSMessages.ok, null);
    private CVSWorkspaceRoot workspaceRoot;
    private IProject project;
    private static MoveDeleteHook moveDeleteHook = new MoveDeleteHook();
    private static CVSCoreFileModificationValidator fileModificationValidator;
    private static CVSFileHistoryProvider fileHistoryProvider;
    private static final QualifiedName FETCH_ABSENT_DIRECTORIES_PROP_KEY;
    private static final QualifiedName WATCH_EDIT_PROP_KEY;
    private static final QualifiedName TEMP_SHARED;

    static {
        FETCH_ABSENT_DIRECTORIES_PROP_KEY = new QualifiedName("org.eclipse.team.cvs.core", "fetch_absent_directories");
        WATCH_EDIT_PROP_KEY = new QualifiedName("org.eclipse.team.cvs.core", "watch_edit");
        TEMP_SHARED = new QualifiedName("org.eclipse.team.cvs.core", "tempShare");
    }

    public static boolean isSharedWithCVS(IProject project) {
        if (project.isAccessible()) {
            RepositoryProvider provider;
            if (RepositoryProvider.isShared((IProject)project) && (provider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId())) != null) {
                return true;
            }
            try {
                Object sessionProperty = project.getSessionProperty(TEMP_SHARED);
                return sessionProperty != null && sessionProperty.equals(Boolean.TRUE);
            }
            catch (CoreException e) {
                CVSProviderPlugin.log(e);
            }
        }
        return false;
    }

    public static void markAsTempShare(IProject project) {
        if (RepositoryProvider.isShared((IProject)project)) {
            return;
        }
        try {
            project.setSessionProperty(TEMP_SHARED, (Object)Boolean.TRUE);
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
        }
    }

    protected static CVSCoreFileModificationValidator internalGetFileModificationValidator() {
        if (fileModificationValidator == null) {
            fileModificationValidator = new CVSCoreFileModificationValidator();
        }
        return fileModificationValidator;
    }

    public void deconfigure() {
    }

    public void deconfigured() {
        try {
            EclipseSynchronizer.getInstance().deconfigure(this.getProject(), null);
            this.internalSetWatchEditEnabled(null);
            this.internalSetFetchAbsentDirectories(null);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        ResourceStateChangeListeners.getListener().projectDeconfigured(this.getProject());
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        try {
            this.workspaceRoot = new CVSWorkspaceRoot((IContainer)project);
            if (this.workspaceRoot.getLocalRoot().getFolderSyncInfo() == null) {
                CVSProviderPlugin.log((CoreException)((Object)new CVSException((IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.CVSTeamProvider_noFolderInfo, (Object[])new String[]{project.getName()})))));
            }
        }
        catch (CVSException cVSException) {}
    }

    public ICVSRepositoryLocation getRemoteLocation() throws CVSException {
        try {
            return this.workspaceRoot.getRemoteLocation();
        }
        catch (CVSException e) {
            try {
                RepositoryProvider.unmap((IProject)this.project);
            }
            catch (TeamException ex) {
                CVSProviderPlugin.log((CoreException)((Object)ex));
            }
            throw e;
        }
    }

    public CVSWorkspaceRoot getCVSWorkspaceRoot() {
        return this.workspaceRoot;
    }

    private void checkIsChild(IResource resource) throws CVSException {
        if (!this.isChildResource(resource)) {
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, NLS.bind((String)CVSMessages.CVSTeamProvider_invalidResource, (Object[])new Object[]{resource.getFullPath().toString(), this.project.getName()}), null));
        }
    }

    private String[] getValidArguments(IResource[] resources, Command.LocalOption[] options) throws CVSException {
        ArrayList<String> arguments = new ArrayList<String>(resources.length);
        int i = 0;
        while (i < resources.length) {
            this.checkIsChild(resources[i]);
            IPath cvsPath = resources[i].getFullPath().removeFirstSegments(1);
            if (cvsPath.segmentCount() == 0) {
                arguments.add(".");
            } else {
                arguments.add(cvsPath.toString());
            }
            ++i;
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private ICVSResource[] getCVSArguments(IResource[] resources) {
        ICVSResource[] cvsResources = new ICVSResource[resources.length];
        int i = 0;
        while (i < cvsResources.length) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor(resources[i]);
            ++i;
        }
        return cvsResources;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRemoteRoot(ICVSRepositoryLocation location, IProgressMonitor monitor) throws TeamException {
        final String root = location.getLocation(false);
        if (root.equals(this.workspaceRoot.getRemoteLocation())) {
            return;
        }
        try {
            this.workspaceRoot.getLocalRoot().run(new ICVSRunnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor progress) throws CVSException {
                    try {
                        progress.beginTask(null, 100);
                        IProgressMonitor monitor = Policy.infiniteSubMonitorFor(progress, 100);
                        monitor.beginTask(null, 256);
                        CVSTeamProvider.this.workspaceRoot.getLocalRoot().accept(new ICVSResourceVisitor(this, monitor, root){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ String val$root;
                            {
                                this.this$1 = var1_1;
                                this.val$monitor = iProgressMonitor;
                                this.val$root = string;
                            }

                            public void visitFile(ICVSFile file) throws CVSException {
                            }

                            public void visitFolder(ICVSFolder folder) throws CVSException {
                                this.val$monitor.worked(1);
                                FolderSyncInfo info = folder.getFolderSyncInfo();
                                if (info != null) {
                                    this.val$monitor.subTask(NLS.bind((String)CVSMessages.CVSTeamProvider_updatingFolder, (Object[])new String[]{info.getRepository()}));
                                    MutableFolderSyncInfo newInfo = info.cloneMutable();
                                    newInfo.setRoot(this.val$root);
                                    folder.setFolderSyncInfo(newInfo);
                                    folder.acceptChildren(this);
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        progress.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    progress.done();
                }
            }, monitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    private boolean isChildResource(IResource resource) {
        return resource.getProject().getName().equals(this.project.getName());
    }

    public void configureProject() throws CoreException {
        this.getProject().setSessionProperty(TEMP_SHARED, null);
        ResourceStateChangeListeners.getListener().projectConfigured(this.getProject());
    }

    public IStatus setKeywordSubstitution(final Map changeSet, final String comment, IProgressMonitor monitor) throws TeamException {
        final IStatus[] result = new IStatus[]{ICommandOutputListener.OK};
        this.workspaceRoot.getLocalRoot().run(new ICVSRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CVSException {
                block21: {
                    block20: {
                        filesToAdmin = new HashMap<Command.KSubstOption, ArrayList<ICVSFile>>();
                        filesToCommitAsText = new HashSet<ICVSFile>();
                        useCRLF = CVSTeamProvider.access$1() != false && CVSProviderPlugin.getPlugin().isUsePlatformLineend() != false;
                        it = changeSet.entrySet().iterator();
                        while (true) {
                            if (!it.hasNext()) break;
                            entry = it.next();
                            file = (IFile)entry.getKey();
                            toKSubst = (Command.KSubstOption)entry.getValue();
                            CVSTeamProvider.access$2(CVSTeamProvider.this, (IResource)file);
                            mFile = CVSWorkspaceRoot.getCVSFileFor(file);
                            if (!mFile.isManaged() || toKSubst.equals(fromKSubst = ResourceSyncInfo.getKeywordMode(syncBytes = mFile.getSyncBytes()))) continue;
                            if (ResourceSyncInfo.isAddition(syncBytes)) {
                                mFile.setSyncBytes(ResourceSyncInfo.setKeywordMode(syncBytes, toKSubst), 0);
                                continue;
                            }
                            if (ResourceSyncInfo.isDeletion(syncBytes)) continue;
                            if (fromKSubst.isBinary() && !toKSubst.isBinary()) {
                                CVSTeamProvider.cleanLineDelimiters(file, useCRLF, (IProgressMonitor)new NullProgressMonitor());
                                filesToCommitAsText.add(mFile);
                            }
                            if ((list = (ArrayList<ICVSFile>)filesToAdmin.get(toKSubst)) == null) {
                                list = new ArrayList<ICVSFile>();
                                filesToAdmin.put(toKSubst, list);
                            }
                            list.add(mFile);
                        }
                        totalWork = filesToCommitAsText.size() + 1;
                        it = filesToAdmin.values().iterator();
                        while (true) {
                            if (!it.hasNext()) {
                                if (totalWork == 0) return;
                                monitor.beginTask(CVSMessages.CVSTeamProvider_settingKSubst, totalWork);
                                ** try [egrp 0[TRYBLOCK] [4 : 364->765)] { 
lbl35:
                                // 1 sources

                                break;
                            }
                            list = (List)it.next();
                            totalWork += list.size();
                            ++totalWork;
                        }
                        {
                            if (filesToCommitAsText.size() != 0) {
                                session = new Session(CVSTeamProvider.access$0(CVSTeamProvider.this).getRemoteLocation(), CVSTeamProvider.access$0(CVSTeamProvider.this).getLocalRoot(), true);
                                session.open(Policy.subMonitorFor(monitor, 1), true);
                                try {
                                    keywordChangeComment = comment;
                                    if (keywordChangeComment == null || keywordChangeComment.length() == 0) {
                                        keywordChangeComment = CVSMessages.CVSTeamProvider_changingKeywordComment;
                                    }
                                    result[0] = Command.COMMIT.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Command.DO_NOT_RECURSE, Commit.FORCE, Command.makeArgumentOption(Command.MESSAGE_OPTION, keywordChangeComment)}, filesToCommitAsText.toArray(new ICVSResource[filesToCommitAsText.size()]), filesToCommitAsText, null, Policy.subMonitorFor(monitor, filesToCommitAsText.size()));
                                }
                                catch (Throwable mFile) {
                                    toKSubst = null;
                                    session.close();
                                    throw mFile;
                                }
                                {
                                    toKSubst = null;
                                    session.close();
                                }
                                if (!result[0].isOK()) {
lbl58:
                                    // 2 sources

                                    while (true) {
                                        var13_16 = null;
                                        break block20;
                                        break;
                                    }
                                }
                            }
                            it = filesToAdmin.entrySet().iterator();
                            while (it.hasNext()) {
                                entry = (Map.Entry)it.next();
                                toKSubst = (Command.KSubstOption)entry.getKey();
                                list = (List)entry.getValue();
                                session = new Session(CVSTeamProvider.access$0(CVSTeamProvider.this).getRemoteLocation(), CVSTeamProvider.access$0(CVSTeamProvider.this).getLocalRoot(), true);
                                session.open(Policy.subMonitorFor(monitor, 1), true);
                                try {
                                    result[0] = Command.ADMIN.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{toKSubst}, list.toArray(new ICVSResource[list.size()]), (ICommandOutputListener)new AdminKSubstListener(toKSubst), Policy.subMonitorFor(monitor, list.size()));
                                }
                                catch (Throwable var12_15) {
                                    var11_13 = null;
                                    session.close();
                                    throw var12_15;
                                }
                                {
                                    var11_13 = null;
                                    session.close();
                                }
                                if (result[0].isOK()) continue;
                                ** continue;
lbl80:
                                // 1 sources

                                ** GOTO lbl58
                            }
                            break block21;
                        }
lbl82:
                        // 1 sources

                        catch (Throwable var14_19) {
                            var13_17 = null;
                            monitor.done();
                            throw var14_19;
                        }
                    }
                    monitor.done();
                    return;
                }
                var13_18 = null;
                monitor.done();
            }
        }, Policy.monitorFor(monitor));
        return result[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanLineDelimiters(IFile file, boolean useCRLF, IProgressMonitor progress) throws CVSException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedInputStream is = new BufferedInputStream(file.getContents());
            try {
                is = new CRLFtoLFInputStream((InputStream)is);
                if (useCRLF) {
                    is = new LFtoCRLFInputStream((InputStream)is);
                }
                while (true) {
                    int b;
                    block8: {
                        if ((b = ((InputStream)is).read()) != -1) break block8;
                        bos.close();
                        break;
                    }
                    bos.write(b);
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                ((InputStream)is).close();
                throw throwable;
            }
            {
                Object var6_11 = null;
            }
            ((InputStream)is).close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            file.setContents((InputStream)bis, false, false, progress);
            return;
        }
        catch (CoreException e) {
            throw CVSException.wrapException((IResource)file, CVSMessages.CVSTeamProvider_cleanLineDelimitersException, e);
        }
        catch (IOException e) {
            throw CVSException.wrapException((IResource)file, CVSMessages.CVSTeamProvider_cleanLineDelimitersException, e);
        }
    }

    public String getID() {
        return CVSProviderPlugin.getTypeId();
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return moveDeleteHook;
    }

    public IFileModificationValidator getFileModificationValidator() {
        return CVSTeamProvider.internalGetFileModificationValidator();
    }

    public void edit(IResource[] resources, boolean recurse, boolean notifyServer, final boolean notifyForWritable, int notification, IProgressMonitor progress) throws CVSException {
        final int notify = notification == 0 ? (CVSProviderPlugin.getPlugin().isWatchOnEdit() ? 7 : 0) : notification;
        this.notifyEditUnedit(resources, recurse, notifyServer, new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (notifyForWritable || file.isReadOnly()) {
                    file.edit(notify, notifyForWritable, Policy.monitorFor(null));
                }
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
            }
        }, null, progress);
    }

    public void unedit(IResource[] resources, boolean recurse, boolean notifyServer, IProgressMonitor progress) throws CVSException {
        this.notifyEditUnedit(resources, recurse, notifyServer, new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (!file.isReadOnly()) {
                    file.unedit(Policy.monitorFor(null));
                }
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
            }
        }, (ISchedulingRule)this.getProject(), progress);
    }

    private void notifyEditUnedit(final IResource[] resources, final boolean recurse, final boolean notifyServer, final ICVSResourceVisitor editUneditVisitor, ISchedulingRule rule, IProgressMonitor monitor) throws CVSException {
        final CVSException[] exception = new CVSException[1];
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSResource[] cvsResources = CVSTeamProvider.this.getCVSArguments(resources);
                try {
                    int i = 0;
                    while (i < cvsResources.length) {
                        cvsResources[i].accept(editUneditVisitor, recurse);
                        ++i;
                    }
                }
                catch (CVSException e) {
                    exception[0] = e;
                    return;
                }
                if (!notifyServer) return;
                monitor.beginTask(null, 100);
                Session session = new Session(CVSTeamProvider.this.workspaceRoot.getRemoteLocation(), CVSTeamProvider.this.workspaceRoot.getLocalRoot(), true);
                try {
                    try {
                        try {
                            session.open(Policy.subMonitorFor(monitor, 10), true);
                        }
                        catch (CVSException cVSException) {
                            Object var5_6 = null;
                            session.close();
                            monitor.done();
                            return;
                        }
                        Command.NOOP.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, cvsResources, null, Policy.subMonitorFor(monitor, 90));
                    }
                    catch (CVSException e) {
                        exception[0] = e;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    session.close();
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    session.close();
                }
                monitor.done();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, rule, 0, Policy.monitorFor(monitor));
        }
        catch (CoreException e) {
            if (exception[0] == null) {
                throw CVSException.wrapException(e);
            }
            CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e)));
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public boolean getFetchAbsentDirectories() throws CVSException {
        try {
            String property = this.getProject().getPersistentProperty(FETCH_ABSENT_DIRECTORIES_PROP_KEY);
            if (property == null) {
                return CVSProviderPlugin.getPlugin().getFetchAbsentDirectories();
            }
            return Boolean.valueOf(property);
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.CVSTeamProvider_errorGettingFetchProperty, (Object[])new String[]{this.project.getName()}), e));
        }
    }

    public void setFetchAbsentDirectories(boolean fetchAbsentDirectories) throws CVSException {
        this.internalSetFetchAbsentDirectories(fetchAbsentDirectories ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public void internalSetFetchAbsentDirectories(String fetchAbsentDirectories) throws CVSException {
        try {
            this.getProject().setPersistentProperty(FETCH_ABSENT_DIRECTORIES_PROP_KEY, fetchAbsentDirectories);
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.CVSTeamProvider_errorSettingFetchProperty, (Object[])new String[]{this.project.getName()}), e));
        }
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public IStatus validateCreateLink(IResource resource, int updateFlags, IPath location) {
        return this.internalValidateCreateLink(resource);
    }

    private IStatus internalValidateCreateLink(IResource resource) {
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource.getParent().getFolder((IPath)new Path(resource.getName())));
        try {
            if (cvsFolder.isCVSFolder()) {
                return new CVSStatus(4, NLS.bind((String)CVSMessages.CVSTeamProvider_overlappingRemoteFolder, (Object[])new String[]{resource.getFullPath().toString()}));
            }
            ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor(resource.getParent().getFile((IPath)new Path(resource.getName())));
            if (cvsFile.isManaged()) {
                return new CVSStatus(4, NLS.bind((String)CVSMessages.CVSTeamProvider_overlappingFileDeletion, (Object[])new String[]{resource.getFullPath().toString()}));
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus validateCreateLink(IResource resource, int updateFlags, URI location) {
        return this.internalValidateCreateLink(resource);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EditorsInfo[] editors(IResource[] resources, IProgressMonitor progress) throws CVSException {
        Command.LocalOption[] commandOptions = new Command.LocalOption[]{};
        progress.worked(10);
        String[] arguments = this.getValidArguments(resources, commandOptions);
        EditorsListener listener = new EditorsListener();
        if (progress.isCanceled()) {
            return new EditorsInfo[0];
        }
        Session session = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot());
        if (progress.isCanceled()) {
            return new EditorsInfo[0];
        }
        progress.beginTask(null, 100);
        try {
            session.open(Policy.subMonitorFor(progress, 20), false);
            if (!progress.isCanceled()) {
                Command.EDITORS.execute(session, Command.NO_GLOBAL_OPTIONS, commandOptions, arguments, (ICommandOutputListener)listener, Policy.subMonitorFor(progress, 80));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            session.close();
            progress.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
            session.close();
        }
        progress.done();
        return listener.getEditorsInfos();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCommitTemplate() throws CVSException {
        String string;
        ICVSFolder localFolder = this.getCVSWorkspaceRoot().getLocalRoot();
        ICVSFile templateFile = CVSWorkspaceRoot.getCVSFileFor(SyncFileWriter.getTemplateFile((IContainer)localFolder.getIResource()));
        if (!templateFile.exists()) {
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(templateFile.getContents());
        try {
            try {
                int b;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                do {
                    if ((b = ((InputStream)in).read()) == -1) continue;
                    out.write((byte)b);
                } while (b != -1);
                out.close();
                string = new String(out.toString());
                Object var6_8 = null;
            }
            catch (IOException e) {
                throw CVSException.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e2) {
                CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e2)));
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e2)));
            return string;
        }
        ((InputStream)in).close();
        return string;
    }

    public boolean isWatchEditEnabled() throws CVSException {
        IProject project = this.getProject();
        try {
            String property = (String)project.getSessionProperty(WATCH_EDIT_PROP_KEY);
            if (property == null) {
                property = project.getPersistentProperty(WATCH_EDIT_PROP_KEY);
                if (property == null) {
                    return CVSProviderPlugin.getPlugin().isWatchEditEnabled();
                }
                project.setSessionProperty(WATCH_EDIT_PROP_KEY, (Object)property);
            }
            return Boolean.valueOf(property);
        }
        catch (CoreException e) {
            if (project.isAccessible()) {
                throw new CVSException((IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.CVSTeamProvider_errorGettingWatchEdit, (Object[])new String[]{project.getName()}), e));
            }
            return false;
        }
    }

    public void setWatchEditEnabled(boolean enabled) throws CVSException {
        this.internalSetWatchEditEnabled(enabled ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    private void internalSetWatchEditEnabled(String enabled) throws CVSException {
        try {
            IProject project = this.getProject();
            project.setPersistentProperty(WATCH_EDIT_PROP_KEY, enabled);
            project.setSessionProperty(WATCH_EDIT_PROP_KEY, (Object)enabled);
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.CVSTeamProvider_errorSettingWatchEdit, (Object[])new String[]{this.project.getName()}), e));
        }
    }

    public IResourceRuleFactory getRuleFactory() {
        return RESOURCE_RULE_FACTORY;
    }

    public IFileHistoryProvider getFileHistoryProvider() {
        if (fileHistoryProvider == null) {
            fileHistoryProvider = new CVSFileHistoryProvider();
        }
        return fileHistoryProvider;
    }

    static /* synthetic */ boolean access$1() {
        return IS_CRLF_PLATFORM;
    }

    static /* synthetic */ void access$2(CVSTeamProvider cVSTeamProvider, IResource iResource) throws CVSException {
        cVSTeamProvider.checkIsChild(iResource);
    }
}

