/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.appserver;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.appserver.AppserverPlugin;
import org.eclipse.help.internal.appserver.AppserverResources;
import org.eclipse.help.internal.appserver.IWebappServer;
import org.eclipse.help.internal.appserver.PluginClassLoaderWrapper;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class WebappManager {
    private static boolean applicationsStarted = false;

    private WebappManager() {
    }

    public static void start(String webappName, String pluginId, IPath path) throws CoreException {
        IPath webappPath = WebappManager.getWebappPath(pluginId, path);
        IWebappServer server = AppserverPlugin.getDefault().getAppServer();
        applicationsStarted = true;
        server.start(webappName, webappPath, new PluginClassLoaderWrapper(pluginId));
    }

    public static void stop(String webappName) throws CoreException {
        if (!applicationsStarted) {
            return;
        }
        AppserverPlugin.getDefault().getAppServer().stop(webappName);
    }

    public static int getPort() {
        try {
            return AppserverPlugin.getDefault().getAppServer().getPort();
        }
        catch (CoreException coreException) {
            return 0;
        }
    }

    public static String getHost() {
        try {
            return AppserverPlugin.getDefault().getAppServer().getHost();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static IPath getWebappPath(String pluginId, IPath path) throws CoreException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.help.appserver", 0, NLS.bind((String)AppserverResources.Appserver_cannotFindPlugin, (Object)pluginId), null));
        }
        URL webappURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (webappURL == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.help.appserver", 0, NLS.bind((String)AppserverResources.Appserver_cannotFindPath, (Object)pluginId, (Object)path.toOSString()), null));
        }
        try {
            String webappLocation = FileLocator.toFileURL((URL)FileLocator.resolve((URL)webappURL)).getFile();
            return new Path(webappLocation);
        }
        catch (IOException ioe) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.help.appserver", 0, NLS.bind((String)AppserverResources.Appserver_cannotResolvePath, (Object)pluginId, (Object)path.toOSString()), (Throwable)ioe));
        }
    }
}

