/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.jdbc.EmbeddedXADataSource;

class XADatabase
extends Database {
    private EmbeddedXADataSource xaDataSource;
    private XAResource xaResource;
    private XAConnection xaConnection;

    protected XADatabase(String string) {
        super(string);
        this.forXA = true;
    }

    protected synchronized Connection makeConnection(Properties properties) throws SQLException {
        Connection connection;
        if (this.xaDataSource == null) {
            this.xaDataSource = new EmbeddedXADataSource();
        }
        this.xaDataSource.setDatabaseName(this.shortDbName);
        this.appendAttrString(properties);
        if (this.attrString != null) {
            this.xaDataSource.setConnectionAttributes(this.attrString);
        }
        if ((connection = this.getConnection()) == null) {
            this.xaConnection = this.xaDataSource.getXAConnection(this.userId, this.password);
            this.xaResource = this.xaConnection.getXAResource();
        } else {
            connection.close();
        }
        connection = this.xaConnection.getConnection();
        this.setConnection(connection);
        return connection;
    }

    protected void setXAResource(XAResource xAResource) {
        this.xaResource = xAResource;
    }

    protected void setDrdaID(String string) {
        if (this.getConnection() != null) {
            ((BrokeredConnection)this.getConnection()).setDrdaID(string);
        }
    }

    protected void setPrepareIsolation(int n) throws SQLException {
        ((BrokeredConnection)this.getConnection()).setPrepareIsolation(n);
    }

    protected int getPrepareIsolation() throws SQLException {
        return ((BrokeredConnection)this.getConnection()).getPrepareIsolation();
    }

    protected XAResource getXAResource() {
        return this.xaResource;
    }
}

