/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DataAccessObjectApacheDerby;
import netjfwatcher.database.access.control.DataAccessObjectAxion;
import netjfwatcher.database.access.control.DataAccessObjectHSQLDB;
import netjfwatcher.database.access.control.DataAccessObjectMySQL;
import netjfwatcher.database.access.control.DataAccessObjectOracle;
import netjfwatcher.database.access.control.DataAccessObjectPostgreSQL;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DatabaseTestInfo;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;

public class DatabaseTest {
    public static final String DATABASE_TEST_TABLE = "database_test";
    public static final String TEST_ID = "id";
    public static final String TEST_CHAR = "test_char";
    public static final String TEST_DATE = "test_date";
    private static final int PHASE0_NO = 0;
    private static final int PHASE1_NO = 1;
    private static final int PHASE2_NO = 2;
    private static final int PHASE3_NO = 3;
    private static final int PHASE4_NO = 4;
    private static final int PHASE_COUNT = 5;
    private static Logger logger = null;
    private static final String PHASE1_OK_DESCRIPTION = "Phase 1 OK";
    private static final String PHASE2_OK_DESCRIPTION = "Phase 2 OK";
    private static final String PHASE3_OK_DESCRIPTION = "Phase 3 OK";
    private static final String PHASE4_OK_DESCRIPTION = "Phase 4 OK";
    private final String databaseName;
    private String[] checkResult = new String[5];
    private AbstractDataAccessObject dataaccessobject;
    private String testURL;

    public DatabaseTest(String paraDatabaseName) {
        logger = Logger.getLogger(this.getClass().getName());
        this.databaseName = paraDatabaseName;
    }

    public String[] checkDatabase(String jdbcdriver, String url, String username, String password) {
        logger.info("Database Test start : " + this.databaseName);
        logger.info("jdbcdriver : " + jdbcdriver);
        logger.info("url : " + url);
        logger.info("username : " + username);
        logger.info("password : " + password);
        this.checkResult[0] = "";
        this.checkResult[1] = "";
        this.checkResult[2] = "";
        this.checkResult[3] = "";
        this.checkResult[4] = "";
        this.testURL = "";
        this.dataaccessobject = null;
        this.checkResult = this.checkPhase1(jdbcdriver);
        if (!this.checkResult[1].equals(PHASE1_OK_DESCRIPTION)) {
            return this.checkResult;
        }
        this.checkResult = this.checkPhase2(url, username, password);
        if (!this.checkResult[2].equals(PHASE2_OK_DESCRIPTION)) {
            return this.checkResult;
        }
        this.checkResult = this.checkPhase3(username, password);
        if (!this.checkResult[3].equals(PHASE3_OK_DESCRIPTION)) {
            return this.checkResult;
        }
        this.checkResult = this.checkPhase4(username, password);
        if (!this.checkResult[4].equals(PHASE4_OK_DESCRIPTION)) {
            return this.checkResult;
        }
        return this.checkResult;
    }

    private String[] checkPhase1(String jdbcdriver) {
        try {
            if (this.databaseName.equals("Embedded Derby")) {
                ApacheDerbyEmbeddedDerby.getInstance().setEmbeddedDerby(false);
            }
            Class.forName(jdbcdriver).newInstance();
            if (this.databaseName.equals("Embedded Derby")) {
                ApacheDerbyEmbeddedDerby.getInstance().setEmbeddedDerby(true);
            }
            this.checkResult[1] = PHASE1_OK_DESCRIPTION;
            logger.info(this.checkResult[1]);
        }
        catch (ExceptionInInitializerError e) {
            this.checkResult[1] = "ExceptionInInitializerError: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            e.printStackTrace();
            return this.checkResult;
        }
        catch (InstantiationException e) {
            this.checkResult[1] = "InstantiationException: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            e.printStackTrace();
            return this.checkResult;
        }
        catch (IllegalAccessException e) {
            this.checkResult[1] = "IllegalAccessException: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            e.printStackTrace();
            return this.checkResult;
        }
        catch (ClassNotFoundException e) {
            this.checkResult[1] = "ClassNotFoundException: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            e.printStackTrace();
            return this.checkResult;
        }
        catch (NoClassDefFoundError e) {
            this.checkResult[1] = "NoClassDefFoundError: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            e.printStackTrace();
            return this.checkResult;
        }
        return this.checkResult;
    }

    private String[] checkPhase2(String url, String username, String password) {
        Connection con = null;
        Statement stmt = null;
        String sql = "";
        String nowData = DatabaseAccessControlKind.getInstance().getDatabaseName();
        try {
            try {
                if (!this.databaseName.equals("Embedded Derby")) {
                    this.testURL = this.databaseName.equals("Apache Derby") ? String.valueOf(url) + "nodewatch" + ";" + "create=true;" : (this.databaseName.equals("MySQL") ? String.valueOf(url) + "nodewatch" : String.valueOf(url) + "nodewatch/");
                    con = DriverManager.getConnection(this.testURL, username, password);
                } else {
                    this.testURL = "jdbc:derby:nodewatch;create=true;";
                    con = DriverManager.getConnection(this.testURL);
                }
                stmt = con.createStatement();
                if (this.databaseName.equals("MySQL") && !nowData.equals("MySQL")) {
                    sql = "DROP DATABASE IF EXISTS nodewatch";
                    stmt.executeUpdate(sql);
                    sql = "CREATE DATABASE nodewatch";
                    stmt.executeUpdate(sql);
                } else if (this.databaseName.equals("Postgresql") && !nowData.equals("Postgresql")) {
                    try {
                        sql = "DROP DATABASE nodewatch";
                        stmt.executeUpdate(sql);
                    }
                    catch (SQLException e) {
                        logger.info(String.valueOf(this.databaseName) + " SQL=" + sql + " : " + e.getMessage());
                    }
                    sql = "CREATE DATABASE nodewatch";
                    stmt.executeUpdate(sql);
                }
                this.checkResult[2] = PHASE2_OK_DESCRIPTION;
                logger.info(this.checkResult[2]);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                this.checkResult[2] = e1.getNextException() != null ? "SQLException: " + e1.getMessage() + " Next exception: " + e1.getNextException() : "SQLException: " + e1.getMessage();
                logger.warning("SQLException URL = " + this.testURL + " : User = " + username + " : Password = " + password);
                logger.warning(this.checkResult[2]);
                logger.warning("SQLException SQL=" + sql);
                String[] stringArray = this.checkResult;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    stmt = null;
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                }
                return stringArray;
            }
            catch (NoClassDefFoundError e1) {
                String[] stringArray;
                block36: {
                    this.checkResult[2] = "NoClassDefFoundError: " + e1.getMessage();
                    logger.warning("NoClassDefFoundError URL = " + this.testURL + " : User = " + username + " : Password = " + password);
                    logger.warning(this.checkResult[2]);
                    logger.warning("NoClassDefFoundError SQL=" + sql);
                    stringArray = this.checkResult;
                    if (stmt == null) break block36;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    stmt = null;
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                }
                return stringArray;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return this.checkResult;
    }

    private String[] checkPhase3(String username, String password) {
        Connection con = null;
        Statement stmt = null;
        if (this.databaseName.equals("HSQLDB")) {
            this.dataaccessobject = new DataAccessObjectHSQLDB();
        } else if (this.databaseName.equals("Apache Derby") || this.databaseName.equals("Embedded Derby")) {
            this.dataaccessobject = new DataAccessObjectApacheDerby();
        } else if (this.databaseName.equals("MySQL")) {
            this.dataaccessobject = new DataAccessObjectMySQL();
        } else if (this.databaseName.equals("Postgresql")) {
            this.dataaccessobject = new DataAccessObjectPostgreSQL();
        } else if (this.databaseName.equals("Oracle")) {
            this.dataaccessobject = new DataAccessObjectOracle();
        } else if (this.databaseName.equals("Axion")) {
            this.dataaccessobject = new DataAccessObjectAxion();
        } else {
            logger.warning("Database Nosuport : " + this.databaseName);
            this.checkResult[3] = "Database Nosuport : " + this.databaseName;
            return this.checkResult;
        }
        logger.info("Database Kind : " + this.databaseName);
        try {
            try {
                con = !this.databaseName.equals("Embedded Derby") ? DriverManager.getConnection(this.testURL, username, password) : DriverManager.getConnection(this.testURL);
                stmt = con.createStatement();
                stmt.executeUpdate(this.dataaccessobject.getCreateDatabaseTestTableSQL());
                this.checkResult[3] = PHASE3_OK_DESCRIPTION;
                logger.info(this.checkResult[3]);
            }
            catch (SQLException e2) {
                this.checkResult[3] = "SQLException: " + e2.getMessage();
                logger.warning("SQL : " + this.dataaccessobject.getCreateDatabaseTestTableSQL());
                logger.warning(this.checkResult[3]);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return this.checkResult;
    }

    private String[] checkPhase4(String username, String password) {
        Connection con = null;
        Statement stmt = null;
        try {
            try {
                con = DriverManager.getConnection(this.testURL, username, password);
                stmt = con.createStatement();
                if (this.databaseName.equals("Postgresql")) {
                    stmt.executeUpdate(this.dataaccessobject.getDropDatabaseTestSequenceSQL());
                }
                stmt.executeUpdate(this.dataaccessobject.getDropDatabaseTestTableSQL());
                this.checkResult[4] = PHASE4_OK_DESCRIPTION;
                logger.info(this.checkResult[4]);
            }
            catch (SQLException e3) {
                this.checkResult[4] = "SQLException: " + e3.getMessage();
                String[] stringArray = this.checkResult;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    stmt = null;
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                }
                return stringArray;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return this.checkResult;
    }

    public void putDatabaseTest(int count) throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            databaseAccess.executeUpdate("insert into database_test ( test_char, test_date ) VALUES( 'Test" + Integer.toString(count) + "', '" + dateformat.format(date) + "'" + ");");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public ArrayList findAll() throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<DatabaseTestInfo> databaseTestResultList = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sql = "SELECT * from database_test order by id";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            databaseTestResultList = new ArrayList<DatabaseTestInfo>();
            while (rs.next()) {
                DatabaseTestInfo testInfo = new DatabaseTestInfo();
                testInfo.setTestStringData(rs.getObject(TEST_CHAR).toString());
                testInfo.setTestDate(rs.getObject(TEST_DATE).toString());
                testInfo.setTestID(rs.getObject(TEST_ID).toString());
                databaseTestResultList.add(testInfo);
            }
            ArrayList<DatabaseTestInfo> arrayList = databaseTestResultList;
            return arrayList;
        }
        catch (DatabaseConnectionException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
    }
}

