/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeChart;
import netjfwatcher.engine.view.editorpart.jvm.EditorGarbageCollectionChart;
import netjfwatcher.engine.view.editorpart.ping.EditorNodePingChart;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisticsChart;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderChart {
    private static Logger logger;
    private IAction nodePingChartAction = new ActionNodePingChartView();
    private IAction nodePingChartActionSocket = new ActionNodePingChartViewSocket();
    private IAction nodeSnmpStatisticsChartAction = new ActionNodeSnmpStatisticsChartView();
    private IAction nodeSnmpStatisticsChartActionSocket = new ActionNodeSnmpStatisticsChartViewSocket();
    private IAction garbageCollectionAction = new ActionGarbageCollectionView();
    private IAction garbageCollectionActionSocket = new ActionGarbageCollectionViewSocket();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderChart() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionNodePingChartView() {
        return this.nodePingChartAction;
    }

    public IAction getActionNodePingChartViewSocket() {
        return this.nodePingChartActionSocket;
    }

    public IAction getActionNodeSnmpStatisticsChartView() {
        return this.nodeSnmpStatisticsChartAction;
    }

    public IAction getActionNodeSnmpStatisticsChartViewSocket() {
        return this.nodeSnmpStatisticsChartActionSocket;
    }

    public IAction getNewActionNodeSnmpStatisticsChartView() {
        return new ActionNodeSnmpStatisticsChartView();
    }

    public IAction getNewActionNodeSnmpStatisticsChartViewSocket() {
        return new ActionNodeSnmpStatisticsChartViewSocket();
    }

    public IAction getActionGarbageCollectionView() {
        return this.garbageCollectionAction;
    }

    public IAction getActionGarbageCollectionViewSocket() {
        return this.garbageCollectionActionSocket;
    }

    private abstract class AbstractNodeChartAction
    extends Action {
        protected String title;
        protected NodeInformation nodeInfo;
        protected String oid;
        protected ArrayList nameList;
        protected String[] maxData;
        protected String[] minData;
        protected ArrayList dataList;
        protected ArrayList dateList;

        private AbstractNodeChartAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();

        public void setDataList(ArrayList dataList) {
            this.dataList = dataList;
        }

        public void setDateList(ArrayList dateList) {
            this.dateList = dateList;
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }

        public void setMaxData(String[] maxData) {
            this.maxData = maxData;
        }

        public void setMinData(String[] minData) {
            this.minData = minData;
        }

        public void setNameList(ArrayList nameList) {
            this.nameList = nameList;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }
    }

    public class ActionNodePingChartView
    extends AbstractNodeChartAction {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderChart.this.bundle.getEntry("icons/chart.gif"));
        }

        public String getText() {
            return "Ping Chart";
        }

        public String getToolTipText() {
            return "Ping Chart";
        }

        protected void doTask() {
            IEditorPart editorNodeConfigView = null;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeChart(this.title, this.nodeInfo, false, this.dataList, this.dateList, this.nameList, this.maxData, this.minData, this.oid), EditorNodePingChart.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionNodePingChartViewSocket
    extends AbstractNodeChartAction {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderChart.this.bundle.getEntry("icons/chart.gif"));
        }

        public String getText() {
            return "Ping Chart";
        }

        public String getToolTipText() {
            return "Ping Chart";
        }

        protected void doTask() {
            IEditorPart editorNodeConfigView = null;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeChart(String.valueOf(this.title) + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true, this.dataList, this.dateList, this.nameList, this.maxData, this.minData, this.oid), EditorNodePingChart.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionNodeSnmpStatisticsChartView
    extends AbstractNodeChartAction {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderChart.this.bundle.getEntry("icons/chart.gif"));
        }

        protected void doTask() {
            IEditorPart editorNodeConfigView = null;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeChart(this.title, this.nodeInfo, false, this.dataList, this.dateList, this.nameList, this.maxData, this.minData, this.oid), EditorNodeSnmpStatisticsChart.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionNodeSnmpStatisticsChartViewSocket
    extends ActionNodeSnmpStatisticsChartView {
        protected void doTask() {
            IEditorPart editorNodeConfigView = null;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeChart(String.valueOf(this.title) + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true, this.dataList, this.dateList, this.nameList, this.maxData, this.minData, this.oid), EditorNodeSnmpStatisticsChart.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionGarbageCollectionView
    extends AbstractNodeChartAction {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderChart.this.bundle.getEntry("icons/chart.gif"));
        }

        public String getText() {
            return "GarbageCollection Chart";
        }

        public String getToolTipText() {
            return "GarbageCollection Chart";
        }

        protected void doTask() {
            IEditorPart editorNodeConfigView = null;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeChart(this.title, this.nodeInfo, false, this.dataList, this.dateList, this.nameList, this.maxData, this.minData), EditorGarbageCollectionChart.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionGarbageCollectionViewSocket
    extends ActionGarbageCollectionView {
        protected void doTask() {
            IEditorPart editorNodeConfigView = null;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeChart(String.valueOf(this.title) + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true, this.dataList, this.dateList, this.nameList, this.maxData, this.minData), EditorGarbageCollectionChart.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

