/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.webbrowser.model.DocumentParseErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeUploadFile {
    public static final int NODENAME_NUMBER = 0;
    public static final int IPADDRESS_NUMBER = 1;
    public static final int GROUP_NUMBER = 2;
    public static final int ENGINE_ADDRESS_NUMBER = 3;
    public static final int NODE_X_NUMBER = 4;
    public static final int NODE_Y_NUMBER = 5;
    public static final int NODEKIND_NUMBER = 6;
    public static final int PING_PERIOD_NUMBER = 7;
    public static final int PING_THRESHHOLD_NUMBER = 8;
    public static final int SNMP_VERSION_NUMBER = 9;
    public static final int SNMP_LEVEL_NUMBER = 10;
    public static final int SNMP_PERIOD_NUMBER = 11;
    public static final int SNMP_ROCOMMUNITY_NUMBER = 12;
    public static final int SNMP_RWCOMMUNITY_NUMBER = 13;
    public static final int SNMP_TIMEOUT_NUMBER = 14;
    public static final int HTTP_PERIOD_NUMBER = 15;
    public static final int HTTP_PORT_NUMBER = 16;
    public static final int HTTP_TIMEOUT_NUMBER = 17;
    public static final int HTTP_URL_NUMBER = 18;
    public static final int POP3_PERIOD_NUMBER = 19;
    public static final int POP3_PORT_NUMBER = 20;
    public static final int POP3_TIMEOUT_NUMBER = 21;
    public static final int POP3_USER_NUMBER = 22;
    public static final int POP3_PASSWORD_NUMBER = 23;
    public static final int SMTP_PERIOD_NUMBER = 24;
    public static final int SMTP_PORT_NUMBER = 25;
    public static final int SMTP_TIMEOUT_NUMBER = 26;
    public static final int SMTP_SEND_ADDRESS_NUMBER = 27;
    public static final int SMTP_CHECK_POP_HOST_NUMBER = 28;
    public static final int SMTP_CHECK_POP_PORT_NUMBER = 29;
    public static final int SMTP_CHECK_POP_TIMEOUT_NUMBER = 30;
    public static final int SMTP_CHECK_POP_USER_NUMBER = 31;
    public static final int SMTP_CHECK_POP_PASSWORD_NUMBER = 32;
    public static final String[] NODE_INFO_DESCRIBE_ARRAY = new String[]{"NodeName", "IPAddress", "Group", "EngineAddress", "Node_X", "Node_Y", "NodeKind", "Ping_Period", "PingThreshHold", "SNMPVersion", "SNMPLevel", "SNMPPeriod", "SNMPROCommunity", "SNMPRWOCommunity", "SNMPTimeout", "HTTPPeriod", "HTTPPort", "HTTPTimeout", "HTTPURL", "Pop3_Period", "Pop3_Port", "Pop3_Timeout", "Pop3_User", "Pop3_Password", "Smtp_Period", "Smtp_Port", "Smtp_Timeout", "Smtp_Send_Address", "Smtp_Check_Pop3_Host", "Smtp_Check_Pop3_Port", "Smtp_Check_Pop3_Timeout", "Smtp_Check_Pop3_User", "Smtp_Check_Pop3_Password"};
    public static final int BUFF_SIZE = 512000;
    public static final int NODE_MAX = 500;
    public static final int NODE_LINK_MAX = 500;
    private static Logger logger = null;
    private ArrayList nodeInfoList = null;
    private ArrayList linkList = null;

    public void upload(String file) throws FileNotFoundException, Exception {
        logger = Logger.getLogger(this.getClass().getName());
        File f = new File(file);
        FileInputStream stream = null;
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;
        try {
            try {
                stream = new FileInputStream(f);
                dbfactory = DocumentBuilderFactory.newInstance();
                dbfactory.setValidating(true);
                builder = dbfactory.newDocumentBuilder();
                builder.setErrorHandler(new DocumentParseErrorHandler());
                dom = builder.parse(stream);
                if (dom != null) {
                    Element root = dom.getDocumentElement();
                    Node firstChildNode = root.getFirstChild();
                    this.nodeInfoList = this.parseNode(firstChildNode);
                    this.linkList = this.parseLink(firstChildNode);
                }
            }
            catch (FileNotFoundException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                throw e;
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    private ArrayList parseNode(Node firstChildNode) {
        Node childNode = firstChildNode;
        while (childNode != null) {
            try {
                if (childNode != null && childNode.getNodeType() == 1 && childNode.getNodeName().equals("Node")) {
                    childNode = childNode.getFirstChild();
                    break;
                }
                childNode = childNode.getNextSibling();
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        ArrayList<String[]> nodeList = new ArrayList<String[]>();
        while (childNode != null) {
            try {
                System.out.println("getNodeName0 : " + childNode.getNodeName());
                System.out.println("getNodeType0 : " + childNode.getNodeType());
                System.out.println("getNodeValue0 : " + childNode.getNodeValue());
                if (childNode != null && childNode.getNodeType() == 1) {
                    if (childNode.getNodeName().equals("Node_Property")) {
                        Node nodeInfoChildNodeLeaf = childNode.getFirstChild();
                        boolean hit = false;
                        String[] nodeInfo = new String[NODE_INFO_DESCRIBE_ARRAY.length];
                        while (nodeInfoChildNodeLeaf != null) {
                            if (nodeInfoChildNodeLeaf.getNodeType() == 1) {
                                int i = 0;
                                while (i < NODE_INFO_DESCRIBE_ARRAY.length) {
                                    if (nodeInfoChildNodeLeaf.getNodeName().equals(NODE_INFO_DESCRIBE_ARRAY[i])) {
                                        Node firstNodeText = null;
                                        String leafItemValue = null;
                                        if (nodeInfoChildNodeLeaf != null && (firstNodeText = nodeInfoChildNodeLeaf.getFirstChild()) != null) {
                                            leafItemValue = firstNodeText.getNodeValue();
                                        }
                                        nodeInfo[i] = leafItemValue;
                                        hit = true;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            nodeInfoChildNodeLeaf = nodeInfoChildNodeLeaf.getNextSibling();
                        }
                        if (hit) {
                            nodeList.add(nodeInfo);
                        }
                    }
                    childNode = childNode.getNextSibling();
                }
                childNode = childNode.getNextSibling();
            }
            catch (DOMException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        int j = 0;
        while (j < nodeList.size()) {
            int l = 0;
            while (l < NODE_INFO_DESCRIBE_ARRAY.length) {
                System.out.println(String.valueOf(j) + " : " + NODE_INFO_DESCRIBE_ARRAY[l] + " : " + ((String[])nodeList.get(j))[l]);
                ++l;
            }
            ++j;
        }
        return nodeList;
    }

    private ArrayList parseLink(Node firstChildNode) {
        ArrayList<String[]> linkList = new ArrayList<String[]>();
        String[] nodeLinkInfo = null;
        Node childNode = firstChildNode;
        while (childNode != null) {
            if (childNode != null && childNode.getNodeType() == 1 && childNode.getNodeName().equals("Link")) {
                childNode = childNode.getFirstChild();
                break;
            }
            childNode = childNode.getNextSibling();
        }
        while (childNode != null) {
            if (childNode != null && childNode.getNodeType() == 1) {
                if (childNode.getNodeName().equals("Link_Property")) {
                    Node nodeInfoChildNodeLeaf = childNode.getFirstChild();
                    boolean hit = false;
                    nodeLinkInfo = new String[2];
                    while (nodeInfoChildNodeLeaf != null) {
                        if (nodeInfoChildNodeLeaf.getNodeType() == 1) {
                            String leafItemValue;
                            Node firstNodeText;
                            if (nodeInfoChildNodeLeaf.getNodeName().equals("NodeX")) {
                                firstNodeText = nodeInfoChildNodeLeaf.getFirstChild();
                                nodeLinkInfo[0] = leafItemValue = firstNodeText.getNodeValue();
                                hit = true;
                                System.out.println("Link Node X : " + leafItemValue);
                            }
                            if (nodeInfoChildNodeLeaf.getNodeName().equals("NodeY")) {
                                firstNodeText = nodeInfoChildNodeLeaf.getFirstChild();
                                nodeLinkInfo[1] = leafItemValue = firstNodeText.getNodeValue();
                                hit = true;
                                System.out.println("Link Node Y : " + leafItemValue);
                            }
                        }
                        nodeInfoChildNodeLeaf = nodeInfoChildNodeLeaf.getNextSibling();
                    }
                    if (hit) {
                        linkList.add(nodeLinkInfo);
                    }
                }
                childNode = childNode.getNextSibling();
            }
            childNode = childNode.getNextSibling();
        }
        int j = 0;
        while (j < linkList.size()) {
            int l = 0;
            while (l < 2) {
                System.out.println(String.valueOf(j) + " : Link " + " : " + ((String[])linkList.get(j))[l]);
                ++l;
            }
            ++j;
        }
        return linkList;
    }

    public NodeInformation createNodeInfo(String[] nodeInfoArray, boolean isLocalHostAddoress) {
        String nodename = "";
        String ipaddress = "";
        String engineAddress = "localhost";
        try {
            engineAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
        }
        String group = "Default Group";
        String nodeX = "";
        String nodeY = "";
        String nodeKind = "";
        String pingPeriod = "0";
        String pingThreshhold = "20";
        String snmpVersion = "SNMPV1";
        String snmpPeriod = "300";
        String snmpLevel = "0";
        String roCommunity = "public";
        String rwCommunity = "private";
        String httpUrl = "";
        String httpPeriod = "";
        String httpPort = "";
        String httpTimeout = "";
        String popPeriod = "";
        String popPort = "";
        String popTimeout = "";
        String popUser = "";
        String popPassword = "";
        String smtpPeriod = "";
        String smtpPort = "";
        String smtpTimeout = "";
        String smtpSendAddress = "";
        String smtpCheckPop3Host = "";
        String smtpCheckPop3Port = "";
        String smtpCheckPop3Timeout = "";
        String smtpCheckPop3User = "";
        String smtpCheckPop3Password = "";
        nodename = nodeInfoArray[0];
        ipaddress = nodeInfoArray[1];
        if (nodeInfoArray[3] != null && !nodeInfoArray[3].equals("") && !isLocalHostAddoress) {
            engineAddress = nodeInfoArray[3];
        }
        if (nodeInfoArray[2] != null && !nodeInfoArray[2].equals("")) {
            group = nodeInfoArray[2];
        }
        if (nodeInfoArray[4] != null && !nodeInfoArray[4].equals("")) {
            nodeX = nodeInfoArray[4];
        }
        if (nodeInfoArray[5] != null && !nodeInfoArray[5].equals("")) {
            nodeY = nodeInfoArray[5];
        }
        if (nodeInfoArray[6] != null && !nodeInfoArray[6].equals("")) {
            nodeKind = nodeInfoArray[6];
        }
        if (nodeInfoArray[7] != null && !nodeInfoArray[7].equals("")) {
            pingPeriod = nodeInfoArray[7];
        }
        if (nodeInfoArray[8] != null && !nodeInfoArray[8].equals("")) {
            pingThreshhold = nodeInfoArray[8];
        }
        if (nodeInfoArray[9] != null && !nodeInfoArray[9].equals("")) {
            snmpVersion = nodeInfoArray[9];
        }
        if (nodeInfoArray[11] != null && !nodeInfoArray[11].equals("")) {
            snmpPeriod = nodeInfoArray[11];
        }
        if (nodeInfoArray[10] != null && !nodeInfoArray[10].equals("")) {
            snmpLevel = nodeInfoArray[10];
        }
        if (nodeInfoArray[12] != null && !nodeInfoArray[12].equals("")) {
            roCommunity = nodeInfoArray[12];
        }
        if (nodeInfoArray[13] != null && !nodeInfoArray[13].equals("")) {
            rwCommunity = nodeInfoArray[13];
        }
        if (nodeInfoArray[15] != null && !nodeInfoArray[15].equals("")) {
            httpPeriod = nodeInfoArray[15];
        }
        if (nodeInfoArray[18] != null && !nodeInfoArray[18].equals("")) {
            httpUrl = nodeInfoArray[18];
        }
        if (nodeInfoArray[16] != null && !nodeInfoArray[16].equals("")) {
            httpPort = nodeInfoArray[16];
        }
        if (nodeInfoArray[17] != null && !nodeInfoArray[17].equals("")) {
            httpTimeout = nodeInfoArray[17];
        }
        if (nodeInfoArray[19] != null && !nodeInfoArray[19].equals("")) {
            popPeriod = nodeInfoArray[19];
        }
        if (nodeInfoArray[20] != null && !nodeInfoArray[20].equals("")) {
            popPort = nodeInfoArray[20];
        }
        if (nodeInfoArray[21] != null && !nodeInfoArray[21].equals("")) {
            popTimeout = nodeInfoArray[21];
        }
        if (nodeInfoArray[22] != null && !nodeInfoArray[22].equals("")) {
            popUser = nodeInfoArray[22];
        }
        if (nodeInfoArray[23] != null && !nodeInfoArray[23].equals("")) {
            popPassword = nodeInfoArray[23];
        }
        if (nodeInfoArray[24] != null && !nodeInfoArray[24].equals("")) {
            smtpPeriod = nodeInfoArray[24];
        }
        if (nodeInfoArray[25] != null && !nodeInfoArray[25].equals("")) {
            smtpPort = nodeInfoArray[25];
        }
        if (nodeInfoArray[26] != null && !nodeInfoArray[26].equals("")) {
            smtpTimeout = nodeInfoArray[26];
        }
        if (nodeInfoArray[27] != null && !nodeInfoArray[27].equals("")) {
            smtpSendAddress = nodeInfoArray[27];
        }
        if (nodeInfoArray[28] != null && !nodeInfoArray[28].equals("")) {
            smtpCheckPop3Host = nodeInfoArray[28];
        }
        if (nodeInfoArray[29] != null && !nodeInfoArray[29].equals("")) {
            smtpCheckPop3Port = nodeInfoArray[29];
        }
        if (nodeInfoArray[30] != null && !nodeInfoArray[30].equals("")) {
            smtpCheckPop3Timeout = nodeInfoArray[30];
        }
        if (nodeInfoArray[31] != null && !nodeInfoArray[31].equals("")) {
            smtpCheckPop3User = nodeInfoArray[31];
        }
        if (nodeInfoArray[32] != null && !nodeInfoArray[32].equals("")) {
            smtpCheckPop3Password = nodeInfoArray[32];
        }
        NodeInformation nodeInformation = new NodeInformation();
        nodeInformation.setNodename(nodename);
        nodeInformation.setIpaddress(ipaddress);
        nodeInformation.setEngineAddress(engineAddress);
        nodeInformation.setGroup(group);
        nodeInformation.setNodeKind(nodeKind);
        nodeInformation.setPingPeriod(pingPeriod);
        nodeInformation.setPingThreshold(pingThreshhold);
        nodeInformation.setSnmpVersion(snmpVersion);
        nodeInformation.setSnmpPeriod(snmpPeriod);
        nodeInformation.setSnmpLevel(snmpLevel);
        nodeInformation.setRoCommunity(roCommunity);
        nodeInformation.setRwCommunity(rwCommunity);
        nodeInformation.setNodeX(nodeX);
        nodeInformation.setNodeY(nodeY);
        nodeInformation.setNodeKind(nodeKind);
        nodeInformation.setHttpPeriod(httpPeriod);
        nodeInformation.setHttpUrl(httpUrl);
        nodeInformation.setHttpPort(httpPort);
        nodeInformation.setHttpTimeout(httpTimeout);
        nodeInformation.setPopPeriod(popPeriod);
        nodeInformation.setPopPort(popPort);
        nodeInformation.setPopTimeout(popTimeout);
        nodeInformation.setPopUser(popUser);
        nodeInformation.setPopPassword(popPassword);
        nodeInformation.setSmtpPeriod(smtpPeriod);
        nodeInformation.setSmtpPort(smtpPort);
        nodeInformation.setSmtpTimeout(smtpTimeout);
        nodeInformation.setSmtpSendAddress(smtpSendAddress);
        nodeInformation.setSmtpCheckHost(smtpCheckPop3Host);
        nodeInformation.setSmtpCheckPort(smtpCheckPop3Port);
        nodeInformation.setSmtpCheckTimeout(smtpCheckPop3Timeout);
        nodeInformation.setSmtpCheckUser(smtpCheckPop3User);
        nodeInformation.setSmtpCheckPassword(smtpCheckPop3Password);
        return nodeInformation;
    }

    public ArrayList getLinkList() {
        return this.linkList;
    }

    public ArrayList getNodeInfoList() {
        return this.nodeInfoList;
    }
}

