/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodemaneger.map;

import java.util.ArrayList;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.nodemaneger.map.NodeMapInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.engine.view.canvas.CanvasViewConfig;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class NodeMapViewDraw {
    private static Color WHITE_COLOR;
    private static Color BLACK_COLOR;
    private static Color RED_COLOR;
    private static Color TEST_COLOR;
    private static final int NODE_NAME_Y_OFFSET = 40;
    private static final int NODE_IPADDRESS_Y_OFFSET = 60;
    private static final int NODE_OVAL_VIEW_OFFSET = 3;
    private static final int NODE_ICON_LINK_OFFSET = 10;
    private Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private Display display;
    private Canvas canvas;
    private GC gc;
    private ScrolledComposite scrollComposite;
    private Point mapScrollCompositePoint;
    private int overviewPointX;
    private int overviewPointY;
    private int canvaAbsPointX;
    private int canvaAbsPointY;
    private int nodeMapViewWidth;
    private int nodeMapViewHeight;
    private static final int OVERVIEW_POINT_SCALL = 20;

    public NodeMapViewDraw(Display display, ScrolledComposite scrollComposite, Canvas canvas, GC gc) {
        this.display = display;
        this.scrollComposite = scrollComposite;
        this.canvas = canvas;
        this.gc = gc;
        this.nodeMapViewWidth = CanvasViewConfig.getInstance().getCanvasSizeInfo().getNodeMapWidth();
        this.nodeMapViewHeight = CanvasViewConfig.getInstance().getCanvasSizeInfo().getNodeMapHeight();
        WHITE_COLOR = new Color(null, 255, 255, 255);
        BLACK_COLOR = new Color(null, 0, 0, 0);
        RED_COLOR = new Color(null, 255, 0, 0);
        TEST_COLOR = new Color(null, 127, 127, 127);
    }

    public void redraw(ArrayList nodeMapNodeInfoList, NodeMapLinkInformation nodMapLinkInformationList) {
        this.gc.fillRectangle(this.canvas.getClientArea());
        int height = this.canvas.getClientArea().height - 1;
        int width = this.canvas.getClientArea().width - 1;
        this.gc.setForeground(TEST_COLOR);
        this.gc.drawLine(0, 0, width, 0);
        this.gc.drawLine(0, 0, 0, height);
        this.gc.setForeground(WHITE_COLOR);
        this.gc.drawLine(width, 0, width, height);
        this.gc.drawLine(0, height, width, height);
        this.gc.setBackground(WHITE_COLOR);
        this.gc.setForeground(BLACK_COLOR);
        this.createOverviewPoint();
        this.setMapOverviewNode();
        this.drawNodeLink(nodeMapNodeInfoList, nodMapLinkInformationList);
        this.drawNode(nodeMapNodeInfoList);
    }

    protected void createOverviewPoint() {
        Point canvaPoint = this.canvas.getLocation();
        this.canvaAbsPointX = Math.abs(canvaPoint.x);
        this.canvaAbsPointY = Math.abs(canvaPoint.y);
        this.mapScrollCompositePoint = this.scrollComposite.getSize();
        this.overviewPointX = this.canvaAbsPointX;
        this.overviewPointY = this.canvaAbsPointY + (this.mapScrollCompositePoint.y - 20) - this.nodeMapViewHeight / 20;
    }

    protected void setMapOverviewNode() {
        this.gc.setForeground(BLACK_COLOR);
        this.gc.setLineStyle(3);
        this.gc.drawRectangle(this.overviewPointX, this.overviewPointY, this.nodeMapViewWidth / 20, this.nodeMapViewHeight / 20);
        this.gc.setLineWidth(2);
        this.gc.setLineStyle(1);
        this.gc.drawRectangle(this.overviewPointX + this.canvaAbsPointX / 20, this.overviewPointY + this.canvaAbsPointY / 20, this.mapScrollCompositePoint.x / 20, this.mapScrollCompositePoint.y / 20);
        this.gc.setLineWidth(1);
    }

    protected void setMapOverviewNode(int nodex, int nodey) {
        this.gc.drawRectangle(this.overviewPointX + nodex / 20, this.overviewPointY + nodey / 20, 3, 3);
    }

    protected void drawNode(ArrayList nodeMapNodeInfoList) {
        this.setColor();
        int i = 0;
        while (i < nodeMapNodeInfoList.size()) {
            NodeMapInfo nodeMapInfo = (NodeMapInfo)nodeMapNodeInfoList.get(i);
            int pointX = nodeMapInfo.getX();
            int pointY = nodeMapInfo.getY();
            this.gc.setForeground(BLACK_COLOR);
            if (!nodeMapInfo.isSelected()) {
                this.gc.drawImage(nodeMapInfo.getNodeIconImage(), pointX, pointY);
            } else {
                this.gc.drawImage(nodeMapInfo.getNodeIconImage(), pointX, pointY);
                this.gc.drawOval(pointX, pointY, nodeMapInfo.getWidth(), nodeMapInfo.getHeight());
            }
            this.setMapOverviewNode(pointX, pointY);
            this.gc.drawString(nodeMapInfo.getNodeInfo().getNodename(), pointX, pointY + 40);
            this.gc.drawString(nodeMapInfo.getNodeInfo().getIpaddress(), pointX, pointY + 60);
            NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
            if (nodeInfo.getAlarmMessage() != null && !nodeInfo.getAlarmMessage().equals("")) {
                this.gc.setForeground(RED_COLOR);
                this.gc.drawString(String.valueOf(nodeMapInfo.getNodeInfo().getAlarmDate()) + " : " + nodeMapInfo.getNodeInfo().getAlarmMessage(), pointX, pointY + 80);
                this.gc.drawLine(pointX, pointY, pointX + nodeMapInfo.getWidth(), pointY + nodeMapInfo.getHeight());
                this.gc.drawLine(pointX + nodeMapInfo.getWidth(), pointY, pointX, pointY + nodeMapInfo.getHeight());
                this.gc.setForeground(BLACK_COLOR);
            }
            ++i;
        }
    }

    protected void drawNodeLink(ArrayList nodeMapNodeInfoList, NodeMapLinkInformation nodMapLinkInformationList) {
        if (nodMapLinkInformationList == null) {
            return;
        }
        ArrayList nodeLinkList0 = nodMapLinkInformationList.getNode0address();
        ArrayList nodeLinkList1 = nodMapLinkInformationList.getNode1address();
        int i = 0;
        while (i < nodeLinkList0.size()) {
            String nodeX = (String)nodeLinkList0.get(i);
            String nodeY = (String)nodeLinkList1.get(i);
            int j = 0;
            while (j < nodeMapNodeInfoList.size()) {
                NodeMapInfo nodeMapInfo = (NodeMapInfo)nodeMapNodeInfoList.get(j);
                NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
                if (nodeX.equals(nodeInfo.getIpaddress())) {
                    int k = 0;
                    while (k < nodeMapNodeInfoList.size()) {
                        NodeMapInfo nodeMapInfo2 = (NodeMapInfo)nodeMapNodeInfoList.get(k);
                        NodeInformation nodeInfo2 = nodeMapInfo2.getNodeInfo();
                        if (nodeY.equals(nodeInfo2.getIpaddress())) {
                            int x0 = (int)Float.parseFloat(nodeInfo.getNodeX()) + 10;
                            int y0 = (int)Float.parseFloat(nodeInfo.getNodeY()) + 10;
                            int x1 = (int)Float.parseFloat(nodeInfo2.getNodeX()) + 10;
                            int y1 = (int)Float.parseFloat(nodeInfo2.getNodeY()) + 10;
                            this.gc.setForeground(BLACK_COLOR);
                            this.gc.drawLine(x0, y0, x1, y1);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void setColor() {
        if (WHITE_COLOR == null || WHITE_COLOR.isDisposed()) {
            WHITE_COLOR = new Color(null, 255, 255, 255);
        }
        if (BLACK_COLOR == null || BLACK_COLOR.isDisposed()) {
            BLACK_COLOR = new Color(null, 0, 0, 0);
        }
        if (RED_COLOR == null || RED_COLOR.isDisposed()) {
            RED_COLOR = new Color(null, 255, 0, 0);
        }
        if (TEST_COLOR == null || TEST_COLOR.isDisposed()) {
            TEST_COLOR = new Color(null, 127, 127, 127);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (WHITE_COLOR != null && !WHITE_COLOR.isDisposed()) {
            WHITE_COLOR.dispose();
        }
        if (BLACK_COLOR != null && !BLACK_COLOR.isDisposed()) {
            BLACK_COLOR.dispose();
        }
        if (RED_COLOR != null && !RED_COLOR.isDisposed()) {
            RED_COLOR.dispose();
        }
        if (TEST_COLOR != null && !TEST_COLOR.isDisposed()) {
            TEST_COLOR.dispose();
        }
        if (this.gc != null && !this.gc.isDisposed()) {
            this.gc.dispose();
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
    }
}

