/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.resource;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class CommandPlatform {
    private static Logger logger = null;
    private String pingCommand;
    private String pingResponce;

    private CommandPlatform() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static CommandPlatform getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void parseCommandXML() {
        String osName = System.getProperty("os.name");
        String[] lowerOSName = osName.toLowerCase().split(" ");
        Document doc = this.getDocument();
        try {
            Element root = doc.getRootElement();
            Element pingEl = root.getChild("ping");
            if (lowerOSName.length > 1 && lowerOSName[0] == "windows") {
                this.pingCommand = pingEl.getChild(lowerOSName[0]).getChild("command").getAttributeValue("value");
                this.pingResponce = pingEl.getChild(lowerOSName[0]).getChild("responce").getAttributeValue("value");
            } else {
                this.pingCommand = pingEl.getChild("linux").getChild("command").getAttributeValue("value");
                this.pingResponce = pingEl.getChild("linux").getChild("responce").getAttributeValue("value");
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        System.out.println("OS Name : " + lowerOSName[0]);
        System.out.println("ping_command : " + this.pingCommand);
        System.out.println("ping_responce : " + this.pingResponce);
    }

    private Document getDocument() {
        URL url;
        Document doc;
        block6: {
            doc = null;
            ClassLoader loader = SystemResourceFileParse.class.getClassLoader();
            url = loader.getResource("resources/command.xml");
            if (url != null) break block6;
            logger.severe("Command XML file : resources/command.xml");
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            if (builder != null) {
                doc = builder.build(url.openStream());
            }
        }
        catch (JDOMException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    public String getPingCommand() {
        return this.pingCommand;
    }

    public String getPingResponce() {
        return this.pingResponce;
    }

    /* synthetic */ CommandPlatform(CommandPlatform commandPlatform) {
        this();
    }

    private static class SingletonResource {
        static final CommandPlatform RESOURCE = new CommandPlatform(null);

        private SingletonResource() {
        }
    }
}

