/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.control;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.control.QueueForDefaultSnmpMib;
import netjfwatcher.engine.server.protocol.snmp.SnmpInterfacesMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpPrintMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpSystemMibGet;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

public class ThreadQueueCheckDefaultSnmpMibGet
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger;

    public ThreadQueueCheckDefaultSnmpMibGet() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        SnmpSystemMibGet systemMibGetInstance = new SnmpSystemMibGet();
        SnmpInterfacesMibGet interfacesMibGetInstance = new SnmpInterfacesMibGet();
        SnmpPrintMibGet printMibGetInstance = new SnmpPrintMibGet();
        while (!Thread.interrupted()) {
            NodeWatchInfo infoPopQueue = QueueForDefaultSnmpMib.getInstance().popQueue();
            NodeWatchInfo checkIPAddress = null;
            if (infoPopQueue != null) {
                checkIPAddress = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(infoPopQueue.getIpaddress());
            }
            if (infoPopQueue != null && checkIPAddress != null) {
                String targetIpAddress = infoPopQueue.getIpaddress();
                logger.info("System/Interfaces MIB Get IP Address=" + targetIpAddress + " Version=" + infoPopQueue.getSnmpVersion());
                try {
                    systemMibGetInstance.setSnmpSystemMibGet(targetIpAddress, infoPopQueue.getSnmpVersion(), infoPopQueue.getSnmpROCommunity());
                    systemMibGetInstance.getSystemMIB();
                    interfacesMibGetInstance.setSnmpInterfacesMibGet(targetIpAddress, infoPopQueue.getSnmpVersion(), infoPopQueue.getSnmpROCommunity());
                    interfacesMibGetInstance.getInterfacesMIB();
                    if (infoPopQueue.getNodeKind().equals("Printer")) {
                        logger.info("Print MIB Get IP Address=" + targetIpAddress + " Version=" + infoPopQueue.getSnmpVersion());
                        printMibGetInstance.setSnmpPrintMibGet(targetIpAddress, infoPopQueue.getSnmpVersion(), infoPopQueue.getSnmpROCommunity());
                        printMibGetInstance.getPrintMIB();
                    }
                }
                catch (UnknownHostException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                catch (SocketException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                catch (SnmpMIBGetException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                try {
                    LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate.getInstance();
                    updateLastCheckTime.updateCheckTime(targetIpAddress);
                }
                catch (DatabaseConnectionException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

