/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.OidGetInfo;
import netjfwatcher.engine.server.protocol.control.QueueForStatisticsMib;
import netjfwatcher.engine.server.protocol.snmp.ExecuteStatisticsMibGet;

public class ThreadQueueCheckStatisticsMibGet
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger;

    public ThreadQueueCheckStatisticsMibGet() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        ExecuteStatisticsMibGet statisticsMibGet = new ExecuteStatisticsMibGet();
        while (!Thread.interrupted()) {
            OidGetInfo oidGetInfo = QueueForStatisticsMib.getInstance().popQueue();
            NodeWatchInfo checkIPAddress = null;
            if (oidGetInfo != null) {
                checkIPAddress = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(oidGetInfo.getTargetIpAddress());
            }
            if (oidGetInfo != null && checkIPAddress != null) {
                String targetIpAddress = oidGetInfo.getTargetIpAddress();
                String targetOid = oidGetInfo.getTargetOid();
                String community = oidGetInfo.getROCommunity();
                int version = oidGetInfo.getVersion();
                statisticsMibGet.execute(targetIpAddress, version, community, targetOid, oidGetInfo.getThreshHold(), oidGetInfo.getThreshHoldType());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

