/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.pop;

import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;

public class ExecutePopCheck {
    private static Logger logger = null;

    public ExecutePopCheck() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void checkPop(NodeWatchInfo nodeInfo) {
        String popHost = nodeInfo.getIpaddress();
        String popUser = nodeInfo.getPopUser();
        String popPassword = nodeInfo.getPopPassword();
        int popPort = -1;
        String popTimeout = nodeInfo.getPopTimeout();
        Store store = null;
        try {
            try {
                try {
                    popPort = Integer.parseInt(nodeInfo.getPopPort());
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warning("NumberFormatException Pop Port = " + nodeInfo.getPopPort());
                }
                Properties props = System.getProperties();
                try {
                    int timeout = Integer.parseInt(popTimeout);
                    if (timeout > 0) {
                        props.put("mail.pop3.connectiontimeout", popTimeout);
                        props.put("mail.pop3.timeout", popTimeout);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warning("NumberFormatException timeout = " + popTimeout);
                }
                System.out.println("popPort : " + popPort);
                System.out.println(props.getProperty("mail.pop3.connectiontimeout"));
                System.out.println(props.getProperty("mail.pop3.timeout"));
                Session session = Session.getDefaultInstance((Properties)props, null);
                store = session.getStore("pop3");
                store.connect(popHost, popPort, popUser, popPassword);
                if (AlarmRecovery.getInstance().isOccurredAlarmId(popHost, "19")) {
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setRecoveryPop3Error(popHost, "Pop3 server = " + popHost);
                }
            }
            catch (MessagingException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
                makeAlarm.setPop3Error(popHost, "MessagingException : " + e.getMessage());
            }
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (MessagingException e1) {
                    e1.printStackTrace();
                    logger.warning("MessagingException " + e1.getMessage());
                }
            }
        }
        try {
            LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate.getInstance();
            updateLastCheckTime.updateCheckTime(nodeInfo.getIpaddress());
        }
        catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}

