/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.taskschedule;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableTaskSchedule;
import netjfwatcher.engine.server.taskschedule.TaskEnd;
import netjfwatcher.engine.server.taskschedule.TaskStart;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;

public final class TaskScheduleControl {
    private static Logger logger = null;
    private Map<String, TaskScheduleInfo> taskScheduleList = Collections.synchronizedMap(new HashMap());

    private TaskScheduleControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void setTaskSchedule(Date setStartDate, Date setEndDate) {
        Timer taskTimer = new Timer();
        TaskStart threadStartTask = new TaskStart();
        taskTimer.schedule((TimerTask)threadStartTask, setStartDate);
        TaskEnd threadStopTask = new TaskEnd();
        taskTimer.schedule((TimerTask)threadStopTask, setEndDate);
        TaskScheduleInfo info = new TaskScheduleInfo();
        info.setTaskStartDate(setStartDate);
        info.setTaskEndDate(setEndDate);
        info.setTaskTimer(taskTimer);
        info.setId(info.hashCode());
        this.taskScheduleList.put(Integer.toString(info.hashCode()), info);
        logger.info("Task ID=" + info.hashCode());
        logger.info("Task Start date=" + info.getTaskStartDate());
        logger.info("Task End   date=" + info.getTaskEndDate());
        try {
            DBTableTaskSchedule taskScheduleTabel = DBTableTaskSchedule.getInstance();
            taskScheduleTabel.put(Integer.toString(info.hashCode()), info.getTaskStartDate(), info.getTaskEndDate());
        }
        catch (DatabaseConnectionException e) {
            logger.warning("DatabaseConnectionException " + e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning("SQLException " + e.getMessage());
            e.printStackTrace();
        }
    }

    public synchronized void setTaskSchedule(TaskScheduleInfo info) {
        Timer taskTimer = new Timer();
        TaskStart threadStartTask = new TaskStart();
        taskTimer.schedule((TimerTask)threadStartTask, info.getTaskStartDate());
        TaskEnd threadStopTask = new TaskEnd();
        taskTimer.schedule((TimerTask)threadStopTask, info.getTaskEndDate());
        info.setTaskTimer(taskTimer);
        info.setId(Integer.parseInt(info.getTaskID()));
        this.taskScheduleList.put(info.getTaskID(), info);
        logger.info("Task ID=" + info.getId());
        logger.info("Task Start date=" + info.getTaskStartDate());
        logger.info("Task End   date=" + info.getTaskEndDate());
    }

    public synchronized void cancelTaskSchedule(TaskScheduleInfo info) {
        logger.info("Cancel Task ID=" + info.getId());
        info.getTaskTimer().cancel();
        this.taskScheduleList.remove(info.getTaskID());
        try {
            DBTableTaskSchedule taskScheduleTabel = DBTableTaskSchedule.getInstance();
            taskScheduleTabel.deleteTaskSchedule(info.getTaskID());
        }
        catch (DatabaseConnectionException e) {
            logger.warning("DatabaseConnectionException " + e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning("SQLException " + e.getMessage());
            e.printStackTrace();
        }
    }

    public synchronized Map getTaskSchedule() {
        return this.taskScheduleList;
    }

    public static TaskScheduleControl getInstance() {
        return SingletonResource.INSTANCE;
    }

    /* synthetic */ TaskScheduleControl(TaskScheduleControl taskScheduleControl) {
        this();
    }

    private static class SingletonResource {
        static final TaskScheduleControl INSTANCE = new TaskScheduleControl(null);

        private SingletonResource() {
        }
    }
}

