/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;

public class SnmpManagerCreateSendMessage {
    private static Logger logger;
    private SnmpMessage snmpMessage = new SnmpMessage();
    private SnmpPDU pdu = new SnmpPDU();
    private SnmpSequence varList = new SnmpSequence();
    private SnmpVariablePair nextPair = new SnmpVariablePair();
    private SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier();
    private SnmpNull snmpNull = new SnmpNull();

    public SnmpManagerCreateSendMessage() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public SnmpMessage createSNMPMessage(int version, String community, int requestID, String requestOID, byte pduType) throws SnmpBadValueException {
        try {
            this.pdu = this.createPDU(requestID, requestOID, pduType, this.snmpNull);
            this.snmpMessage.setSNMPMessage(version, community, this.pdu);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create message : " + e.getMessage());
            e.printStackTrace();
            throw new SnmpBadValueException(String.valueOf(requestOID) + " : " + e.getMessage());
        }
        return this.snmpMessage;
    }

    private SnmpPDU createPDU(int requestID, String requestOID, byte pduType, AbstractSnmpObject newValue) throws SnmpBadValueException {
        int errorStatus = 0;
        int errorIndex = 0;
        try {
            this.requestedObjectIdentifier.setSNMPObjectIdentifier(requestOID);
            this.nextPair.setSNMPVariablePair(this.requestedObjectIdentifier, newValue);
            this.varList.clearSNMPObjectList();
            this.varList.addSNMPObject(this.nextPair);
            this.pdu.setSNMPPDU(pduType, requestID, errorStatus, errorIndex, this.varList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create message : " + e.getMessage());
            e.printStackTrace();
            throw new SnmpBadValueException(String.valueOf(requestOID) + " : " + e.getMessage());
        }
        return this.pdu;
    }
}

