/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.nodedetect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.AlarmPut;
import netjfwatcher.engine.server.protocol.ping.PingExcecEngine;
import netjfwatcher.engine.snmpmanager.process.ManagerDispatcher;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.engine.view.editorpart.nodedetect.NodeDetectFile;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;

public final class ThreadAutoNodeDetect
implements Runnable {
    private static Logger logger;
    private ArrayList checkNodeAddressList;
    private ArrayList<String> pingOKList = new ArrayList();
    private ArrayList<String> pingNGList = new ArrayList();
    private ArrayList<String> snmpOKList = new ArrayList();
    private ArrayList<String> snmpNGList = new ArrayList();
    private ArrayList<String> snmpIFOKList = new ArrayList();
    private ArrayList<String> snmpIFNGList = new ArrayList();
    private ArrayList<String> snmpPrintOKList = new ArrayList();
    private ArrayList<String> snmpPrintNGList = new ArrayList();
    private HashMap<String, String> nodeKindMap = new HashMap();
    private Thread nodeDiscoveryThread;
    private String timeoutMilliSecParam = "1000";
    private String retryParam = "1";
    private String snmpROCommunity = "public";
    private int snmpVersion = 0;
    private boolean isDiscoveryNoCancel;
    private PingExcecEngine execPingInstance;
    private HashMap nodeDectMap;

    private ThreadAutoNodeDetect() {
        logger = Logger.getLogger(this.getClass().getName());
        this.nodeDectMap = NodeDetectFile.getInstance().getNodeDetectMap();
    }

    public synchronized void startThread(ArrayList checkNodeAddressList) {
        this.checkNodeAddressList = checkNodeAddressList;
        this.isDiscoveryNoCancel = true;
        this.resetNodeDetect();
        this.nodeDiscoveryThread = new Thread(ThreadAutoNodeDetect.getInstance());
        this.nodeDiscoveryThread.start();
    }

    public synchronized void stopThread() {
        this.isDiscoveryNoCancel = false;
    }

    private void resetNodeDetect() {
        this.pingOKList.clear();
        this.pingNGList.clear();
        this.snmpOKList.clear();
        this.snmpNGList.clear();
        this.snmpIFOKList.clear();
        this.snmpIFNGList.clear();
        this.nodeKindMap.clear();
        this.snmpPrintOKList.clear();
        this.snmpPrintNGList.clear();
    }

    public void run() {
        this.execPingInstance = new PingExcecEngine(this.timeoutMilliSecParam, this.retryParam);
        AlarmPut.getInstance().setNodeDiscovery(true);
        int i = 0;
        while (i < this.checkNodeAddressList.size()) {
            if (!this.isDiscoveryNoCancel) break;
            this.executePing((String)this.checkNodeAddressList.get(i));
            ++i;
        }
        AlarmPut.getInstance().setNodeDiscovery(false);
    }

    private void executePing(String targetIPAddress) {
        this.execPingInstance.setTargetIPAddress(targetIPAddress);
        if (this.execPingInstance.checkPingResponse()) {
            this.execPingInstance.getDifftime();
            this.execPingInstance.getDifftime();
            this.checkSnmp(targetIPAddress, this.snmpVersion, this.snmpROCommunity);
            this.pingOKList.add(targetIPAddress);
        } else {
            this.execPingInstance.getDifftime();
            this.pingNGList.add(targetIPAddress);
        }
    }

    private void checkSnmp(String targeIP, int version, String community) {
        try {
            String returnOID = this.getNodeMIB(targeIP, "1.3.6.1.2.1.1.1", version, community, true);
            if (returnOID.indexOf("1.3.6.1.2.1.1.1") >= 0) {
                this.snmpOKList.add(targeIP);
                returnOID = this.getNodeMIB(targeIP, "1.3.6.1.2.1.2.1", version, community, true);
                if (returnOID.indexOf("1.3.6.1.2.1.2.1") >= 0) {
                    this.snmpIFOKList.add(targeIP);
                } else {
                    this.snmpIFNGList.add(targeIP);
                }
                this.checkPrintSnmp(targeIP, this.snmpVersion, this.snmpROCommunity);
            } else {
                this.snmpNGList.add(targeIP);
            }
        }
        catch (SnmpMIBGetException snmpMIBGetException) {
            this.snmpNGList.add(targeIP);
        }
    }

    private void checkPrintSnmp(String targeIP, int version, String community) {
        try {
            String hrDeviceTypeVale = this.getNodeMIB(targeIP, "1.3.6.1.2.1.25.3.2.1.2", version, community, false);
            if (hrDeviceTypeVale != null && hrDeviceTypeVale.indexOf("1.3.6.1.2.1.25.3.1.5") >= 0) {
                this.snmpPrintOKList.add(targeIP);
                this.nodeKindMap.put(targeIP, "Printer");
            } else {
                this.snmpPrintNGList.add(targeIP);
            }
        }
        catch (SnmpMIBGetException snmpMIBGetException) {
            this.snmpPrintNGList.add(targeIP);
        }
    }

    private String getNodeMIB(String targetIP, String oid, int version, String community, boolean isOIDReturn) throws SnmpMIBGetException {
        Object mibGetInstance = null;
        String returnOID = "";
        AbstractSnmpObject responseValue = null;
        ManagerDispatcher dispacher = null;
        try {
            try {
                String returnOid = oid;
                dispacher = new ManagerDispatcher();
                dispacher.setManagerDispatcher(targetIP, community, version);
                SnmpVarBindList newVars = dispacher.dispathGetMessage(version, (byte)-95, returnOid);
                SnmpSequence responsePair = (SnmpSequence)newVars.getSNMPObjectAt(0);
                SnmpObjectIdentifier responseOID = (SnmpObjectIdentifier)responsePair.getSNMPObjectAt(0);
                responseValue = responsePair.getSNMPObjectAt(1);
                returnOID = responseOID.toString();
                if (oid.equals("1.3.6.1.2.1.1.1")) {
                    this.autoDetectNodeKind(targetIP, responseValue.toString());
                }
            }
            catch (SnmpV3AuthAbortException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + targetIP);
                throw new SnmpMIBGetException(e.getMessage());
            }
            catch (SnmpV3DecryptAbortException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + targetIP);
                throw new SnmpMIBGetException(e.getMessage());
            }
            catch (SnmpMIBGetException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + targetIP);
                throw e;
            }
            catch (SnmpSetException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + targetIP);
                throw new SnmpMIBGetException(e.getMessage());
            }
            catch (SnmpV3ConfigurationException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + targetIP);
                throw new SnmpMIBGetException(e.getMessage());
            }
            catch (Exception e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + targetIP);
                throw new SnmpMIBGetException(e.getMessage());
            }
        }
        finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(targetIP, Thread.currentThread().getName());
            }
        }
        if (isOIDReturn) {
            return returnOID;
        }
        return responseValue.toString();
    }

    private void autoDetectNodeKind(String ipAddress, String value) {
        if (this.nodeDectMap != null && this.nodeDectMap.size() > 0) {
            for (String key : this.nodeDectMap.keySet()) {
                if (value.indexOf(key) < 0) continue;
                String nodeKind = (String)this.nodeDectMap.get(key);
                this.nodeKindMap.put(ipAddress, nodeKind);
            }
        } else {
            if (value.indexOf("Windows") >= 0) {
                this.nodeKindMap.put(ipAddress, "Windows");
            }
            if (value.indexOf("Linux") >= 0) {
                this.nodeKindMap.put(ipAddress, "Linux");
            }
            if (value.indexOf("Redhat") >= 0) {
                this.nodeKindMap.put(ipAddress, "Redhat");
            }
            if (value.indexOf("Router") >= 0) {
                this.nodeKindMap.put(ipAddress, "Router");
            }
            if (value.indexOf("LR") >= 0) {
                this.nodeKindMap.put(ipAddress, "Router");
            }
        }
    }

    public void setNodeCheckParam(String timeoutMilliSecParam, int snmpVersion, String snmpROCommunity) {
        this.timeoutMilliSecParam = timeoutMilliSecParam;
        this.snmpVersion = snmpVersion;
        this.snmpROCommunity = snmpROCommunity;
    }

    public ArrayList getCheckNodeAddressList() {
        return this.checkNodeAddressList;
    }

    public ArrayList getPingNGList() {
        return this.pingNGList;
    }

    public ArrayList getPingOKList() {
        return this.pingOKList;
    }

    public ArrayList getSnmpNGList() {
        return this.snmpNGList;
    }

    public ArrayList getSnmpOKList() {
        return this.snmpOKList;
    }

    public ArrayList getSnmpIFOKList() {
        return this.snmpIFOKList;
    }

    public ArrayList getSnmpIFNGList() {
        return this.snmpIFNGList;
    }

    public HashMap getNodeKindMap() {
        return this.nodeKindMap;
    }

    public static ThreadAutoNodeDetect getInstance() {
        return SingletonResource.THREAD;
    }

    /* synthetic */ ThreadAutoNodeDetect(ThreadAutoNodeDetect threadAutoNodeDetect) {
        this();
    }

    private static class SingletonResource {
        static final ThreadAutoNodeDetect THREAD = new ThreadAutoNodeDetect(null);

        private SingletonResource() {
        }
    }
}

