/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;

public class SnmpObjectIdentifier
extends AbstractSnmpObject {
    private int[] digits;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public SnmpObjectIdentifier() {
        this.digits = new int[0];
        this.tag = (byte)6;
        this.tagDescription = "OBJECTIDENTIFIER";
    }

    public SnmpObjectIdentifier(String digitString) throws SnmpBadValueException {
        this.convertDigitString(digitString);
        this.tag = (byte)6;
        this.tagDescription = "OBJECTIDENTIFIER";
    }

    public SnmpObjectIdentifier(int[] digits) throws SnmpBadValueException {
        int i = 0;
        while (i < digits.length) {
            if (digits[i] < 0) {
                throw new SnmpBadValueException("Negative value supplied for SNMPObjectIdentifier.");
            }
            ++i;
        }
        this.digits = digits;
        this.tag = (byte)6;
        this.tagDescription = "OBJECTIDENTIFIER";
    }

    public SnmpObjectIdentifier(byte[] enc) {
        this.extractFromBEREncoding(enc);
        this.tag = (byte)6;
        this.tagDescription = "OBJECTIDENTIFIER";
    }

    public void setSNMPObjectIdentifier(String digitString) throws SnmpBadValueException {
        this.convertDigitString(digitString);
    }

    public Object getValue() {
        return this.digits;
    }

    public void setValue(Object digits) throws SnmpBadValueException {
        if (digits instanceof int[]) {
            int i = 0;
            while (i < ((int[])digits).length) {
                if (((int[])digits)[i] < 0) {
                    throw new SnmpBadValueException("Negative value supplied for SNMPObjectIdentifier.");
                }
                ++i;
            }
            this.digits = (int[])digits;
        } else if (digits instanceof String) {
            this.convertDigitString((String)digits);
        } else {
            throw new SnmpBadValueException(" Object Identifier: bad object supplied to set value ");
        }
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;
        try {
            int type = 6;
            byte[] data = this.encodeArray();
            byte[] len = this.encodeLength(data.length);
            outBytes.write(type);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);
            outBytesArray = outBytes.toByteArray();
        }
        finally {
            try {
                outBytes.close();
            }
            catch (IOException e) {
                this.logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        return outBytesArray;
    }

    private byte[] encodeArray() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;
        try {
            int numElements = this.digits.length;
            if (numElements >= 2) {
                outBytes.write((byte)(40 * this.digits[0] + this.digits[1]));
            } else if (numElements == 1) {
                outBytes.write((byte)(40 * this.digits[0]));
            }
            int i = 2;
            while (i < numElements) {
                byte[] nextBytes = this.encodeValue(this.digits[i]);
                outBytes.write(nextBytes, 0, nextBytes.length);
                ++i;
            }
            outBytesArray = outBytes.toByteArray();
        }
        finally {
            try {
                outBytes.close();
            }
            catch (IOException e) {
                this.logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        return outBytesArray;
    }

    private byte[] encodeValue(int intValue) {
        int numBytes = 0;
        int temp = intValue;
        do {
            ++numBytes;
        } while ((temp = (int)Math.floor(temp / 128)) > 0);
        byte[] enc = new byte[numBytes];
        enc[numBytes - 1] = (byte)(intValue % 128);
        int length = (int)Math.floor(intValue / 128);
        int i = numBytes - 2;
        while (i >= 0) {
            enc[i] = (byte)(length % 128 + 128);
            length = (int)Math.floor(length / 128);
            --i;
        }
        return enc;
    }

    private void convertDigitString(String digitString) throws SnmpBadValueException {
        try {
            StringTokenizer st = new StringTokenizer(digitString, " .");
            int size = 0;
            while (st.hasMoreTokens()) {
                ++size;
                st.nextToken();
            }
            int[] returnDigits = new int[size];
            st = new StringTokenizer(digitString, " .");
            int i = 0;
            while (i < size) {
                returnDigits[i] = Integer.parseInt(st.nextToken());
                if (returnDigits[i] < 0) {
                    throw new SnmpBadValueException(" Object Identifier: bad string supplied to set value ");
                }
                ++i;
            }
            this.digits = returnDigits;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SnmpBadValueException(" Object Identifier: bad string supplied for object identifier value ");
        }
    }

    private void extractFromBEREncoding(byte[] enc) {
        int bitTest = 128;
        int highBitMask = 127;
        int numInts = 0;
        int i = 0;
        while (i < enc.length) {
            if ((enc[i] & bitTest) == 0) {
                ++numInts;
            }
            ++i;
        }
        if (numInts > 0) {
            this.digits = new int[numInts + 1];
            int currentByte = -1;
            int value = 0;
            do {
                value = value * 128 + (enc[++currentByte] & highBitMask);
            } while ((enc[currentByte] & bitTest) > 0);
            this.digits[0] = (int)Math.floor(value / 40);
            this.digits[1] = value % 40;
            int i2 = 2;
            while (i2 < numInts + 1) {
                value = 0;
                do {
                    value = value * 128 + (enc[++currentByte] & highBitMask);
                } while ((enc[currentByte] & bitTest) > 0);
                this.digits[i2] = value;
                ++i2;
            }
        } else {
            this.digits = new int[0];
        }
    }

    public boolean equalsOid(SnmpObjectIdentifier other) {
        int[] otherDigits = (int[])other.getValue();
        boolean areEqual = true;
        if (this.digits.length != otherDigits.length) {
            areEqual = false;
        } else {
            int i = 0;
            while (i < this.digits.length) {
                if (this.digits[i] != otherDigits[i]) {
                    areEqual = false;
                    break;
                }
                ++i;
            }
        }
        return areEqual;
    }

    public String toString() {
        String valueString = "";
        valueString = String.valueOf(valueString) + this.digits[0];
        int i = 1;
        while (i < this.digits.length) {
            valueString = String.valueOf(valueString) + "." + this.digits[i];
            ++i;
        }
        return valueString;
    }
}

