/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpv3;

import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3OID;
import netjfwatcher.snmp.snmpv3.UsmLocalizeKey;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;

public final class UsmUserAgentManager {
    private static Logger logger;
    private Map userEntryMapList = Collections.synchronizedMap(new Hashtable());
    private List usmUserEntryList = Collections.synchronizedList(new LinkedList());

    private UsmUserAgentManager() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static UsmUserAgentManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void registAgentList(SnmpEngineID snmpEngineID, SnmpV3AgentConfigInfo info) throws SnmpV3ConfigurationException {
        String userName = null;
        String authPriv = null;
        String authProtocol = null;
        String authPassPhrase = null;
        String privProtocol = null;
        String privPassPhrase = null;
        userName = info.getUserName();
        authPriv = info.getAuthPriv();
        authProtocol = info.getAuthProtocol();
        authPassPhrase = info.getAuthPassPhrase();
        privProtocol = info.getPrivProtocol();
        privPassPhrase = info.getPrivPassPhrase();
        if (authPriv == null) {
            throw new SnmpV3ConfigurationException("");
        }
        boolean error = false;
        if (userName == null || authPriv == null) {
            error = true;
        }
        if (authPriv.equals("NOAUTH")) {
            authProtocol = null;
            privProtocol = null;
        } else if (authPriv.equals("AUTH")) {
            privProtocol = null;
            if (authProtocol == null || !authProtocol.equals("MD5") && !authProtocol.equals("SHA")) {
                error = true;
            }
            if (authPassPhrase == null) {
                error = true;
            }
        } else if (authPriv.equals("PRIV")) {
            if (privProtocol == null || !privProtocol.equals("DES")) {
                error = true;
            }
            if (privPassPhrase == null) {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            throw new SnmpV3ConfigurationException("");
        }
        UsmUserEntry usmUserEntry = new UsmUserEntry();
        usmUserEntry.setUsmUserEngineID(snmpEngineID);
        usmUserEntry.setUsmUserName(userName);
        usmUserEntry.setUsmUserSecurityName(userName);
        usmUserEntry.setUsmUserCloneFrom(SnmpV3OID.ZERO_DOT_ZERO);
        try {
            if (authProtocol == null) {
                usmUserEntry.setUsmUserAuthProtocol(UsmUserEntry.USM_NO_AUTH_PROTOCOL);
            } else if (authProtocol.equals("MD5")) {
                usmUserEntry.setUsmUserAuthProtocol(UsmUserEntry.USM_HMAC_MD5_AUTH_PROTOCOL);
                usmUserEntry.setUsmUserAuthKey(new UsmLocalizeKey(authPassPhrase, snmpEngineID, "HmacMD5"));
            } else if (authProtocol.equals("SHA")) {
                usmUserEntry.setUsmUserAuthProtocol(UsmUserEntry.USM_HMAC_SHA_AUTH_PROTOCOL);
                usmUserEntry.setUsmUserAuthKey(new UsmLocalizeKey(authPassPhrase, snmpEngineID, "HmacSHA1"));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new SnmpV3ConfigurationException(e.toString());
        }
        usmUserEntry.setUsmUserAuthKeyChange("");
        usmUserEntry.setUsmUserOwnAuthKeyChange("");
        try {
            if (privProtocol == null) {
                usmUserEntry.setUsmUserPrivProtocol(UsmUserEntry.USM_NO_PRIV_PROTOCOL);
            } else if (privProtocol.equals("DES")) {
                usmUserEntry.setUsmUserPrivProtocol(UsmUserEntry.USM_DES_PRIV_PROTOCOL);
                if (authProtocol.equals("MD5")) {
                    usmUserEntry.setUsmUserPrivKey(new UsmLocalizeKey(privPassPhrase, snmpEngineID, "HmacMD5"));
                } else if (authProtocol.equals("SHA")) {
                    usmUserEntry.setUsmUserPrivKey(new UsmLocalizeKey(privPassPhrase, snmpEngineID, "HmacSHA1"));
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new SnmpV3ConfigurationException(e.toString());
        }
        usmUserEntry.setUsmUserPrivKeyChange("");
        usmUserEntry.setUsmUserOwnPrivKeyChange("");
        usmUserEntry.setUsmUserPublic("");
        usmUserEntry.setUsmUserStorageType(2L);
        usmUserEntry.setUsmUserStatus(1L);
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID.toString());
        logger.info(String.valueOf(sb.toString()) + " USM register");
        this.userEntryMapList.put(sb.toString(), usmUserEntry);
        this.usmUserEntryList.add(usmUserEntry);
    }

    public UsmUserEntry getUsmUserEntry(SnmpEngineID snmpEngineID, String userName) {
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID.toString());
        return (UsmUserEntry)this.userEntryMapList.get(sb.toString());
    }

    /* synthetic */ UsmUserAgentManager(UsmUserAgentManager usmUserAgentManager) {
        this();
    }

    private static class SingletonResource {
        static final UsmUserAgentManager RESOURCE = new UsmUserAgentManager(null);

        private SingletonResource() {
        }
    }
}

