/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.view;

import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractNodeTreeView;
import netjfwatcher.webbrowser.nodetree.NodeTreeListener;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;

public class NodeTreeView
extends AbstractNodeTreeView {
    private static Logger logger;

    public NodeTreeView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void initShow() {
        try {
            this.setStatusLine();
        }
        catch (HttpAccessPreferenceException e) {
            e.printStackTrace();
        }
    }

    public void setupNodeTreeViewListener() {
        this.nodeListTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new NodeTreeListener());
    }

    public void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NodeTreeView.this.fillContextMenu(manager);
                try {
                    NodeTreeView.this.setStatusLine();
                }
                catch (HttpAccessPreferenceException e) {
                    e.printStackTrace();
                }
            }
        });
        Menu menu = mm.createContextMenu(this.nodeListTreeViewer.getControl());
        this.nodeListTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.nodeListTreeViewer);
    }

    private void setStatusLine() throws HttpAccessPreferenceException {
        SubStatusLineManager statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        statusLineManager.setVisible(true);
        statusLineManager.setMessage("Access URL = " + HttpAccessPreference.getInstance().getUrl());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.actionNodeTree.actionReloadNodeTreeHttp());
        manager.add(this.actionNodeTree.actionSortNodeTreeHttp());
        manager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    public void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionNodeTreeBuilder().actionReloadNodeTreeHttp());
        toolBarManager.add(this.getActionNodeTreeBuilder().actionSortNodeTreeHttp());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }
}

