/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.garbagecollection.GarbageCollectionMemoryJVM;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.ConnectionGarbageCollection;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;


/**
 * GarbageCollection𐧌䂵܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandGarbageCollection extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /**
     * GarbageCollection𐧌䂵܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        GarbageCollectionControl control =
            com.getGarbageCollectionControlInfo();
        String subCommandCode = control.getCommand();
        GarbageCollectionControl garbageControl =
            new GarbageCollectionControl();

        if (
            subCommandCode.equals(
                    ConnectionGarbageCollection.SUB_COMMAND_ID_GARBAGECOLLECTION_START)) {
            /* GarbageCollectionf[^WJn */
            // logger.info("GarbageCollection start");

            DBTableGarbageCollection gar =
                DBTableGarbageCollection.getInstance();

            try {
                gar.createTable();
            } catch (DatabaseConnectionException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } finally {
                gar = null;
            }

            GarbageCollectionMemoryJVM.getInstance().setSleepTime(
                control.getIntervalTime());
            GarbageCollectionMemoryJVM.getInstance().startThread();

            /*
             * K[x[WRNVf[^̎Jn
             */
            garbageControl.setThreadState(
                GarbageCollectionMemoryJVM.getInstance().checkThread());
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
        } else if (
            subCommandCode.equals(
                    ConnectionGarbageCollection.SUB_COMMAND_ID_GARBAGECOLLECTION_GET)) {


            /*
             * K[x[WRNVf[^̎
             */
            DBTableGarbageCollection gar =
                DBTableGarbageCollection.getInstance();
            ArrayList garbageCollectionDataList = null;

            try {
                garbageCollectionDataList =
                    gar.findAll(control.getStartTime(), control.getEndTime());
                garbageControl = gar.getDataCount();
            } catch (DatabaseConnectionException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            } catch (SQLException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            } catch (Exception e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            } finally {
                gar = null;
            }

            garbageControl.setThreadState(
                GarbageCollectionMemoryJVM.getInstance().checkThread());
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());

            garbageControl.setGarbagCollectionMemoryList(
                garbageCollectionDataList);
            garbageControl.setIntervalTime(
                GarbageCollectionMemoryJVM.getInstance().getSleepTime() / 1000);
        } else if (
            subCommandCode.equals(
                    ConnectionGarbageCollection.SUB_COMMAND_ID_GARBAGECOLLECTION_STOP)) {
            logger.info("GarbageCollection stop");

            /**
             * K[x[WRNVf[^̎~
             */
            GarbageCollectionMemoryJVM.getInstance().stopThread();

            logger.info("GarbageCollectionMemoryJVM thread stop");
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
            garbageControl.setThreadState(
                GarbageCollectionMemoryJVM.getInstance().checkThread());

            logger.info(
                "GarbageCollectionMemoryJVM thread stop thread State : "
                + GarbageCollectionMemoryJVM.getInstance().checkThread());
        } else {
            logger.warning(
                "Undefined GarbageCollection command : " + subCommandCode);
        }

        sendResponse(garbageControl, ois, oos);
    }
}
