/*
 * Created on 2004/07/02
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.server.taskschedule.TaskScheduleControl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;


/**
 * ^XNXPW[ݒ肷R}hNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandTaskScheduleSet extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /**
     * ^XNXPW[Zbg܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        TaskScheduleInfo taskInfo = com.getTaskScheduleInfo();
        Date taskStartDate = taskInfo.getTaskStartDate();
        Date taskEndDate = taskInfo.getTaskEndDate();

        logger.info("Task start : " + taskStartDate.toString());
        logger.info("Task end   : " + taskEndDate.toString());

        TaskScheduleControl.getInstance().setTaskSchedule(
            taskStartDate, taskEndDate);

        sendResponse(CommandMappingTableResource.ACK_RESPONSE, ois, oos);
    }
}
