/*
 * Created on 2004/11/30
 *
 */
package netjfwatcher.engine.garbagecollection;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableGarbageCollection;



/**
 * JVM Garbage Collection[󋵂̎悷Thread
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class GarbageCollectionMemoryJVM implements Runnable {
    /* MO */
    private static Logger logger;

    /* JVM Garbage Collection̎ftHgl */
    private static final long DEFAULT_SLEEP_TIME = 5000;

    /* JVM Garbage Collection̎Thread */
    private Thread thread;

    /* Thread~tO */
    private boolean isStopFlag = false;

    /* JVM Garbage Collection̎ */
    private long sleepTime = DEFAULT_SLEEP_TIME;

    /**
     * JVM Garbage Collection[󋵂̎悷ThreadNXCX^X
     * 𐶐܂B
     */
    private GarbageCollectionMemoryJVM() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * JVM Garbage Collection̎ThreadԂԂ܂B
     *
     * @return JVM Garbage Collection̎Thread:
     * true  : Threadғ
     * false : Thread~
     */
    public synchronized boolean checkThread() {
        boolean isThreadAlive = false;

        if ((thread != null) && thread.isAlive()) {
            isThreadAlive = true;
        }

        return isThreadAlive;
    }

    /**
     * JVM Garbage Collection̎Thraed~܂B
     *
     */
    public synchronized void stopThread() {
        logger.info("Thread Stop");

        if ((thread != null) && thread.isAlive()) {
            logger.info("Thread interrupt.");
            isStopFlag = true;
            thread.interrupt();

            thread = null;
        } else {
            logger.info("No stop Thread");
        }
    }

    /**
     * JVM Garbage Collection[󋵂̎悷ThreadN܂B
     *
     */
    public synchronized void startThread() {
        if ((thread == null) || !thread.isAlive()) {
            isStopFlag = false;

            thread = new Thread(SingletonResource.RESOURCE);

            // thread.setDaemon(true);
            thread.start();
        } else {
            logger.info("Already thread run !!");
        }
    }

    /**
     * JVM Garbage Collection[󋵂̎悵܂B
     *
     */
    public void run() {
        Runtime rt = Runtime.getRuntime();
        DBTableGarbageCollection garbageCollectionTable =
            DBTableGarbageCollection.getInstance();

        while (!isStopFlag) {
            try {
                String totalMemory = Long.toString(rt.totalMemory());
                String freeMemory = Long.toString(rt.freeMemory());

                try {
                    // GarbageCollectione[uɊi[
                    garbageCollectionTable.put(totalMemory, freeMemory);
                } catch (DatabaseConnectionException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                // GCTest.getInstance().testExcexGC();
                Thread.sleep(this.getSleepTime());
            } catch (InterruptedException e) {
                isStopFlag = true;
                logger.info("GarbageCollection thread : " + e.getMessage());
            }
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static GarbageCollectionMemoryJVM getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * ̎Ԃ܂B
     *
     * @return ̎
     */
    public synchronized long getSleepTime() {
        return sleepTime;
    }

    /**
     * ̎Zbg܂B
     *
     * @param time ̎
     */
    public synchronized void setSleepTime(long time) {
        sleepTime = time;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final GarbageCollectionMemoryJVM RESOURCE =
            new GarbageCollectionMemoryJVM();
    }
}
