/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.engine.command.control.CommnadReceiveServer;
import netjfwatcher.engine.mail.ThreadMailSendGuard;
import netjfwatcher.engine.model.thread.ManageEngineThread;
import netjfwatcher.engine.model.thread.TrapReceiveThread;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.server.holdperiod.ThreadPeriodHoldCheck;
import netjfwatcher.engine.server.protocol.control.QueueForDatabseWatch;
import netjfwatcher.engine.server.protocol.control.QueueForDefaultSnmpMib;
import netjfwatcher.engine.server.protocol.control.QueueForHTTP;
import netjfwatcher.engine.server.protocol.control.QueueForPing;
import netjfwatcher.engine.server.protocol.control.QueueForPop3;
import netjfwatcher.engine.server.protocol.control.QueueForSmtp;
import netjfwatcher.engine.server.protocol.control.QueueForStatisticsMib;
import netjfwatcher.engine.server.xmlsocket.XMLSocketServer;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.snmpmanager.trap.TrapListenerImpl;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * EngineɊւANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderEngine {
	/* MO */
	private static Logger logger;

	/* GWNANV */
	private IAction startEngine = new ActionStartEngine();

	/* GW~ANV */
	private IAction stopEngine = new ActionStopEngine();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	/**
	 * EngineɊւANVNXCX^X ܂B
	 * 
	 */
	public ActionBuilderEngine() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * EngineJnANVԂ܂B
	 * 
	 * @return startEngine EngineJnANV
	 */
	public IAction getActionStartEngine() {
		return startEngine;
	}

	/**
	 * Engine~ANVԂ܂B
	 * 
	 * @return stopEngine Engine~ANV
	 */
	public IAction getActionStopEngine() {
		return stopEngine;
	}

	/**
	 * EngineɊւANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private abstract class AbstractEngineAction extends Action {
		/**
		 * ANV܂B
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANV^XNłB
		 * 
		 */
		protected abstract void doTask();
	}

	/**
	 * EngineNANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class ActionStartEngine extends AbstractEngineAction {
		/**
		 * EngineNANṼACRImageDescriptorԂ܂B
		 * 
		 * @return EngineNANṼACRImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/engine.gif"));
		}

		/**
		 * EngineNANVTextԂ܂B
		 * 
		 * @return EngineNANVText
		 */
		public String getText() {
			return "Engine start";
		}

		/**
		 * EngineNANVToolTipTextԂ܂B
		 * 
		 * @return EngineNANVToolTipText
		 * 
		 */
		public String getToolTipText() {
			return "EngineJn܂";
		}

		/**
		 * Engine̋Ns܂B
		 * 
		 */
		protected void doTask() {
			startEngine();
		}

		/*
		 * GWN܂B
		 * 
		 */
		private void startEngine() {
			final Shell shell = new Shell();

			if (EngineStatus.getInstance().isEngine()) {
				MessageDialog.openError(shell, "Already Start Engine",
						"Already Start Engine.");

				if (shell != null) {
					shell.dispose();
				}

				return;
			}

			if (NetJFWatcherApplication.getGenericResourceView() != null
					&& NetJFWatcherApplication.getGenericResourceView()
							.getViewSite().getPage().isEditorAreaVisible()) {
				NetJFWatcherApplication.getGenericResourceView()
						.setDisableAllButton();
			}

			// f[^x[XANZXN
			startDatabase(shell);

			BusyIndicator.showWhile(PlatformUI.getWorkbench().getDisplay(),
					new Runnable() {
						public void run() {
							// GWN
							startEngine(shell);
						}
					});

			if (shell != null) {
				shell.dispose();
			}
		}

		/*
		 * GWN܂B
		 * 
		 * @param shell Shell
		 */
		private void startEngine(Shell shell) {
			EngineStatus.getInstance().setEngine(true);

			try {
				ManageEngineThread engineThread = new ManageEngineThread();
				engineThread.startThread();
			} catch (DatabaseConnectionException e1) {
				logger.warning("Abort Engine start " + e1.getMessage());
				MessageDialog.openError(shell, "Abort Engine start",
						"Abort Engine start by DatabaseConnectionException "
								+ e1.getMessage());
				e1.printStackTrace();
			} catch (SQLException e1) {
				MessageDialog
						.openError(shell, "Abort Engine start",
								"Abort Engine start by SQLException "
										+ e1.getMessage());
				e1.printStackTrace();
			}

			QueueForPing.getInstance().setPause(false);
			QueueForDefaultSnmpMib.getInstance().setPause(false);
			QueueForStatisticsMib.getInstance().setPause(false);
			QueueForHTTP.getInstance().setPause(false);
			QueueForSmtp.getInstance().setPause(false);
			QueueForPop3.getInstance().setPause(false);
			QueueForDatabseWatch.getInstance().setPause(false);

			// TrapMThread
			TrapReceiveThread trapthread;

			try {
				TrapListenerImpl listener = TrapListenerImpl.getInstance();
				trapthread = TrapReceiveThread.getInstance();

				// TrapMXi[iTrapM̎s\bhjo^
				trapthread.startReceiving();
				trapthread.addTrapListener(listener);

				EngineThreadList.getInstance().setThreadList(
						EngineThreadList.TRAP_RECEIVE_THREAD,
						trapthread.getTrapReceiveThread());

				if (!TrapReceiveThread.getInstance().checkThread()) {
					MessageDialog.openError(shell, "Abort start Trap manager",
							"Abort start Trap manager.");
				}
			} catch (Exception e) {
				logger.warning("Abort Trap start. : " + e.getMessage());
				MessageDialog.openError(shell, "Trap thread error",
						"Abort start Trap manager. : " + e.getMessage());
				e.printStackTrace();
			} finally {
				if (NetJFWatcherApplication.getGenericResourceView() != null
						&& NetJFWatcherApplication.getGenericResourceView()
								.getViewSite().getPage().isEditorAreaVisible()) {
					NetJFWatcherApplication.getGenericResourceView()
							.refreshView(true);
				}
			}
		}

		/*
		 * f[^x[XANZXN܂B
		 * 
		 * @param shell Shell
		 */
		private void startDatabase(Shell shell) {
			if (MessageDialog.openQuestion(shell, "Confirm",
					"Initialize Database ?")) {
				/*
				 * f[^x[Xe[uăf[^x[XANZXN
				 */
				DatabaseControl.getInstance().startDatabase(true);
			} else {
				/*
				 * f[^x[Xe[uɃf[^x[XANZXN
				 */
				DatabaseControl.getInstance().startDatabase(false);

				/* f[^x[XǂݍŃm[hĎThreadN */
				DatabaseLoad.getInstance().loadDatabase();
			}
		}
	}

	/**
	 * Engine~ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class ActionStopEngine extends AbstractEngineAction {
		/**
		 * Engine~ANṼACRImageDescriptorԂ܂B
		 * 
		 * @return Engine~ANṼACRImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/engine_stop.gif"));
		}

		/**
		 * Engine~ANVTextԂ܂B
		 * 
		 * @return Engine~ANVText
		 */
		public String getText() {
			return "Engine stop";
		}

		/**
		 * Engine~ANVToolTipTextԂ܂B
		 * 
		 * @return Engine~ANVToolTipText
		 * 
		 */
		public String getToolTipText() {
			return "Engine~܂";
		}

		/**
		 * Engine~܂B
		 * 
		 */
		protected void doTask() {
			/* GWԂ~ɃZbg */
			EngineStatus.getInstance().setEngine(false);

			final Shell shell = new Shell();

			NetJFWatcherApplication.getGenericResourceView()
					.setDisableAllButton();
			BusyIndicator.showWhile(PlatformUI.getWorkbench().getDisplay(),
					new Runnable() {
						public void run() {
							/*
							 * TrapM~
							 */
							EngineThreadList.getInstance().removeThreadList(
									EngineThreadList.TRAP_RECEIVE_THREAD);

							TrapReceiveThread trapthread;
							trapthread = TrapReceiveThread.getInstance();

							trapthread.stopReceiving();

							/*
							 * R}hM~
							 */
							CommnadReceiveServer.getInstance().stopReceiving();
							EngineThreadList.getInstance().removeThreadList(
									EngineThreadList.COMMAND_RECEIVE_THREAD);

							/*
							 * XMLSocket~
							 */
							XMLSocketServer.getInstance()
									.stopXMLSocketServerReceiving();
							EngineThreadList.getInstance().removeThreadList(
									EngineThreadList.XML_SOCKET_THREAD);

							/*
							 * MailMK[h~
							 */
							ThreadMailSendGuard.getInstance().stopReceiving();
							EngineThreadList.getInstance().removeThreadList(
									EngineThreadList.MAIL_GUARD_THREAD);

							/*
							 * f[^x[XێLimit`FbN~
							 */
							ThreadPeriodHoldCheck.getInstance().stopReceiving();
							EngineThreadList
									.getInstance()
									.removeThreadList(
											EngineThreadList.DATABASE_LIMIT_CHECK_THREAD);

							/* Bundlef[^x[X~ */
							stopDatabase();

							/* GWViewXV */
							NetJFWatcherApplication.getGenericResourceView()
									.refreshView(true);

							QueueForPing.getInstance().setPause(true);
							QueueForDefaultSnmpMib.getInstance().setPause(true);
							QueueForStatisticsMib.getInstance().setPause(true);
							QueueForHTTP.getInstance().setPause(true);
							QueueForSmtp.getInstance().setPause(true);
							QueueForPop3.getInstance().setPause(true);
							QueueForDatabseWatch.getInstance().setPause(true);
						}
					});

			if (shell != null) {
				shell.dispose();
			}
		}

		/*
		 * f[^x[X~܂B
		 * 
		 */
		private void stopDatabase() {
			/* VXe\[Xǂݍ */
			ResourceInfo info = SystemResourceConfig.getInstance()
					.getResourceFileParse().getResourceInfo();

			String databaseKind = info.getDatabaseName();

			if (databaseKind.equals(AbstractDataAccessObject.HSQLDB)) {
				try {
					HsqldbControl.getInstance().stopHsqlDB();
				} catch (ClassNotFoundException e3) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e3.getMessage());
					shell.dispose();
				} catch (SQLException e3) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e3.getMessage());
					shell.dispose();
				}
			} else if (databaseKind.equals(AbstractDataAccessObject.DERBY)) {
				try {
					ApacheDerbyNetworkServer.getInstance()
							.stopDerbyNetworkServer();
				} catch (Exception e) {
					e.printStackTrace();

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e.getMessage());
					shell.dispose();
				}
			} else if (databaseKind
					.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
				try {
					ApacheDerbyEmbeddedDerby.getInstance().stopEmbeddedDerby();
				} catch (Exception e) {
					e.printStackTrace();

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e.getMessage());
					shell.dispose();
				}
			}
		}
	}
}
