/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.util.HashMap;
import java.util.logging.Logger;


/**
 * m[hĎThreadԂێNXłB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class EngineThreadList {
    /** R}hMThreadMapɊi[鎞Key */
    public static final String COMMAND_RECEIVE_THREAD = "Command receive";

    /** XML Socketڑ҂ThreadMapɊi[鎞Key */
    public static final String XML_SOCKET_THREAD = "XML Socket";

    /** TrapMThreadMapɊi[鎞Key */
    public static final String TRAP_RECEIVE_THREAD = "Trap receive";

    /** MailMK[hThreadMapɊi[鎞Key */
    public static final String MAIL_GUARD_THREAD = "Mail guard";

    /** f[^x[X`FbNThreadMapɊi[鎞Key */
    public static final String DATABASE_LIMIT_CHECK_THREAD =
        "Database limit check";

    /** ^XNXPW[Thread Description */
    public static final String TASK_SCHEDULE_THREAD = "Task schedule";

    /** PingĎThread Description */
    public static final String PING_EXEC_THREAD = "Ping check exec";

    /** SNMP\ĎThread Description */
    public static final String SNMP_CONFIG_THREAD = "Snmp config";

    /** SNMPvĎThread Description */
    public static final String SNMP_STATISTICS_THREAD = "Snmp statistics";

    /** HTTPĎThread Description */
    public static final String HTTP_THREAD = "Http check exec";

    /** Pop3ĎThread Description */
    public static final String POP3_THREAD = "Pop3 check exec";

    /** SMTPĎThread Description */
    public static final String SMTP_THREAD = "Smtp check exec";

    /** DatabaseĎThread Description */
    public static final String DATABASE_THREAD = "Database check exec";
    
    /** PingĎQueue`FbNThreadi[Key */
    public static final String PING_QUEUE_THREAD = "Ping check queue";

    /** SNMP\ĎQueue`FbNThreadi[Key */
    public static final String SNMP_CONFIG_QUEUE_THREAD = "Snmp config queue";

    /** SNMPvĎQueue`FbNThreadi[Key */
    public static final String SNMP_STATISTICS_QUEUE_THREAD =
        "Snmp statistics queue";

    /** HTTPĎQueue`FbNThreadi[Key */
    public static final String HTTP_QUEUE_THREAD = "Http check exec queue";

    /** Pop3ĎQueue`FbNThreadi[Key */
    public static final String POP3_QUEUE_THREAD = "Pop3 check exec queue";

    /** SMTPĎQueue`FbNThreadi[Key */
    public static final String SMTP_QUEUE_THREAD = "Smtp check exec queue";

    /** DatabaseĎQueue`FbNThreadi[Key */
    public static final String DATABASE_QUEUE_THREAD = "Database check exec queue";

    /* Logging */
    private static Logger logger;

    /* Thread̖OKeyƂThreadCX^Xi[ */
    private HashMap<String, Object> threadMapList = new HashMap<String, Object>();

    /*
     * m[hĎThreadԂێNXCX^X𐶐܂B
     */
    private EngineThreadList() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ĎThreadMapɊi[܂B
     *
     * @param key Thread Key
     * @param obj ĎThraed
     */
    public void setThreadList(String key, Object obj) {
        threadMapList.put(key, obj);
    }

    /**
    * ĎThraedMap폜܂B
    *
    * @param key Thraed Key
    */
    public void removeThreadList(String key) {
        threadMapList.remove(key);
    }

    /**
     * ĎThreadԂ܂B
     *
     * @param key Thread Key
     * @return ĎThread
     */
    public Object getThread(String key) {
        return threadMapList.get(key);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static EngineThreadList getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final EngineThreadList RESOURCE = new EngineThreadList();
    }
}
