/*
 * Created on 2004/12/15
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;


/**
 * GWƃm[hMapN𑗎M郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionNodeMapLink extends AbstractConnectionEngine {
    /** m[hMapN擾R}hR[h */
    public static final String NODE_MAPLINK_GET = "NodeMapLink Get";

    /** m[hMapNXVR}hR[h */
    public static final String NODE_MAPLINK_UPDATE = "NodeMapLink Update";

    /** m[hMapNZbgR}hR[h */
    public static final String NODE_MAPLINK_SET = "NodeMapLink Set";

    /** m[hMapN폜R}hR[h */
    public static final String NODE_MAPLINK_DELETE = "NodeMapLink Delete";

    /**
     * GWƃm[hMapN𑗎M郁\bh
     * NXCX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     *
     */
    public ConnectionNodeMapLink(final String engineAddress) {
        super(engineAddress);
    }

    /**
     * m[hMapN擾܂B
     *
     * @return nodeMapLink m[hMapN
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public NodeMapLinkInformation getNodeMapInformation()
        throws EngineConnectException, IOException {
        NodeMapLinkInformation nodeMapLink = new NodeMapLinkInformation();
        nodeMapLink.setSubCommand(NODE_MAPLINK_GET);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setNodeMapLinkInfo(nodeMapLink);
        commnadInfo.setCode(
            CommandMappingTableResource.NODE_MAPLINK_COMMAND_ID);

        nodeMapLink =
            (NodeMapLinkInformation) this.communicationToEngine(commnadInfo);

        return nodeMapLink;
    }

    /**
     * m[hMapNXV܂B
     *
     * @param nodeMapLink m[hMapN
     * @return resultNodeMapLink m[hMapN
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public NodeMapLinkInformation updateNodeMapInformation(
        final NodeMapLinkInformation nodeMapLink)
        throws EngineConnectException, IOException {
        nodeMapLink.setSubCommand(NODE_MAPLINK_UPDATE);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setNodeMapLinkInfo(nodeMapLink);
        commnadInfo.setCode(
            CommandMappingTableResource.NODE_MAPLINK_COMMAND_ID);

        NodeMapLinkInformation resultNodeMapLink =
            (NodeMapLinkInformation) this.communicationToEngine(commnadInfo);

        return resultNodeMapLink;
    }

    /**
     * m[hMapNXV܂B
     *
     * @param nodeMapLink m[hMapN
     * @return resultNodeMapLink m[hMapN
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public NodeMapLinkInformation setNodeMapInformation(
        final NodeMapLinkInformation nodeMapLink)
        throws EngineConnectException, IOException {
        nodeMapLink.setSubCommand(NODE_MAPLINK_SET);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setNodeMapLinkInfo(nodeMapLink);
        commnadInfo.setCode(
            CommandMappingTableResource.NODE_MAPLINK_COMMAND_ID);

        NodeMapLinkInformation resultNodeMapLink =
            (NodeMapLinkInformation) this.communicationToEngine(commnadInfo);

        return resultNodeMapLink;
    }
}
