/*
 * Created on 2004/12/15
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.socket.info.MibInfo;


/**
 * GWSNMPvMIB̐ݒ𑗎M郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionStatisticsMibSet extends AbstractConnectionEngine {
    /* MO */
    private static Logger logger;

    /**
     * GWSNMPvMIB̐ݒ𑗎M郁\bh
     * NXCX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionStatisticsMibSet(final String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMPvMIBݒ肵܂B
     *
     * @param nodeIPAddress m[hIPAhX
     * @param mibInfo MIB
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void setStatisticsMibSet(
        final String nodeIPAddress, final MibInfo mibInfo)
        throws EngineConnectException, IOException {
        logger.info(
            "Node Address=" + nodeIPAddress + " OID="
            + mibInfo.getRequestMibOid());

        CommandInfo commnadInfo = new CommandInfo();

        commnadInfo.setCode(
            CommandMappingTableResource.STATISTICS_MIB_SET_COMMAND_ID);
        commnadInfo.setIpaddress(nodeIPAddress);

        commnadInfo.setMibInfo(mibInfo);

        this.communicationToEngine(commnadInfo);
    }

    /**
     * SNMPvMIBݒҏW܂B
     *
     * @param nodeIPAddress m[hIPAhX
     * @param mibInfo MIB
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void editStatisticsMibSet(
        final String nodeIPAddress, final MibInfo mibInfo)
        throws EngineConnectException, IOException {
        logger.info(
            "Node Address=" + nodeIPAddress + " OID="
            + mibInfo.getRequestMibOid());

        CommandInfo commnadInfo = new CommandInfo();

        commnadInfo.setCode(
            CommandMappingTableResource.STATISTICS_MIB_EDIT_COMMAND_ID);
        commnadInfo.setIpaddress(nodeIPAddress);

        commnadInfo.setMibInfo(mibInfo);

        this.communicationToEngine(commnadInfo);
    }

    /**
     * SNMPvMIBݒ폜܂B
     *
     * @param nodeIPAddress m[hIPAhX
     * @param mibInfo MIB
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void deleteStatisticsMibSet(
        final String nodeIPAddress, final MibInfo mibInfo)
        throws EngineConnectException, IOException {
        logger.info(
            "Node Address=" + nodeIPAddress + " OID="
            + mibInfo.getRequestMibOid());

        CommandInfo commandInfo = new CommandInfo();

        commandInfo.setCode(
            CommandMappingTableResource.STATISTICS_MIB_DELETE_COMMAND_ID);
        commandInfo.setIpaddress(nodeIPAddress);

        commandInfo.setMibInfo(mibInfo);

        this.communicationToEngine(commandInfo);
    }
}
