/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.bit.SnmpBitString;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter64;
import netjfwatcher.snmp.snmpobject.integer.SnmpGauge32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.integer.SnmpUInteger32;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpNSAPAddress;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaque;



/**
 * SNMP SequenceIuWFNg\NXłB
 * SEQUENCE^O͂AꂼTagASN.1 BER TLVCX^XƂăXg
 * ɕێƂƂɁAXg𑀍삷郁\bh܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpSequence extends AbstractSnmpObject {
    /** SNMP SequencẽRecێ郊Xg */
    protected List sequenceList;

    /** Contents(SNMPIuWFNg)ێ郊Xg */
    protected List sequenceContentsList =
        Collections.synchronizedList(new ArrayList());

    /**
     * SNMP SequenceIuWFNg𐶐܂B
     *
     */
    public SnmpSequence() {
        sequenceList = Collections.synchronizedList(new ArrayList());
        tag = SnmpBERCodec.SNMPSEQUENCE_TAG;
        tagDescription = SnmpBERCodec.SNMPSEQUENCE;
    }

    /**
     * SNMP SequenceIuWFNgwContentsXgf[^琶܂B
     *
     * @param contentList RecXg
     * @throws SnmpBadValueException Zbg郊Xgf[^ُȏꍇ
     */
    public SnmpSequence(List contentList) throws SnmpBadValueException {
        Iterator e = contentList.iterator();

        while (e.hasNext()) {
            if (!(e.next() instanceof AbstractSnmpObject)) {
                throw new SnmpBadValueException(
                    "Non-SNMPObject supplied to SNMPSequence.");
            }
        }

        sequenceList = contentList;
        tag = SnmpBERCodec.SNMPSEQUENCE_TAG;
        tagDescription = SnmpBERCodec.SNMPSEQUENCE;
    }

    /**
     * ASN.1 BERGR[fBOoCgzf[^͂TLVNXCX^X
     * 𐶐ContentsXgɕێ܂B
     *
     * @param enc BERGR[fBOoCgzf[^
     * @throws SnmpBadValueException BERGR[fBOoCgzf[^
     * ُȏꍇ
     */
    public SnmpSequence(byte[] enc) throws SnmpBadValueException {
        //
        this.extractFromBEREncoding(enc);
        tag = SnmpBERCodec.SNMPSEQUENCE_TAG;
        tagDescription = SnmpBERCodec.SNMPSEQUENCE;
    }

    /**
     * ContentsXgԂ܂B
     *
     * @return sequenceList ContentsXg
     */
    public Object getValue() {
        return sequenceList;
    }

    /**
     * w肳ꂽASN.1 BER SNMP TLVCX^X̒ltB[h͂ASN.1 BER
     * ɂVTLVNXCX^XƂContentsXgɕێ܂B
     *
     * @param nextTLV ASN.1 BER SNMP TLV
     * @throws SnmpBadValueException w肳ꂽASN.1 BER SNMP TLVCX^X
     * ltB[hُȏꍇ
     */
    public void setTLV(SNMPTLV nextTLV) throws SnmpBadValueException {
        this.extractFromBEREncoding(nextTLV.getValue());
    }

    /**
     * w肳ꂽObjectVContentsێXgƂăZbg܂B
     *
     * @param newSequence ContentsێXg
     * @throws SnmpBadValueException ZbgObjectُȏꍇ
     */
    public void setValue(Object newSequence) throws SnmpBadValueException {
        if (newSequence instanceof List) {
            // check that all objects in vector are SNMPObjects
            Iterator e = ((List) newSequence).iterator();

            while (e.hasNext()) {
                if (!(e.next() instanceof AbstractSnmpObject)) {
                    throw new SnmpBadValueException(
                        "Non-SNMPObject supplied to SNMPSequence.");
                }
            }

            this.sequenceList = (List) newSequence;
        } else {
            throw new SnmpBadValueException(
                " Sequence: bad object supplied to set value ");
        }
    }

    /**
     * Contents(SNMPIuWFNg)ێ郊XgTCYԂ܂B
     *
     * @return ContentsTCY
     */
    public int size() {
        return sequenceList.size();
    }

    /**
     * Xg̍ŌSNMPIuWFNgǉ܂B
     *
     * @param newObject SNMPIuWFNg
     */
    public void addSNMPObject(AbstractSnmpObject newObject) {
        sequenceList.add(sequenceList.size(), newObject);
    }

    /**
     * w肳ꂽXgCfbNX̃IuWFNgւ܂i㏑jB
     *
     * @param newObject SNMPIuWFNg
     * @param index Contentsʒu
     * @throws SnmpBadValueException
     */
    public void addSNMPObject(AbstractSnmpObject newObject, int index) {
        sequenceList.remove(index);
        sequenceList.add(index, newObject);
    }

    /**
     * Contents(SNMPIuWFNg)ێ郊XgNA܂B
     *
     */
    public void clearSNMPObjectList() {
        sequenceList.clear();
    }

    /**
     * wContentsʒuSNMPIuWFNgԂ܂B
    *
    * @param index Contentsʒu
    * @return SNMPIuWFNg
    */
    public AbstractSnmpObject getSNMPObjectAt(int index) {
        return (AbstractSnmpObject) (sequenceList.get(index));
    }

    /**
     * ێĂContentsXgBERGR[fBOɂăoCgz
     * ϊĕԂ܂B
     *
    * @return oCgzf[^
    */
    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outWork = null;

        try {
            // recursively write contents of List
            byte[] data = this.encodeContentsList();

            // calculate encoding for length of data
            byte[] len = this.encodeLength(data.length);

            // encode T,L,V info
            outBytes.write(tag);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);

            outWork = outBytes.toByteArray();
        } finally {
            try {
                outBytes.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return outWork;
    }

    /**
     * XgɕێĂContentsBERGR[fBOɂăoCgzɕϊ
     * Ԃ܂B
     *
     * @return oCgz
     */
    private byte[] encodeContentsList() {
        ByteArrayOutputStream outStreamBytes = new ByteArrayOutputStream();
        byte[] outBytes = null;

        try {
            int numElements = sequenceList.size();

            for (int i = 0; i < numElements; ++i) {
                /* ContentsBERGR[fBOɂăoCgzɕϊ */
                byte[] nextBytes =
                    ((AbstractSnmpObject) (sequenceList.get(i))).getBEREncoding();
                outStreamBytes.write(nextBytes, 0, nextBytes.length);
            }

            outBytes = outStreamBytes.toByteArray();
        } finally {
            try {
                outStreamBytes.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return outBytes;
    }

    /**
     * oCgzf[^͂ASN.1 BERɂTLVNXCX^XƂ
     * ContentsXgɕێ܂B
     * TLVNXCX^X́ATag, Length, Value(oCgz)ێ
     * NXłB
     *
     * @param enc ͂oCgzf[^
     * @throws SnmpBadValueException f[^ZbgɎsꍇ
     */
    protected void extractFromBEREncoding(byte[] enc)
        throws SnmpBadValueException {
        List newContentsList = Collections.synchronizedList(new ArrayList());

        int totalLength = enc.length;
        int position = 0;
        sequenceContentsList.clear();

        while (position < totalLength) {
            /* oCgf[^wʒuATLVNXCX^X */
            SNMPTLV nextTLV = this.extractNextTLV(enc, position);

            if (nextTLV != null) {
                sequenceContentsList.add(this.extractNextTLV(enc, position));

                /* VectorSNMPIuWFNgi[ */
                newContentsList.add(newContentsList.size(), this.extractEncoding(nextTLV));
                position += nextTLV.getTotalLength();
            } else {
                position++;
            }
        }

        sequenceList = newContentsList;
    }

    /**
     * Contents(SNMPIuWFNg)ێ郊XgԂ܂B
     *
     * @return Contents(SNMPIuWFNg)ێ郊Xg
     */
    public List getSequenceContentsList() {
        return sequenceContentsList;
    }

    /**
     * ASN.1 BER SNMPTLVNXCX^XASNMPTLVTAGԍɑΉ
     * SNMPIuWFNgTLVValueɐAԂ܂B
     *
     * @param theTLV ASN.1 BER SNMPTLV
     * @return SNMPObject SNMPIuWFNg
     * @throws SnmpBadValueException SNMPIuWFNgɎsꍇ
     */
    public AbstractSnmpObject extractEncoding(SNMPTLV theTLV)
        throws SnmpBadValueException {
        /*
         * SNMPTLVIuWFNgtagtagɑΉIuWFNg𐶐
         */

        // System.out.println("Create SNMPObject tag : " + theTLV.tag);
        switch (theTLV.getTag()) {
        case SnmpBERCodec.SNMPINTEGER_TAG:
            return new SnmpInteger(theTLV.getValue());

        case SnmpBERCodec.SNMPSEQUENCE_TAG:
            return new SnmpSequence(theTLV.getValue());

        case SnmpBERCodec.SNMPOBJECTIDENTIFIER_TAG:
            return new SnmpObjectIdentifier(theTLV.getValue());

        case SnmpBERCodec.SNMPOCTETSTRING_TAG:
            return new SnmpOctetString(theTLV.getValue());

        case SnmpBERCodec.SNMPIPADDRESS_TAG:
            return new SnmpIPAddress(theTLV.getValue());

        case SnmpBERCodec.SNMPCOUNTER32_TAG:
            return new SnmpCounter32(theTLV.getValue());

        case SnmpBERCodec.SNMPGAUGE32_TAG:
            return new SnmpGauge32(theTLV.getValue());

        case SnmpBERCodec.SNMPTIMETICKS_TAG:
            return new SnmpTimeTicks(theTLV.getValue());

        case SnmpBERCodec.SNMPNSAPADDRESS_TAG:
            return new SnmpNSAPAddress(theTLV.getValue());

        case SnmpBERCodec.SNMPCOUNTER64_TAG:
            return new SnmpCounter64(theTLV.getValue());

        case SnmpBERCodec.SNMPUINTEGER32_TAG:
            return new SnmpUInteger32(theTLV.getValue());

        case SnmpBERCodec.SNMPGETREQUEST:
        case SnmpBERCodec.SNMPGETNEXTREQUEST:
        case SnmpBERCodec.SNMPGETRESPONSE:
        case SnmpBERCodec.SNMPSETREQUEST:
            return new SnmpPDU(theTLV.getValue(), theTLV.getTag());

        case SnmpBERCodec.SNMPTRAP:
            return new SnmpTrapPDU(theTLV.getValue());

        case SnmpBERCodec.SNMPTRAP2:
            return new SnmpTrap2PDU(theTLV.getValue());

        case SnmpBERCodec.SNMPOPAQUE_TAG:
            System.out.println("SNMPOPAQUE_TAG : " + theTLV.getTag());

            return new SnmpOpaque(theTLV.getValue());

        case SnmpBERCodec.SNMPBITSTRING_TAG:
            System.out.println("SNMPBITSTRING_TAG : " + theTLV.getTag());

            return new SnmpBitString(theTLV.getValue());

        case SnmpBERCodec.SNMPNULL_TAG:
        case SnmpBERCodec.SNMP_MSG_REPORT:

            // return new SNMPReportPDU(theTLV.value);
            return new SnmpPDU(theTLV.getValue(), theTLV.getTag());

        default:
            System.out.println("Unrecognized tag : " + theTLV.getTag());

            //return new SNMPOctetString(theTLV.value);
            return new SnmpUnknownObject(theTLV.getValue());

        }
    }

    /**
     * Contents(SNMPIuWFNg)ێ郊Xg̒l𕶎ɕϊ
     * Ԃ܂B
     *
     * @return l𕶎ɕϊ
    */
    public String toString() {
        String valueString = "(";

        for (int i = 0; i < sequenceList.size(); ++i) {
            valueString += (" "
            + ((AbstractSnmpObject) sequenceList.get(i)).toString() + " ");
        }

        valueString += ")";

        return valueString;
    }
}
