/*
 * Created on 2006/10/12
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import netjfwatcher.engine.resourceconfig.ClientEngineInfo;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.PlatformUI;

/**
 * EngineXgTreeIXi[NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EngineListListener implements ISelectionChangedListener {

	/* TreeViewer */
	private TreeViewer engineListTreeViewer;

	public EngineListListener(TreeViewer engineListTreeViewer) {
		this.engineListTreeViewer = engineListTreeViewer;
	}

	public void selectionChanged(SelectionChangedEvent event) {

		StructuredSelection ss = (StructuredSelection) event.getSelection();

		final IEngineNode entry;
		final EngineInfo engineInfo;
		if (ss.getFirstElement() instanceof IEngineNode) {
			entry = (IEngineNode) ss.getFirstElement();
			engineInfo = entry.getEngineInfo();

		} else {
			engineInfo = null;
		}

		/*
		 * System.out.println("entry.getEngineAddress() " +
		 * engineInfo.getEngineAddress());
		 * System.out.println("entry.getEnginePort() " +
		 * engineInfo.getEnginePort());
		 */

		BusyIndicator.showWhile(PlatformUI.getWorkbench().getDisplay(),
				new Runnable() {
					public void run() {
						if (engineInfo != null) {
							ClientEngineInfo.getClientEngineInfoInstance()
									.setEngineAddress(
											engineInfo.getEngineAddress());
							engineListTreeViewer.refresh();
						}

					}
				});
	}
}
