/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.view;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.webbrowser.preferences.HttpAccessPreferencePage;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;


/**
 * uEU\ł̃Xi[NXłB
 * ̃Xi[ɂāAuEUǂݍݏ󋵂vOXj^[
 * \܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class BrowserLocationChangeListener implements LocationListener {
    /* MO */
    private static Logger logger;

    /* Progress monitor̖O܂Description */
    private static final int TOTAL_WORK = 100;

    /* vOXj^[ɕ\WebANZXvtFX */
    private PreferenceStore webAccessPref;

    /* vOXj^[ */
    private IProgressMonitor monitor;

    /* vOXj^[\URL */
    private String urlTitle;

    /**
     * uEU\ɂ郊Xi[CX^X𐶐܂B
     * uEUǂݍݏ󋵂vOXj^[ɕ\邽
     * ̃Xi[łB
     *
     * @param urlTitle vOXj^[ɕ\URL
     */
    public BrowserLocationChangeListener(String urlTitle) {
        logger = Logger.getLogger(this.getClass().getName());
        this.urlTitle = urlTitle;

        /* vOXj^[ɕ\WebANZXvtFX */
        webAccessPref =
            new PreferenceStore(HttpAccessPreferencePage.WEB_PREFERENCE);

        /*
         * uEUǂݍݏ󋵕\Xe[^XCj^[擾A
         * Zbg
         */
        IWorkbench workbench = PlatformUI.getWorkbench();
        WorkbenchWindow workbenchWindow =
            (WorkbenchWindow) workbench.getActiveWorkbenchWindow();
        IActionBars bars = workbenchWindow.getActionBars();
        IStatusLineManager lineManager = bars.getStatusLineManager();
        monitor = lineManager.getProgressMonitor();
    }

    /**
     * uEUǂݍ݊Jn̏s܂B
     * WebANZXvtFX[hAWebANZX󋵂
     * vOXj^[ɕ\܂B
     *
     * @param event LocationEvent
     */
    public void changing(LocationEvent event) {
        logger.info("Reading ... " + event.location);

        /* WebANZXpvtFX[h */
        try {
            webAccessPref.load();
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
        }

        /* vOXj^[ɕ\WebANZXZbg */
        if (webAccessPref != null) {
            monitor.beginTask(
                "Reading ... " + urlTitle + " ( Host="
                + webAccessPref.getString(
                    HttpAccessPreferencePage.HTTP_HOST_KEY) + " Port="
                + webAccessPref.getString(
                    HttpAccessPreferencePage.HTTP_PORT_KEY) + " Context="
                + webAccessPref.getString(
                    HttpAccessPreferencePage.HTTP_CONTEXT_KEY) + " )",
                TOTAL_WORK);
        } else {
            /* vtFX[hȂ̎̃vOXj^[ */
            monitor.beginTask(
                "Reading ... " + urlTitle + "( " + event.location + " )",
                TOTAL_WORK);
        }
    }

    /**
     * uEUǂݍݏȈs܂B
     *
     * @param event LocationEvent
     *
     */
    public void changed(LocationEvent event) {
        monitor.done();
        logger.info("browsing complete : " + event.location);
    }
}
