/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GlobalizationPreferences
implements Freezable {
    public static final int CURRENCY = 0;
    public static final int NUMBER = 1;
    public static final int INTEGER = 2;
    public static final int SCIENTIFIC = 3;
    public static final int PERCENT = 4;
    public static final int NUMBER_LIMIT = 5;
    public static final int NONE = 4;
    public static final int LOCALEID = 0;
    public static final int LANGUAGEID = 1;
    public static final int SCRIPTID = 2;
    public static final int TERRITORYID = 3;
    public static final int VARIANTID = 4;
    public static final int KEYWORDID = 5;
    public static final int KEYWORD_VALUEID = 6;
    public static final int CURRENCYID = 7;
    public static final int CURRENCY_SYMBOLID = 8;
    public static final int TIMEZONEID = 9;
    public static final int DISPLAYID_LIMIT = 10;
    private Object locales;
    private String territory;
    private Currency currency;
    private TimeZone timezone;
    private Calendar calendar;
    private Collator collator;
    private ULocale dateLocale;
    private Object[][] dateFormats;
    private ULocale numberLocale;
    private Object[] numberFormats;
    private static final Map language_territory_hack_map = new HashMap();
    private static final String[][] language_territory_hack = new String[][]{{"af", "ZA"}, {"am", "ET"}, {"ar", "SA"}, {"as", "IN"}, {"ay", "PE"}, {"az", "AZ"}, {"bal", "PK"}, {"be", "BY"}, {"bg", "BG"}, {"bn", "IN"}, {"bs", "BA"}, {"ca", "ES"}, {"ch", "MP"}, {"cpe", "SL"}, {"cs", "CZ"}, {"cy", "GB"}, {"da", "DK"}, {"de", "DE"}, {"dv", "MV"}, {"dz", "BT"}, {"el", "GR"}, {"en", "US"}, {"es", "ES"}, {"et", "EE"}, {"eu", "ES"}, {"fa", "IR"}, {"fi", "FI"}, {"fil", "PH"}, {"fj", "FJ"}, {"fo", "FO"}, {"fr", "FR"}, {"ga", "IE"}, {"gd", "GB"}, {"gl", "ES"}, {"gn", "PY"}, {"gu", "IN"}, {"gv", "GB"}, {"ha", "NG"}, {"he", "IL"}, {"hi", "IN"}, {"ho", "PG"}, {"hr", "HR"}, {"ht", "HT"}, {"hu", "HU"}, {"hy", "AM"}, {"id", "ID"}, {"is", "IS"}, {"it", "IT"}, {"ja", "JP"}, {"ka", "GE"}, {"kk", "KZ"}, {"kl", "GL"}, {"km", "KH"}, {"kn", "IN"}, {"ko", "KR"}, {"kok", "IN"}, {"ks", "IN"}, {"ku", "TR"}, {"ky", "KG"}, {"la", "VA"}, {"lb", "LU"}, {"ln", "CG"}, {"lo", "LA"}, {"lt", "LT"}, {"lv", "LV"}, {"mai", "IN"}, {"men", "GN"}, {"mg", "MG"}, {"mh", "MH"}, {"mk", "MK"}, {"ml", "IN"}, {"mn", "MN"}, {"mni", "IN"}, {"mo", "MD"}, {"mr", "IN"}, {"ms", "MY"}, {"mt", "MT"}, {"my", "MM"}, {"na", "NR"}, {"nb", "NO"}, {"nd", "ZA"}, {"ne", "NP"}, {"niu", "NU"}, {"nl", "NL"}, {"nn", "NO"}, {"no", "NO"}, {"nr", "ZA"}, {"nso", "ZA"}, {"ny", "MW"}, {"om", "KE"}, {"or", "IN"}, {"pa", "IN"}, {"pau", "PW"}, {"pl", "PL"}, {"ps", "PK"}, {"pt", "BR"}, {"qu", "PE"}, {"rn", "BI"}, {"ro", "RO"}, {"ru", "RU"}, {"rw", "RW"}, {"sd", "IN"}, {"sg", "CF"}, {"si", "LK"}, {"sk", "SK"}, {"sl", "SI"}, {"sm", "WS"}, {"so", "DJ"}, {"sq", "CS"}, {"sr", "CS"}, {"ss", "ZA"}, {"st", "ZA"}, {"sv", "SE"}, {"sw", "KE"}, {"ta", "IN"}, {"te", "IN"}, {"tem", "SL"}, {"tet", "TL"}, {"th", "TH"}, {"ti", "ET"}, {"tg", "TJ"}, {"tk", "TM"}, {"tkl", "TK"}, {"tvl", "TV"}, {"tl", "PH"}, {"tn", "ZA"}, {"to", "TO"}, {"tpi", "PG"}, {"tr", "TR"}, {"ts", "ZA"}, {"uk", "UA"}, {"ur", "IN"}, {"uz", "UZ"}, {"ve", "ZA"}, {"vi", "VN"}, {"wo", "SN"}, {"xh", "ZA"}, {"zh", "CN"}, {"zh_Hant", "TW"}, {"zu", "ZA"}, {"aa", "ET"}, {"byn", "ER"}, {"eo", "DE"}, {"gez", "ET"}, {"haw", "US"}, {"iu", "CA"}, {"kw", "GB"}, {"sa", "IN"}, {"sh", "HR"}, {"sid", "ET"}, {"syr", "SY"}, {"tig", "ER"}, {"tt", "RU"}, {"wal", "ET"}};
    static final Map territory_tzid_hack_map;
    static final String[][] territory_tzid_hack;
    private boolean frozen;

    static {
        int i = 0;
        while (i < language_territory_hack.length) {
            language_territory_hack_map.put(language_territory_hack[i][0], language_territory_hack[i][1]);
            ++i;
        }
        territory_tzid_hack_map = new HashMap();
        territory_tzid_hack = new String[][]{{"AQ", "Antarctica/McMurdo"}, {"AR", "America/Buenos_Aires"}, {"AU", "Australia/Sydney"}, {"BR", "America/Sao_Paulo"}, {"CA", "America/Toronto"}, {"CD", "Africa/Kinshasa"}, {"CL", "America/Santiago"}, {"CN", "Asia/Shanghai"}, {"EC", "America/Guayaquil"}, {"ES", "Europe/Madrid"}, {"GB", "Europe/London"}, {"GL", "America/Godthab"}, {"ID", "Asia/Jakarta"}, {"ML", "Africa/Bamako"}, {"MX", "America/Mexico_City"}, {"MY", "Asia/Kuala_Lumpur"}, {"NZ", "Pacific/Auckland"}, {"PT", "Europe/Lisbon"}, {"RU", "Europe/Moscow"}, {"UA", "Europe/Kiev"}, {"US", "America/New_York"}, {"UZ", "Asia/Tashkent"}, {"PF", "Pacific/Tahiti"}, {"FM", "Pacific/Kosrae"}, {"KI", "Pacific/Tarawa"}, {"KZ", "Asia/Almaty"}, {"MH", "Pacific/Majuro"}, {"MN", "Asia/Ulaanbaatar"}, {"SJ", "Arctic/Longyearbyen"}, {"UM", "Pacific/Midway"}};
        i = 0;
        while (i < territory_tzid_hack.length) {
            territory_tzid_hack_map.put(territory_tzid_hack[i][0], territory_tzid_hack[i][1]);
            ++i;
        }
    }

    public GlobalizationPreferences() {
        this.reset();
    }

    public GlobalizationPreferences setLocales(List locales) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        this.locales = locales.size() == 0 ? locales.get(0) : new ArrayList(locales);
        return this;
    }

    public List getLocales() {
        List<Object> result = new ArrayList();
        if (this.locales == null) {
            result = this.guessLocales();
        } else if (this.locales instanceof ULocale) {
            result.add(this.locales);
        } else {
            result.addAll((List)this.locales);
        }
        return result;
    }

    public ULocale getLocale(int index) {
        if (this.locales == null) {
            return (ULocale)this.guessLocales().get(index);
        }
        if (this.locales instanceof ULocale) {
            if (index != 0) {
                throw new IllegalArgumentException("Out of bounds: " + index);
            }
            return (ULocale)this.locales;
        }
        return (ULocale)((List)this.locales).get(index);
    }

    public GlobalizationPreferences setLocales(ULocale[] uLocales) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        return this.setLocales(Arrays.asList(uLocales));
    }

    public GlobalizationPreferences setLocale(ULocale uLocale) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        return this.setLocales(new ULocale[]{uLocale});
    }

    public GlobalizationPreferences setTerritory(String territory) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        this.territory = territory;
        return this;
    }

    public String getTerritory() {
        if (this.territory == null) {
            return this.guessTerritory();
        }
        return this.territory;
    }

    public GlobalizationPreferences setCurrency(Currency currency) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        this.currency = currency;
        return this;
    }

    public Currency getCurrency() {
        if (this.currency == null) {
            return this.guessCurrency();
        }
        return this.currency;
    }

    public GlobalizationPreferences setCalendar(Calendar calendar) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        this.calendar = calendar;
        return this;
    }

    public Calendar getCalendar() {
        if (this.calendar == null) {
            return this.guessCalendar();
        }
        Calendar temp = (Calendar)this.calendar.clone();
        temp.setTimeZone(this.getTimeZone());
        return temp;
    }

    public GlobalizationPreferences setTimeZone(TimeZone timezone) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        this.timezone = timezone;
        return this;
    }

    public TimeZone getTimeZone() {
        if (this.timezone == null) {
            return this.guessTimeZone();
        }
        return (TimeZone)this.timezone.clone();
    }

    public Collator getCollator() {
        if (this.collator == null) {
            return this.guessCollator();
        }
        try {
            return (Collator)this.collator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error in cloning collator");
        }
    }

    public GlobalizationPreferences setCollator(Collator collator) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        this.collator = collator;
        return this;
    }

    public GlobalizationPreferences setDateLocale(ULocale dateLocale) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        this.dateLocale = dateLocale;
        return this;
    }

    public ULocale getDateLocale() {
        return this.dateLocale != null ? this.dateLocale : this.getLocale(0);
    }

    public GlobalizationPreferences setNumberLocale(ULocale numberLocale) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        this.numberLocale = numberLocale;
        return this;
    }

    public ULocale getNumberLocale() {
        return this.numberLocale != null ? this.numberLocale : this.getLocale(0);
    }

    public String getDisplayName(String id, int type) {
        String result = id;
        Iterator it = this.getLocales().iterator();
        block11: while (it.hasNext()) {
            ULocale locale = (ULocale)it.next();
            switch (type) {
                case 0: {
                    result = ULocale.getDisplayName(id, locale);
                    break;
                }
                case 1: {
                    result = ULocale.getDisplayLanguage(id, locale);
                    break;
                }
                case 2: {
                    result = ULocale.getDisplayScript("und-" + id, locale);
                    break;
                }
                case 3: {
                    result = ULocale.getDisplayCountry("und-" + id, locale);
                    break;
                }
                case 4: {
                    result = ULocale.getDisplayVariant("und-QQ-" + id, locale);
                    break;
                }
                case 5: {
                    result = ULocale.getDisplayKeyword(id, locale);
                    break;
                }
                case 6: {
                    String[] parts = new String[2];
                    Utility.split(id, '=', parts);
                    result = ULocale.getDisplayKeywordValue("und@" + id, parts[0], locale);
                    if (!result.equals(parts[1])) break;
                    continue block11;
                }
                case 7: 
                case 8: {
                    Currency temp = new Currency(id);
                    result = temp.getName(locale, type == 7 ? 1 : 0, new boolean[1]);
                    break;
                }
                case 9: {
                    SimpleDateFormat dtf = new SimpleDateFormat("vvvv", locale);
                    dtf.setTimeZone(TimeZone.getTimeZone(id));
                    result = dtf.format(new Date());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + type);
                }
            }
            if (id.equals(result)) continue;
            return result;
        }
        return result;
    }

    public GlobalizationPreferences setDateFormat(int dateStyle, int timeStyle, DateFormat format) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        if (this.dateFormats == null) {
            this.dateFormats = new Object[5][5];
        }
        this.dateFormats[dateStyle][timeStyle] = (DateFormat)format.clone();
        return this;
    }

    public GlobalizationPreferences setDateFormat(int dateStyle, int timeStyle, String formatPattern) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        if (this.dateFormats == null) {
            this.dateFormats = new Object[5][5];
        }
        new SimpleDateFormat(formatPattern, this.getDateLocale());
        this.dateFormats[dateStyle][timeStyle] = formatPattern;
        return this;
    }

    public DateFormat getDateFormat(int dateStyle, int timeStyle) {
        try {
            DateFormat result = null;
            if (this.dateFormats != null) {
                Object temp = this.dateFormats[dateStyle][timeStyle];
                result = temp instanceof DateFormat ? (DateFormat)temp : new SimpleDateFormat((String)temp, this.getDateLocale());
            }
            if (result != null) {
                result = (DateFormat)result.clone();
                result.setCalendar(this.getCalendar());
            } else {
                result = timeStyle == 4 ? DateFormat.getDateInstance(this.getCalendar(), dateStyle, this.getDateLocale()) : (dateStyle == 4 ? DateFormat.getTimeInstance(this.getCalendar(), timeStyle, this.getDateLocale()) : DateFormat.getDateTimeInstance(this.getCalendar(), dateStyle, timeStyle, this.getDateLocale()));
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            IllegalArgumentException ex = new IllegalArgumentException("Cannot create DateFormat");
            throw ex;
        }
    }

    public NumberFormat getNumberFormat(int style) {
        try {
            NumberFormat result = null;
            if (this.numberFormats != null) {
                Object temp = this.numberFormats[style];
                result = temp instanceof NumberFormat ? (NumberFormat)temp : new DecimalFormat((String)temp, new DecimalFormatSymbols(this.getDateLocale()));
            }
            if (result != null) {
                result = (NumberFormat)result.clone();
                if (style == 0) {
                    result.setCurrency(this.getCurrency());
                }
                return result;
            }
            switch (style) {
                case 1: {
                    return NumberFormat.getInstance(this.getNumberLocale());
                }
                case 3: {
                    return NumberFormat.getScientificInstance(this.getNumberLocale());
                }
                case 2: {
                    return NumberFormat.getIntegerInstance(this.getNumberLocale());
                }
                case 4: {
                    return NumberFormat.getPercentInstance(this.getNumberLocale());
                }
                case 0: {
                    result = NumberFormat.getCurrencyInstance(this.getNumberLocale());
                    result.setCurrency(this.getCurrency());
                    return result;
                }
            }
        }
        catch (RuntimeException runtimeException) {}
        throw new IllegalArgumentException();
    }

    public GlobalizationPreferences setNumberFormat(int style, DateFormat format) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        if (this.numberFormats == null) {
            this.numberFormats = new Object[5];
        }
        this.numberFormats[style] = (NumberFormat)format.clone();
        return this;
    }

    public GlobalizationPreferences setNumberFormat(int style, String formatPattern) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        if (this.numberFormats == null) {
            this.numberFormats = new Object[5];
        }
        new DecimalFormat(formatPattern, new DecimalFormatSymbols(this.getDateLocale()));
        this.numberFormats[style] = formatPattern;
        return this;
    }

    public GlobalizationPreferences reset() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify immutable object");
        }
        this.territory = null;
        this.calendar = null;
        this.collator = null;
        this.timezone = null;
        this.currency = null;
        this.dateFormats = null;
        this.numberFormats = null;
        this.dateLocale = null;
        this.numberLocale = null;
        this.locales = null;
        return this;
    }

    protected String guessTerritory() {
        String result;
        Iterator it = this.getLocales().iterator();
        while (it.hasNext()) {
            ULocale locale = (ULocale)it.next();
            result = locale.getCountry();
            if (result.length() == 0) continue;
            return result;
        }
        ULocale firstLocale = this.getLocale(0);
        String language = firstLocale.getLanguage();
        String script = firstLocale.getScript();
        result = null;
        if (script.length() != 0) {
            result = (String)language_territory_hack_map.get(String.valueOf(language) + "_" + script);
        }
        if (result == null) {
            result = (String)language_territory_hack_map.get(language);
        }
        if (result == null) {
            result = "US";
        }
        return result;
    }

    protected Currency guessCurrency() {
        return Currency.getInstance(new ULocale("und-" + this.getTerritory()));
    }

    protected List guessLocales() {
        ArrayList<ULocale> result = new ArrayList<ULocale>(0);
        result.add(ULocale.getDefault());
        return result;
    }

    protected Collator guessCollator() {
        return Collator.getInstance(this.getLocale(0));
    }

    protected TimeZone guessTimeZone() {
        String timezoneString = (String)territory_tzid_hack_map.get(this.getTerritory());
        if (timezoneString == null) {
            String[] attempt = ZoneMeta.getAvailableIDs(this.getTerritory());
            if (attempt.length == 0) {
                timezoneString = "Etc/GMT";
            } else {
                int i = 0;
                while (i < attempt.length) {
                    if (attempt[i].indexOf("/") >= 0) break;
                    ++i;
                }
                if (i > attempt.length) {
                    i = 0;
                }
                timezoneString = attempt[i];
            }
        }
        return TimeZone.getTimeZone(timezoneString);
    }

    protected Calendar guessCalendar() {
        return Calendar.getInstance(new ULocale("und-" + this.getTerritory()));
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public Object freeze() {
        this.frozen = true;
        return this;
    }

    public Object cloneAsThawed() {
        try {
            GlobalizationPreferences result = (GlobalizationPreferences)this.clone();
            result.frozen = false;
            return result;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

