/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.application;

import netjfwatcher.application.NetJFWatcherPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public final class NetJFWatcherPreference {
    public static final NetJFWatcherPreference LOG4J_CONFIGURATION = new NetJFWatcherPreference("log4j.configuration", "log4j.properties");
    public static final NetJFWatcherPreference WORKBENCH_WIDTH = new NetJFWatcherPreference("WorkbenchWidth", "800");
    public static final NetJFWatcherPreference WORKBENCH_HEIGHT = new NetJFWatcherPreference("WorkbenchHeight", "600");
    private final String defaultValue;
    private final String key;

    private NetJFWatcherPreference(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
        NetJFWatcherPreference.mynode().setDefault(key, defaultValue);
    }

    public float getFloat() {
        return NetJFWatcherPreference.mynode().getFloat(this.key);
    }

    public int getInt() {
        return NetJFWatcherPreference.mynode().getInt(this.key);
    }

    public String getString() {
        return NetJFWatcherPreference.mynode().getString(this.key);
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String key() {
        return this.key;
    }

    public void putFloat(float value) {
        NetJFWatcherPreference.mynode().setValue(this.key, value);
    }

    public void putInt(int value) {
        NetJFWatcherPreference.mynode().setValue(this.key, value);
    }

    public void putString(String value) {
        NetJFWatcherPreference.mynode().setValue(this.key, value);
    }

    public String toString() {
        return "{" + this.getClass().getName() + ": key=" + this.key() + ", default=" + this.defaultValue() + "}";
    }

    private static IPreferenceStore mynode() {
        return NetJFWatcherPlugin.getInstance().getPreferenceStore();
    }
}

