/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.alarm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.alarm.AlarmRecoveryIP;

public final class AlarmRecovery {
    private static Map<String, AlarmRecoveryIP> nodeIPAlarmMap = Collections.synchronizedMap(new HashMap());

    private AlarmRecovery() {
    }

    public synchronized void setArarmrecoveryCheck(String ipAddress) {
        nodeIPAlarmMap.put(ipAddress, new AlarmRecoveryIP());
    }

    public synchronized void putAlarmRecoveryInoformation(String ipAddress, AlarmCodeInformation alarmCodeInfo) {
        AlarmRecoveryIP recoveryIpInfo = nodeIPAlarmMap.get(ipAddress);
        if (recoveryIpInfo != null) {
            recoveryIpInfo.putAlarmInfo(alarmCodeInfo.getId(), alarmCodeInfo);
            nodeIPAlarmMap.put(ipAddress, recoveryIpInfo);
        }
    }

    public synchronized boolean isOccurredAlarmId(String ipAddress, String alarmid) {
        AlarmCodeInformation alarmCodeInfo;
        AlarmRecoveryIP recoveryIPAddressInfo = nodeIPAlarmMap.get(ipAddress);
        if (recoveryIPAddressInfo != null && (alarmCodeInfo = recoveryIPAddressInfo.getAlarmInfo(alarmid)) != null) {
            this.delete(ipAddress, alarmid);
            return true;
        }
        return false;
    }

    private synchronized void delete(String ipAddress, String alarmId) {
        AlarmRecoveryIP recoveryIpInfo = nodeIPAlarmMap.get(ipAddress);
        if (recoveryIpInfo != null) {
            recoveryIpInfo.delete(alarmId);
        }
    }

    public static AlarmRecovery getInstance() {
        return SingletonMessage.INSTANCE;
    }

    /* synthetic */ AlarmRecovery(AlarmRecovery alarmRecovery) {
        this();
    }

    private static class SingletonMessage {
        static final AlarmRecovery INSTANCE = new AlarmRecovery(null);

        private SingletonMessage() {
        }
    }
}

