/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.garbagecollection;

import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableGarbageCollection;

public final class GarbageCollectionMemoryJVM
implements Runnable {
    private static Logger logger;
    private static final long DEFAULT_SLEEP_TIME = 5000L;
    private Thread thread;
    private boolean isStopFlag = false;
    private long sleepTime = 5000L;

    private GarbageCollectionMemoryJVM() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized boolean checkThread() {
        boolean isThreadAlive = false;
        if (this.thread != null && this.thread.isAlive()) {
            isThreadAlive = true;
        }
        return isThreadAlive;
    }

    public synchronized void stopThread() {
        logger.info("Thread Stop");
        if (this.thread != null && this.thread.isAlive()) {
            logger.info("Thread interrupt.");
            this.isStopFlag = true;
            this.thread.interrupt();
            this.thread = null;
        } else {
            logger.info("No stop Thread");
        }
    }

    public synchronized void startThread() {
        if (this.thread == null || !this.thread.isAlive()) {
            this.isStopFlag = false;
            this.thread = new Thread(SingletonResource.RESOURCE);
            this.thread.start();
        } else {
            logger.info("Already thread run !!");
        }
    }

    public void run() {
        Runtime rt = Runtime.getRuntime();
        DBTableGarbageCollection garbageCollectionTable = DBTableGarbageCollection.getInstance();
        while (!this.isStopFlag) {
            try {
                String totalMemory = Long.toString(rt.totalMemory());
                String freeMemory = Long.toString(rt.freeMemory());
                try {
                    garbageCollectionTable.put(totalMemory, freeMemory);
                }
                catch (DatabaseConnectionException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                Thread.sleep(this.getSleepTime());
            }
            catch (InterruptedException e) {
                this.isStopFlag = true;
                logger.info("GarbageCollection thread : " + e.getMessage());
            }
        }
    }

    public static GarbageCollectionMemoryJVM getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized long getSleepTime() {
        return this.sleepTime;
    }

    public synchronized void setSleepTime(long time) {
        this.sleepTime = time;
    }

    /* synthetic */ GarbageCollectionMemoryJVM(GarbageCollectionMemoryJVM garbageCollectionMemoryJVM) {
        this();
    }

    private static class SingletonResource {
        static final GarbageCollectionMemoryJVM RESOURCE = new GarbageCollectionMemoryJVM(null);

        private SingletonResource() {
        }
    }
}

