/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.engine.socket.info.ResourceInfo;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class SnmpV3ManagerConfigFileParse {
    public static final String CONF = "conf";
    public static final String TARGET = "target";
    public static final String TARGET_ADDRESS = "target_address";
    public static final String CONTEXT_NAME = "contextName";
    private static Logger logger = null;
    private final HashMap<String, SnmpV3ManagerConfigInfo> snmpV3ConfigAddressMapList = new HashMap();
    private final HashMap snmpV3ConfigEngineIDMapList = new HashMap();
    private String targetAddress;
    private String snmpEngineID;
    private final ArrayList<SnmpV3ManagerConfigInfo> resourceSnmpV3ConfigList = new ArrayList();

    public SnmpV3ManagerConfigFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());
        logger.info("SNMPV3 Config File Parse : resources/snmpV3Manager.xml");
        Document doc = null;
        doc = this.getResourceFileDocumentPath("resources/snmpV3Manager.xml");
        if (doc == null) {
            logger.severe("Resource File Doc null ");
            return;
        }
        try {
            Element root = doc.getRootElement();
            List targetList = root.getChildren(TARGET);
            int targetCount = 0;
            Iterator iterator0 = targetList.iterator();
            while (iterator0.hasNext()) {
                try {
                    SnmpV3ManagerConfigInfo snmpV3ManagerConfigInfo = new SnmpV3ManagerConfigInfo();
                    ++targetCount;
                    Element targetListEl = (Element)iterator0.next();
                    this.targetAddress = targetListEl.getChild(TARGET_ADDRESS).getAttributeValue("value");
                    snmpV3ManagerConfigInfo.setIpAddress(this.targetAddress);
                    if (targetListEl.getChild("snmpEngineID") != null && targetListEl.getChild("snmpEngineID").getAttributeValue("value") != null) {
                        this.snmpEngineID = targetListEl.getChild("snmpEngineID").getAttributeValue("value");
                        snmpV3ManagerConfigInfo.setSnmpEngineID(this.snmpEngineID);
                    } else {
                        snmpV3ManagerConfigInfo.setSnmpEngineID("");
                    }
                    if (targetListEl.getChild(CONTEXT_NAME) != null && targetListEl.getChild(CONTEXT_NAME).getAttributeValue("value") != null) {
                        snmpV3ManagerConfigInfo.setContextName(targetListEl.getChild(CONTEXT_NAME).getAttributeValue("value"));
                    } else {
                        snmpV3ManagerConfigInfo.setContextName("");
                    }
                    if (targetListEl.getChild("asn1_ber_zero_padding") != null && targetListEl.getChild("asn1_ber_zero_padding").getAttributeValue("value") != null) {
                        snmpV3ManagerConfigInfo.setAsn1BerZeroPadding(targetListEl.getChild("asn1_ber_zero_padding").getAttributeValue("value"));
                    } else {
                        snmpV3ManagerConfigInfo.setAsn1BerZeroPadding("no");
                    }
                    List userList = targetListEl.getChildren("user");
                    Iterator iterator = userList.iterator();
                    while (iterator.hasNext()) {
                        SnmpV3ManagerUserConfigInfo userProperty = new SnmpV3ManagerUserConfigInfo();
                        Element userListEl = (Element)iterator.next();
                        userProperty.setUsername(userListEl.getChild("userName").getAttributeValue("value"));
                        userProperty.setAuthPriv(userListEl.getChild("authPriv").getAttributeValue("value"));
                        userProperty.setAuthProtocol(userListEl.getChild("authProtocol").getAttributeValue("value"));
                        userProperty.setAuthPassPhrase(userListEl.getChild("authPassPhrase").getAttributeValue("value"));
                        userProperty.setPrivProtocol(userListEl.getChild("privProtocol").getAttributeValue("value"));
                        userProperty.setPrivPassPhrase(userListEl.getChild("privPassPhrase").getAttributeValue("value"));
                        snmpV3ManagerConfigInfo.addUserList(userProperty);
                    }
                    if (!this.snmpV3ConfigAddressMapList.containsKey(this.targetAddress)) {
                        this.snmpV3ConfigAddressMapList.put(this.targetAddress, snmpV3ManagerConfigInfo);
                        this.resourceSnmpV3ConfigList.add(snmpV3ManagerConfigInfo);
                        continue;
                    }
                    logger.warning("Duplicate Address=" + this.targetAddress);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    logger.warning("Abort SNMPV3 XML File parse at target No." + targetCount);
                }
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public String[] getSNMPV3TargetAddress() {
        HashMap snmpV3ManagerInfoMap = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3ConfigAddresssMapList();
        String[] agentAddressList = new String[snmpV3ManagerInfoMap.size()];
        Iterator it = null;
        int i = 0;
        for (Map.Entry ent : snmpV3ManagerInfoMap.entrySet()) {
            String snmpV3TargetAddress = (String)ent.getKey();
            SnmpV3ManagerConfigInfo snmpV3ConfigInfo = (SnmpV3ManagerConfigInfo)snmpV3ManagerInfoMap.get(snmpV3TargetAddress);
            if (snmpV3ConfigInfo == null) continue;
            agentAddressList[i] = snmpV3TargetAddress;
            ++i;
        }
        return agentAddressList;
    }

    public BufferedWriter getResourceFileWriter() {
        File f = new File("resources/snmpV3Manager.xml");
        logger.info("Path : " + f.getAbsolutePath());
        if (f == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fi = new FileWriter("resources/snmpV3Manager.xml");
            bufferedWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public Document getResourceFileDocumentPath(String file) {
        SAXBuilder builder;
        BufferedReader d;
        Document doc;
        block7: {
            doc = null;
            File f = new File(file);
            logger.info("Path : " + f.getAbsolutePath());
            if (f == null) {
                return null;
            }
            d = null;
            try {
                FileReader fi = new FileReader(file);
                d = new BufferedReader(fi);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                return null;
            }
            builder = new SAXBuilder();
            if (builder != null) break block7;
            return null;
        }
        try {
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    protected Document getDocument(String file) {
        URL url;
        Document doc;
        block5: {
            doc = null;
            url = null;
            Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
            url = bundle.getEntry(file);
            if (url != null) break block5;
            logger.severe("Resource XML file url : " + url);
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        }
        catch (JDOMException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        }
        return doc;
    }

    public Document updateDocument(ArrayList snmpV3List) {
        logger = Logger.getLogger(this.getClass().getName());
        Element confElement = new Element(CONF);
        Document doc = new Document(confElement);
        if (snmpV3List == null) {
            return null;
        }
        int i = 0;
        while (snmpV3List.size() > i) {
            SnmpV3ManagerConfigInfo snmpV3Configinf = null;
            snmpV3Configinf = (SnmpV3ManagerConfigInfo)snmpV3List.get(i);
            if (snmpV3Configinf == null) {
                logger.warning("Not found SNMP Config at index=" + i);
                break;
            }
            String targetIPAddress = snmpV3Configinf.getIpAddress();
            SnmpV3ManagerUserConfigInfo snmpV3UserInfo = null;
            snmpV3UserInfo = (SnmpV3ManagerUserConfigInfo)snmpV3Configinf.getUserList().get(0);
            if (snmpV3UserInfo == null) {
                logger.warning("Not found user info at IP=" + snmpV3Configinf.getIpAddress());
                break;
            }
            Element target = new Element(TARGET);
            confElement.addContent((Content)target);
            Element targetAddress = new Element(TARGET_ADDRESS);
            target.addContent((Content)targetAddress);
            Element user = new Element("user");
            target.addContent((Content)user);
            if (targetIPAddress != null) {
                targetAddress.setAttribute(new Attribute("value", targetIPAddress));
            } else {
                logger.warning("Not found IP Address");
            }
            Element snmpEngineID = new Element("snmpEngineID");
            if (snmpV3Configinf.getSnmpEngineID() != null) {
                target.addContent((Content)snmpEngineID);
                snmpEngineID.setAttribute(new Attribute("value", snmpV3Configinf.getSnmpEngineID()));
            }
            Element contextName = new Element(CONTEXT_NAME);
            if (snmpV3Configinf.getContextName() != null) {
                target.addContent((Content)contextName);
                contextName.setAttribute(new Attribute("value", snmpV3Configinf.getContextName()));
            } else {
                target.addContent((Content)contextName);
                contextName.setAttribute(new Attribute("value", ""));
            }
            Element asn1BerZeroPadding = new Element("asn1_ber_zero_padding");
            if (snmpV3Configinf.getAsn1BerZeroPadding() != null) {
                target.addContent((Content)asn1BerZeroPadding);
                asn1BerZeroPadding.setAttribute(new Attribute("value", snmpV3Configinf.getAsn1BerZeroPadding()));
            }
            Element userName = new Element("userName");
            Element authPriv = new Element("authPriv");
            Element authProtocol = new Element("authProtocol");
            Element authPassPhrase = new Element("authPassPhrase");
            Element privProtocol = new Element("privProtocol");
            Element privPassPhrase = new Element("privPassPhrase");
            user.addContent((Content)userName);
            user.addContent((Content)authPriv);
            user.addContent((Content)authProtocol);
            user.addContent((Content)authPassPhrase);
            user.addContent((Content)privProtocol);
            user.addContent((Content)privPassPhrase);
            user.addContent((Content)new Comment("AuthPriv NOAUTH/AUTH/PRIV"));
            user.addContent((Content)new Comment("AuthProtocol MD5/SHA"));
            if (snmpV3UserInfo.getUsername() != null) {
                userName.setAttribute(new Attribute("value", snmpV3UserInfo.getUsername()));
            } else {
                userName.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getAuthPriv() != null) {
                authPriv.setAttribute(new Attribute("value", snmpV3UserInfo.getAuthPriv()));
            } else {
                authPriv.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getAuthProtocol() != null) {
                authProtocol.setAttribute(new Attribute("value", snmpV3UserInfo.getAuthProtocol()));
            } else {
                authProtocol.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getAuthPassPhrase() != null) {
                authPassPhrase.setAttribute(new Attribute("value", snmpV3UserInfo.getAuthPassPhrase()));
            } else {
                authPassPhrase.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getPrivProtocol() != null) {
                privProtocol.setAttribute(new Attribute("value", snmpV3UserInfo.getPrivProtocol()));
            } else {
                privProtocol.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getPrivPassPhrase() != null) {
                privPassPhrase.setAttribute(new Attribute("value", snmpV3UserInfo.getPrivPassPhrase()));
            } else {
                privPassPhrase.setAttribute(new Attribute("value", ""));
            }
            ++i;
        }
        return doc;
    }

    public Document updateDocument(ResourceInfo resourceInfo) {
        logger = Logger.getLogger(this.getClass().getName());
        Element confElement = new Element(CONF);
        Document doc = new Document(confElement);
        ArrayList snmpV3List = resourceInfo.getSnmpV3ConfigList();
        if (snmpV3List == null) {
            snmpV3List = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getResourceSnmpV3ConfigList();
        }
        int i = 0;
        while (snmpV3List.size() > i) {
            SnmpV3ManagerConfigInfo snmpV3Configinf = null;
            snmpV3Configinf = (SnmpV3ManagerConfigInfo)snmpV3List.get(i);
            String targetIPAddress = snmpV3Configinf.getIpAddress();
            if (snmpV3Configinf == null) {
                logger.warning("Not found SNMP Config at index=" + i);
                break;
            }
            SnmpV3ManagerUserConfigInfo snmpV3UserInfo = null;
            snmpV3UserInfo = (SnmpV3ManagerUserConfigInfo)snmpV3Configinf.getUserList().get(0);
            if (snmpV3UserInfo == null) {
                logger.warning("Not found user info at IP=" + targetIPAddress);
                break;
            }
            Element target = new Element(TARGET);
            confElement.addContent((Content)target);
            Element targetAddress = new Element(TARGET_ADDRESS);
            target.addContent((Content)targetAddress);
            Element user = new Element("user");
            target.addContent((Content)user);
            if (targetIPAddress != null) {
                targetAddress.setAttribute(new Attribute("value", targetIPAddress));
            } else {
                logger.warning("Not found IP Address");
            }
            Element snmpEngineID = new Element("snmpEngineID");
            if (snmpV3Configinf.getSnmpEngineID() != null) {
                target.addContent((Content)snmpEngineID);
                snmpEngineID.setAttribute(new Attribute("value", snmpV3Configinf.getSnmpEngineID()));
            }
            Element contextName = new Element(CONTEXT_NAME);
            if (snmpV3Configinf.getContextName() != null) {
                target.addContent((Content)contextName);
                contextName.setAttribute(new Attribute("value", snmpV3Configinf.getContextName()));
            } else {
                target.addContent((Content)contextName);
                contextName.setAttribute(new Attribute("value", ""));
            }
            Element asn1BerZeroPadding = new Element("asn1_ber_zero_padding");
            if (snmpV3Configinf.getAsn1BerZeroPadding() != null) {
                target.addContent((Content)asn1BerZeroPadding);
                asn1BerZeroPadding.setAttribute(new Attribute("value", snmpV3Configinf.getAsn1BerZeroPadding()));
            }
            Element userName = new Element("userName");
            Element authPriv = new Element("authPriv");
            Element authProtocol = new Element("authProtocol");
            Element authPassPhrase = new Element("authPassPhrase");
            Element privProtocol = new Element("privProtocol");
            Element privPassPhrase = new Element("privPassPhrase");
            user.addContent((Content)userName);
            user.addContent((Content)authPriv);
            user.addContent((Content)authProtocol);
            user.addContent((Content)authPassPhrase);
            user.addContent((Content)privProtocol);
            user.addContent((Content)privPassPhrase);
            user.addContent((Content)new Comment("AuthPriv NOAUTH/AUTH/PRIV"));
            user.addContent((Content)new Comment("AuthProtocol MD5/SHA"));
            if (snmpV3UserInfo.getUsername() != null) {
                userName.setAttribute(new Attribute("value", snmpV3UserInfo.getUsername()));
            } else {
                userName.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getAuthPriv() != null) {
                authPriv.setAttribute(new Attribute("value", snmpV3UserInfo.getAuthPriv()));
            } else {
                authPriv.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getAuthProtocol() != null) {
                authProtocol.setAttribute(new Attribute("value", snmpV3UserInfo.getAuthProtocol()));
            } else {
                authProtocol.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getAuthPassPhrase() != null) {
                authPassPhrase.setAttribute(new Attribute("value", snmpV3UserInfo.getAuthPassPhrase()));
            } else {
                authPassPhrase.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getPrivProtocol() != null) {
                privProtocol.setAttribute(new Attribute("value", snmpV3UserInfo.getPrivProtocol()));
            } else {
                privProtocol.setAttribute(new Attribute("value", ""));
            }
            if (snmpV3UserInfo.getPrivPassPhrase() != null) {
                privPassPhrase.setAttribute(new Attribute("value", snmpV3UserInfo.getPrivPassPhrase()));
            } else {
                privPassPhrase.setAttribute(new Attribute("value", ""));
            }
            ++i;
        }
        return doc;
    }

    public HashMap getSnmpV3ConfigEngineIDMapList() {
        return this.snmpV3ConfigEngineIDMapList;
    }

    public ArrayList getResourceSnmpV3ConfigList() {
        return this.resourceSnmpV3ConfigList;
    }

    public HashMap getSnmpV3ConfigAddresssMapList() {
        return this.snmpV3ConfigAddressMapList;
    }

    public void updateSnmpV3ManagerConfigInfo(String ipAddress, SnmpV3ManagerConfigInfo snmpV3ManagerConfInfo) {
        this.snmpV3ConfigAddressMapList.put(ipAddress, snmpV3ManagerConfInfo);
    }

    public SnmpV3ManagerConfigInfo getSnmpV3AgentInfo(String ipAddress) {
        SnmpV3ManagerConfigInfo snmpV3ManagerConfInfo = null;
        if (this.snmpV3ConfigAddressMapList.size() > 0) {
            snmpV3ManagerConfInfo = this.snmpV3ConfigAddressMapList.get(ipAddress);
            if (snmpV3ManagerConfInfo == null) {
                String searchIPAddress = ipAddress;
                String searchHostName = ipAddress;
                try {
                    InetAddress host = InetAddress.getByName(ipAddress);
                    searchIPAddress = host.getHostAddress();
                    searchHostName = host.getHostName();
                }
                catch (UnknownHostException e2) {
                    logger.warning("UnknownHostException " + e2.getMessage() + " IP = " + ipAddress);
                }
                snmpV3ManagerConfInfo = this.snmpV3ConfigAddressMapList.get(searchIPAddress);
                if (snmpV3ManagerConfInfo == null) {
                    snmpV3ManagerConfInfo = this.snmpV3ConfigAddressMapList.get(searchHostName);
                }
            }
        } else {
            logger.warning("Agent Address List size=0");
        }
        return snmpV3ManagerConfInfo;
    }
}

