/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.snmpmanager.process.AbstractManagerMessageProcessingSubsystem;
import netjfwatcher.engine.snmpmanager.process.ManagerMPQueue;
import netjfwatcher.engine.snmpmanager.process.ManagerV1MP;
import netjfwatcher.engine.snmpmanager.process.ManagerV2MP;
import netjfwatcher.engine.snmpmanager.process.ManagerV3MP;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;

public class ManagerDispatcher {
    private static Logger logger;
    private InetAddress targetAddress;
    private AbstractManagerMessageProcessingSubsystem messageProcessingSubsystem = null;
    private String community;
    private DatagramSocket dSocket;

    public ManagerDispatcher() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.dSocket = new DatagramSocket();
    }

    public void setManagerDispatcher(String targetAddressString, String community, int version) throws UnknownHostException {
        this.community = community;
        this.messageProcessingSubsystem = ManagerMPQueue.getInstance().popQueue(targetAddressString, version);
        try {
            this.targetAddress = InetAddress.getByName(targetAddressString);
        }
        catch (UnknownHostException e) {
            AlarmMessageMake alarm = AlarmMessageMake.getInstance();
            alarm.setEorrorUnknownHostException(targetAddressString);
            logger.warning("Abort dispatch to " + targetAddressString + " : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public SnmpVarBindList dispathGetMessage(int version, byte code, String requestOID) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpErrorStatusException, SnmpBadValueException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpMIBGetException, SnmpSetException, SnmpConfigurationException, SnmpV3ConfigurationException, IOException {
        this.setCommandLog(version, code, requestOID);
        SnmpVarBindList returnVarBindList = null;
        switch (version) {
            case 0: {
                this.messageProcessingSubsystem.setManagerMP(this.dSocket, this.targetAddress, this.community);
                break;
            }
            case 1: {
                this.messageProcessingSubsystem.setManagerMP(this.dSocket, this.targetAddress, this.community);
                break;
            }
            case 3: {
                this.messageProcessingSubsystem.setManagerMP(this.dSocket, this.targetAddress, this.community);
                break;
            }
            default: {
                logger.warning("Bad Snmp version: " + version);
            }
        }
        if (this.messageProcessingSubsystem != null) {
            returnVarBindList = this.messageProcessingSubsystem.getProcess(code, requestOID);
        }
        return returnVarBindList;
    }

    public SnmpVarBindList dispathSetMessage(int version, byte code, String requestOID, AbstractSnmpObject snmpObject) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpErrorStatusException, SnmpMIBGetException, SnmpSetException, SnmpBadValueException, SnmpConfigurationException, SnmpV3ConfigurationException, IOException {
        this.setCommandLog(version, code, requestOID);
        this.messageProcessingSubsystem = null;
        SnmpVarBindList returnVarBindList = null;
        switch (version) {
            case 0: {
                this.messageProcessingSubsystem = new ManagerV1MP(this.dSocket, this.targetAddress, this.community);
                break;
            }
            case 1: {
                this.messageProcessingSubsystem = new ManagerV2MP(this.dSocket, this.targetAddress, this.community);
                break;
            }
            case 3: {
                this.messageProcessingSubsystem = new ManagerV3MP(this.dSocket, this.targetAddress, this.community);
                break;
            }
            default: {
                logger.warning("Illegal Snmp Version : " + version);
                return null;
            }
        }
        returnVarBindList = this.messageProcessingSubsystem.setProcess(code, requestOID, snmpObject);
        return returnVarBindList;
    }

    private void setCommandLog(int version, byte code, String requestOID) {
        switch (version) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                logger.warning("Bad Snmp version: " + version);
                return;
            }
        }
        switch (code) {
            case -96: {
                break;
            }
            case -95: {
                break;
            }
            case -93: {
                break;
            }
            default: {
                logger.warning("Undefined SNMP Command code : " + code);
                return;
            }
        }
    }

    public void closeConnection() {
        if (this.dSocket != null) {
            this.dSocket.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.dSocket != null) {
            this.dSocket.close();
        }
    }
}

