/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.canvas;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class CanvasViewConfigFileParse {
    private static final int CHART_VIEW_WIDTH = 1400;
    private static final int CHART_VIEW_HEIGHT = 800;
    private static final int X_POINT_VALUE0 = 1000;
    private static final int Y_POINT_VALUE0 = 450;
    protected static final int MAP_VIEW_WIDTH = 1900;
    protected static final int MAP_VIEW_HEIGHT = 1700;
    private static final String CONF_TAG = "conf";
    private static final String CHART_TAG = "chart";
    private static final String CHART_WIDTH_TAG = "width";
    private static final String CHART_HEIGHT_TAG = "height";
    private static final String CHART_X_SCALL_TAG = "x_scall";
    private static final String CHART_Y_SCALL_TAG = "y_scall";
    private static final String NODE_MAP_TAG = "node_map";
    private static final String NODE_MAP_WIDTH_TAG = "width";
    private static final String NODE_MAP_HEIGHT_TAG = "height";
    private static final String ATTRIBUTE_VALUE = "value";
    private static Logger logger = null;
    private int chartWidth = 1400;
    private int chartHeight = 800;
    private int chartXScall = 1000;
    private int chartYScall = 450;
    private int nodeMapWidth = 1900;
    private int nodeMapHeight = 1700;

    public CanvasViewConfigFileParse() {
        logger = Logger.getLogger(this.getClass().getName());
        Document doc = null;
        URL url = null;
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        url = bundle.getEntry("resources/canvas_view.xml");
        if (url == null) {
            logger.severe(url + " : Not Found");
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            if (builder != null) {
                doc = builder.build(url.openStream());
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Element root = doc.getRootElement();
            Element chartEl = root.getChild(CHART_TAG);
            this.chartWidth = Integer.parseInt(chartEl.getChild("width").getAttributeValue(ATTRIBUTE_VALUE));
            this.chartHeight = Integer.parseInt(chartEl.getChild("height").getAttributeValue(ATTRIBUTE_VALUE));
            this.chartXScall = Integer.parseInt(chartEl.getChild(CHART_X_SCALL_TAG).getAttributeValue(ATTRIBUTE_VALUE));
            this.chartYScall = Integer.parseInt(chartEl.getChild(CHART_Y_SCALL_TAG).getAttributeValue(ATTRIBUTE_VALUE));
            Element nodeMapEl = root.getChild(NODE_MAP_TAG);
            this.nodeMapWidth = Integer.parseInt(nodeMapEl.getChild("width").getAttributeValue(ATTRIBUTE_VALUE));
            this.nodeMapHeight = Integer.parseInt(nodeMapEl.getChild("height").getAttributeValue(ATTRIBUTE_VALUE));
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public int getChartHeight() {
        return this.chartHeight;
    }

    public int getChartWidth() {
        return this.chartWidth;
    }

    public int getNodeMapHeight() {
        return this.nodeMapHeight;
    }

    public int getNodeMapWidth() {
        return this.nodeMapWidth;
    }

    public int getChartXScall() {
        return this.chartXScall;
    }

    public int getChartYScall() {
        return this.chartYScall;
    }
}

