/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.bit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;

public class SnmpBit
extends AbstractSnmpObject {
    private List bitsList;

    public SnmpBit() {
        this.tag = (byte)3;
        this.tagDescription = "BITSTRING";
        this.bitsList = Collections.synchronizedList(new ArrayList());
        this.bitsList.add(new byte[1]);
    }

    public SnmpBit(byte[] initData) {
        this.tag = (byte)3;
        this.tagDescription = "BITSTRING";
        this.bitsList = Collections.synchronizedList(new ArrayList());
        int i = 0;
        int li = initData.length;
        while (i < li) {
            this.bitsList.add(new byte[]{initData[i]});
            ++i;
        }
    }

    public SnmpBit(int init) {
        this();
        this.tag = (byte)3;
        this.tagDescription = "BITSTRING";
        int mask = 1;
        int i = 0;
        while (i < 32) {
            if ((init & mask) != 0) {
                this.setValue(Integer.toString(i));
            }
            mask <<= 1;
            ++i;
        }
    }

    public Object getValue() {
        return this.bitsList;
    }

    public void setValue(Object nPos) {
        int n = Integer.parseInt((String)nPos);
        int index = n / 8;
        byte b = (byte)(1 << 7 - n % 8);
        int i = this.bitsList.size();
        while (i <= index) {
            this.bitsList.add(new byte[1]);
            ++i;
        }
        byte[] array = (byte[])this.bitsList.get(index);
        array[0] = (byte)(array[0] | b);
    }

    public void clearBit(int nPos) {
        int index = nPos / 8;
        byte b = (byte)(1 << 7 - nPos % 8);
        if (index >= this.bitsList.size()) {
            return;
        }
        byte[] array = (byte[])this.bitsList.get(index);
        array[0] = (byte)(array[0] & ~b);
        int i = this.bitsList.size() - 1;
        while (i > 0) {
            array = (byte[])this.bitsList.get(i);
            if (array[0] != 0) break;
            this.bitsList.remove(i);
            --i;
        }
    }

    public boolean isBit(int nPos) {
        int index = nPos / 8;
        byte b = (byte)(1 << 7 - nPos % 8);
        if (index >= this.bitsList.size()) {
            return false;
        }
        byte[] array = (byte[])this.bitsList.get(index);
        b = (byte)(array[0] & b);
        return b != 0;
    }

    public byte[] getBEREncoding() {
        int size = this.bitsList.size();
        byte[] bytes = new byte[size];
        int i = 0;
        while (i < size) {
            bytes[i] = ((byte[])this.bitsList.get(i))[0];
            ++i;
        }
        return bytes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int len = this.bitsList.size();
        if (len == 0) {
            sb.append("00");
        } else {
            byte[] array = (byte[])this.bitsList.get(0);
            StringBuffer sb2 = new StringBuffer("0");
            sb2.append(Integer.toHexString(array[0]).toUpperCase());
            String str = sb2.toString();
            sb.append(str.substring(str.length() - 2));
        }
        int i = 1;
        while (i < len) {
            sb.append(" ");
            byte[] array = (byte[])this.bitsList.get(i);
            StringBuffer sb2 = new StringBuffer("0");
            sb2.append(Integer.toHexString(array[0]).toUpperCase());
            String str = sb2.toString();
            sb.append(str.substring(str.length() - 2));
            ++i;
        }
        return sb.toString();
    }
}

