/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.message;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;

public class SnmpPDU
extends SnmpSequence {
    public static final int PDU_REQUEST_ID_POS = 0;
    public static final int PDU_ERROR_STATUS_POS = 1;
    public static final int PDU_ERROR_INDEX_POS = 2;
    public static final int PDU_VARLIST_POS = 3;
    private List contents;

    public SnmpPDU() {
        this.contents = Collections.synchronizedList(new ArrayList());
    }

    public SnmpPDU(byte pduType, int requestID, int errorStatus, int errorIndex, SnmpSequence varList) throws SnmpBadValueException {
        this.contents = Collections.synchronizedList(new ArrayList());
        this.tag = pduType;
        this.contents.add(0, new SnmpInteger(requestID));
        this.contents.add(1, new SnmpInteger(errorStatus));
        this.contents.add(2, new SnmpInteger(errorIndex));
        this.contents.add(3, varList);
        this.setValue(this.contents);
    }

    public SnmpPDU(byte[] enc, byte pduType) throws SnmpBadValueException {
        this.tag = pduType;
        this.extractFromBEREncoding(enc);
    }

    public void setSNMPPDU(byte pduType, int requestID, int errorStatus, int errorIndex, SnmpSequence varList) throws SnmpBadValueException {
        this.contents.clear();
        this.tag = pduType;
        this.contents.add(0, new SnmpInteger(requestID));
        this.contents.add(1, new SnmpInteger(errorStatus));
        this.contents.add(2, new SnmpInteger(errorIndex));
        this.contents.add(3, varList);
        this.setValue(this.contents);
    }

    public byte getPDUType() {
        return this.tag;
    }

    public SnmpSequence getVarBindList() {
        List contentsValueList = (List)this.getValue();
        return (SnmpSequence)contentsValueList.get(3);
    }

    public int getRequestID() {
        List contentsValueList = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contentsValueList.get(0)).getValue()).intValue();
    }

    public int getErrorStatus() {
        List contentsValueList = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contentsValueList.get(1)).getValue()).intValue();
    }

    public int getErrorIndex() {
        List contentsValueList = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contentsValueList.get(2)).getValue()).intValue();
    }
}

