/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.opaque;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaque;

public class SnmpOpaqueDouble
extends SnmpOpaque {
    private double opaqueDoubleValue;

    protected SnmpOpaqueDouble(double value) {
        this.opaqueDoubleValue = value;
    }

    protected SnmpOpaqueDouble(byte[] data, int offset, int length) throws SnmpBadValueException {
        this.opaqueDoubleValue = this.decode(data, offset, length);
    }

    public byte[] encode() {
        return this.encode(this.opaqueDoubleValue);
    }

    public byte[] encode(double value) {
        long longValue = Double.doubleToLongBits(value);
        byte[] array = new byte[]{68, 11, -97, 121, 8, (byte)(longValue >> 56 & 0xFFFFFFFFFFFFFFFFL), (byte)(longValue >> 48 & 0xFFFFFFFFFFFFFFFFL), (byte)(longValue >> 40 & 0xFFFFFFFFFFFFFFFFL), (byte)(longValue >> 32 & 0xFFFFFFFFFFFFFFFFL), (byte)(longValue >> 24 & 0xFFFFFFFFFFFFFFFFL), (byte)(longValue >> 16 & 0xFFFFFFFFFFFFFFFFL), (byte)(longValue >> 8 & 0xFFFFFFFFFFFFFFFFL), (byte)(longValue & 0xFFFFFFFFFFFFFFFFL)};
        return array;
    }

    public double decode(byte[] data, int offset, int length) throws SnmpBadValueException {
        if (length != 8) {
            throw new SnmpBadValueException(new StringBuffer().append("length is not 8: ").append(length).toString());
        }
        long longValue = 0L;
        try {
            int i = 0;
            while (i < length) {
                longValue <<= 8;
                longValue |= (long)(data[offset + i] & 0xFFFFFFFF);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpBadValueException(e.getMessage());
        }
        return Double.longBitsToDouble(longValue);
    }

    public Object getValue() {
        Double valued = new Double(this.opaqueDoubleValue);
        return valued;
    }

    public String toString() {
        return Double.toString(this.opaqueDoubleValue);
    }
}

