/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpv3;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.message.SnmpSequenceDecrypt;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;

public final class UsmSecuritySubsystem {
    private static int ivLow = 0;
    private static Logger logger;

    private UsmSecuritySubsystem() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized boolean checkAuth(SnmpSequence request, SnmpSequence msgSecurityParameters, Key key) throws GeneralSecurityException {
        SnmpOctetString msgAuthenticationParameters = (SnmpOctetString)msgSecurityParameters.getSNMPObjectAt(4);
        byte[] msgAuth = (byte[])msgAuthenticationParameters.getValue();
        if (msgAuth.length != 12) {
            logger.warning("msgAuth length != 12 (msgAuth length = " + msgAuth.length + ")");
            return false;
        }
        try {
            msgAuthenticationParameters.setValue(new byte[12]);
            msgSecurityParameters.addSNMPObject(msgAuthenticationParameters, 4);
            SnmpOctetString work = new SnmpOctetString(msgSecurityParameters.getBEREncoding());
            request.addSNMPObject(work, 2);
        }
        catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        mac.update(request.getBEREncoding());
        byte[] digest = mac.doFinal();
        boolean flag = true;
        int i = 0;
        while (i < 12) {
            if (msgAuth[i] != digest[i]) {
                flag = false;
                break;
            }
            ++i;
        }
        return flag;
    }

    public synchronized SnmpOctetString setAuth(SnmpSequence response, SnmpSequence msgSecurityParameters, Key key) throws GeneralSecurityException {
        SnmpOctetString cfr_ignored_0 = (SnmpOctetString)msgSecurityParameters.getSNMPObjectAt(4);
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        mac.update(response.getBEREncoding());
        byte[] digest = mac.doFinal();
        byte[] newDigest = new byte[12];
        System.arraycopy(digest, 0, newDigest, 0, 12);
        SnmpOctetString msgAuthenticationParametersOctet = null;
        msgAuthenticationParametersOctet = new SnmpOctetString(newDigest);
        return msgAuthenticationParametersOctet;
    }

    public synchronized byte[] getIV(int snmpEngineBoots) {
        byte[] iv = new byte[]{(byte)(snmpEngineBoots >> 24 & 0xFF), (byte)(snmpEngineBoots >> 16 & 0xFF), (byte)(snmpEngineBoots >> 8 & 0xFF), (byte)(snmpEngineBoots & 0xFF), (byte)(ivLow >> 24 & 0xFF), (byte)(ivLow >> 16 & 0xFF), (byte)(ivLow >> 8 & 0xFF), (byte)(ivLow & 0xFF)};
        ++ivLow;
        return iv;
    }

    public synchronized byte[] getSalt(Key key, byte[] iv) {
        byte[] salt = new byte[8];
        System.arraycopy(key.getEncoded(), 8, salt, 0, 8);
        int i = 0;
        while (i < 8) {
            int n = i;
            salt[n] = (byte)(salt[n] ^ iv[i]);
            ++i;
        }
        return salt;
    }

    public synchronized SnmpSequence decrypt(byte[] scopedPDU, byte[] salt, Key key) throws GeneralSecurityException {
        if (salt.length != 8) {
            return null;
        }
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(key.getEncoded())));
        byte[] decoded = new byte[scopedPDU.length];
        int offset = 0;
        int length = scopedPDU.length;
        while (length > 0) {
            byte[] array = cipher.update(scopedPDU, offset, length);
            int len = array.length;
            if (decoded.length < len + offset) {
                return null;
            }
            System.arraycopy(array, 0, decoded, offset, len);
            offset += len;
            length -= len;
        }
        byte[] iv = this.getSalt(key, salt);
        int i = 0;
        int li = decoded.length / 8;
        while (i < li) {
            int j = 0;
            while (j < 8) {
                int n = i * 8 + j;
                decoded[n] = (byte)(decoded[n] ^ iv[j]);
                ++j;
            }
            System.arraycopy(scopedPDU, i * 8, iv, 0, 8);
            ++i;
        }
        SnmpSequenceDecrypt snmpSequenceMsgData = null;
        try {
            snmpSequenceMsgData = new SnmpSequenceDecrypt(decoded);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort decrypt : " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (RuntimeException e) {
            logger.warning("Abort decrypt : " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        return snmpSequenceMsgData;
    }

    public static byte[] encrypt(SnmpSequence scopedPDU, byte[] iv, Key key) throws GeneralSecurityException {
        byte[] array = scopedPDU.getBEREncoding();
        int length = array.length;
        int padding = 8 - length % 8;
        if (padding == 8) {
            padding = 0;
        }
        byte[] encoded = new byte[length + padding];
        System.arraycopy(array, 0, encoded, 0, length);
        int i = 0;
        while (i < padding) {
            encoded[length + i] = 5;
            ++i;
        }
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(key.getEncoded())));
        int i2 = 0;
        int li = encoded.length / 8;
        while (i2 < li) {
            int j = 0;
            while (j < 8) {
                int n = i2 * 8 + j;
                encoded[n] = (byte)(encoded[n] ^ iv[j]);
                ++j;
            }
            array = cipher.update(encoded, i2 * 8, 8);
            System.arraycopy(array, 0, encoded, i2 * 8, 8);
            iv = array;
            ++i2;
        }
        return encoded;
    }

    public static UsmSecuritySubsystem getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ UsmSecuritySubsystem(UsmSecuritySubsystem usmSecuritySubsystem) {
        this();
    }

    private static class SingletonResource {
        static final UsmSecuritySubsystem RESOURCE = new UsmSecuritySubsystem(null);

        private SingletonResource() {
        }
    }
}

