/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.AbstractAgentView;
import netjfwatcher.snmpagent.process.AgentDispatcher;
import netjfwatcher.snmpagent.process.AgentTrapPDU;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDConfig;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AgentTrapSendView
extends AbstractAgentView {
    private static final int TEXT_WIDTH = 200;
    private static final int COUNT_TEXT_WIDTH = 100;
    private static final int COMBO_VISIBLE_ITEM_COUNT = 15;
    private static final int COLDSTART_NUMBER = 0;
    private static final int WARMSTART_NUMBER = 1;
    private static final int LINKDOWN_NUMBER = 2;
    private static final int LINKUP_NUMBER = 3;
    private static final int AUTHENTICATIONFAILURE_NUMBER = 4;
    private static final int EGPNEIBORLOSS_NUMBER = 5;
    private static final int ENTERPRISESPECIFIC_NUMBER = 6;
    protected static final String COLDSTART = "coldStart (0)";
    protected static final String WARMSTART = "warmStart (1)";
    protected static final String LINKDOWN = "linkDown (2)";
    protected static final String LINKUP = "linkUp (3)";
    protected static final String AUTHENTICATIONFAILURE = "authenticationFailure (4)";
    protected static final String EGPNEIBORLOSS = "egpNeiborLoss (5)";
    protected static final String ENTERPRISE_SPECIFIC = "enterpriseSpecific (6)";
    private static Text targetIPText;
    private static Text communityText;
    private Combo enterpriseOidCombo;
    private static Text snmpTrapOIDText;
    private static Combo snmpTrapOIDValueComboBox;
    private static Text agentIPAddressText;
    private static Text additionalVariableOIDText;
    private static Text additionalVariableOIDDescriprionText;
    private static Text valueAdditionalVariableText;
    private static Text sendTrapCounterText;
    private static Text sendTrapRepeatCounterText;
    private static Combo snmpVersionComboBox;
    private static Combo snmpValueTypeCombo;
    private static Combo genericTrapCombo;
    private static Combo specificTrapCombo;
    private static Button trapSendButton;
    private static final String DEFAULT_AGENT_ADDRESS = "0.0.0.0";
    private static final String DEFAULT_COMMUNITY = "public";
    private static final String ENTERPRISE_OID = "1.3.6.1.4.1";
    private static final String DEFAULT_VAR_BIND_OID = "1.3.6.1.2.1.2.2.1.1.1";
    private static final String DEFAULT_VAR_BIND_OID_DESC = "ifIndex.1";
    private static final String DEFAULT_VAR_BIND_VALUE = "1";
    private static final int[] SCROLL_COMPOSITE_SIZE;
    private static Logger logger;
    private static int sendCount;
    private static int sendRepeatCount;
    private static final int HORIZONTAL_SPAN3 = 3;
    private int version;
    private Map enterpriseOidInfoMap;
    private List<String> snmpTrapOidValueList = Collections.synchronizedList(new LinkedList());

    static {
        SCROLL_COMPOSITE_SIZE = new int[]{800, 300};
        sendCount = 0;
        sendRepeatCount = 1;
    }

    public AgentTrapSendView() {
        this.enterpriseOidInfoMap = EnterpriseOIDConfig.getInstance().getEnterpriseOidHashMap();
    }

    public void createPartControl(Composite parent) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(5, false);
        Composite composite = new Composite((Composite)scrollComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("Destination Address");
        label.setLayoutData((Object)new GridData());
        targetIPText = new Text(composite, 2048);
        targetIPText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        targetIPText.setLayoutData((Object)gridData);
        snmpVersionComboBox = new Combo(composite, 12);
        snmpVersionComboBox.add("SNMP Ver.1");
        snmpVersionComboBox.add("SNMP Ver.2");
        snmpVersionComboBox.add("SNMP Ver.3");
        snmpVersionComboBox.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        snmpVersionComboBox.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Community");
        label.setLayoutData((Object)new GridData());
        communityText = new Text(composite, 2048);
        communityText.setText(DEFAULT_COMMUNITY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        communityText.setLayoutData((Object)gridData);
        Label label2 = new Label(composite, 0);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Enterprise OID");
        label.setLayoutData((Object)new GridData());
        this.enterpriseOidCombo = new Combo(composite, 4);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.enterpriseOidCombo.setLayoutData((Object)gridData);
        this.enterpriseOidCombo.add(ENTERPRISE_OID);
        for (String keyOid : this.enterpriseOidInfoMap.keySet()) {
            EnterpriseOIDInfo info = (EnterpriseOIDInfo)this.enterpriseOidInfoMap.get(keyOid);
            this.enterpriseOidCombo.add("1.3.6.1.4.1." + keyOid + " " + "(" + info.getCompany() + ")");
        }
        this.enterpriseOidCombo.setVisibleItemCount(15);
        label2 = new Label(composite, 0);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("SnmpTrapOID");
        label.setLayoutData((Object)new GridData());
        snmpTrapOIDText = new Text(composite, 2048);
        snmpTrapOIDText.setText("1.3.6.1.6.3.1.1.4.1.0");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        snmpTrapOIDText.setLayoutData((Object)gridData);
        snmpTrapOIDText.setEditable(false);
        this.setSnmpTrapOIDValueComboBox(composite);
        label = new Label(composite, 0);
        label.setText("Agent IP Address");
        label.setLayoutData((Object)new GridData());
        agentIPAddressText = new Text(composite, 2048);
        agentIPAddressText.setText(this.getLocalAddress());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        agentIPAddressText.setLayoutData((Object)gridData);
        this.getLocalAddress();
        label2 = new Label(composite, 0);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Additional variable OID");
        label.setLayoutData((Object)new GridData());
        additionalVariableOIDText = new Text(composite, 2048);
        additionalVariableOIDText.setText(DEFAULT_VAR_BIND_OID);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        additionalVariableOIDText.setLayoutData((Object)gridData);
        additionalVariableOIDDescriprionText = new Text(composite, 2048);
        additionalVariableOIDDescriprionText.setText(DEFAULT_VAR_BIND_OID_DESC);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        additionalVariableOIDDescriprionText.setLayoutData((Object)gridData);
        additionalVariableOIDDescriprionText.setEditable(false);
        label = new Label(composite, 0);
        label.setText("Value for additional variable");
        label.setLayoutData((Object)new GridData());
        valueAdditionalVariableText = new Text(composite, 2048);
        valueAdditionalVariableText.setText(DEFAULT_VAR_BIND_VALUE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        valueAdditionalVariableText.setLayoutData((Object)gridData);
        this.setSnmpValueTypeCombo(composite);
        this.setGenericTrapCombo(composite);
        label2 = new Label(composite, 0);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        this.setSpecificTrapCombo(composite);
        trapSendButton = new Button(composite, 0);
        trapSendButton.setText("Trap send");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        trapSendButton.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Send Trap Count");
        label.setLayoutData((Object)new GridData());
        sendTrapCounterText = new Text(composite, 133128);
        sendTrapCounterText.setText(Integer.toString(sendCount));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        sendTrapCounterText.setLayoutData((Object)gridData);
        label2 = new Label(composite, 0);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Send Trap Repeat Count");
        label.setLayoutData((Object)new GridData());
        sendTrapRepeatCounterText = new Text(composite, 133120);
        sendTrapRepeatCounterText.setText(Integer.toString(sendRepeatCount));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        sendTrapRepeatCounterText.setLayoutData((Object)gridData);
        scrollComposite.setContent((Control)composite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        snmpVersionComboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AgentTrapSendView.this.selectSnmpVersionComboBox();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        trapSendButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                trapSendButton.setEnabled(false);
                AgentTrapSendView.this.sendTrap();
                trapSendButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void sendTrap() {
        if (targetIPText.getText().equals("")) {
            Shell shell = new Shell();
            MessageBox alertMessageBox = new MessageBox(shell, 72);
            alertMessageBox.setMessage("Illegal destination Address");
            alertMessageBox.open();
            targetIPText.setFocus();
            shell.dispose();
            return;
        }
        String ipAddress = targetIPText.getText();
        String hostAddress = "";
        String community = communityText.getText();
        try {
            InetAddress host = InetAddress.getByName(ipAddress);
            hostAddress = host.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("UnknownHostException IP Address = " + targetIPText.getText()));
            shell.dispose();
            targetIPText.setFocus();
            return;
        }
        try {
            try {
                SnmpSequence trapPDUSequence = this.createTrapPDU(hostAddress, community);
                if (trapPDUSequence != null) {
                    AgentDispatcher dispacher = new AgentDispatcher();
                    try {
                        sendRepeatCount = Integer.parseInt(sendTrapRepeatCounterText.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        sendRepeatCount = 1;
                    }
                    while (sendRepeatCount >= 1) {
                        dispacher.dispacherTrapSend(hostAddress, this.version, community, trapPDUSequence);
                        sendTrapCounterText.setText(Integer.toString(++sendCount));
                        sendTrapRepeatCounterText.setText(Integer.toString(--sendRepeatCount));
                    }
                }
            }
            catch (SocketException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
                alertMessageBox.setMessage("SocketException Trap send " + e1.getMessage());
                alertMessageBox.open();
            }
            catch (UnknownHostException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
                alertMessageBox.setMessage("UnknownHostException Trap send " + e1.getMessage());
                alertMessageBox.open();
            }
            catch (SnmpV3ConfigurationException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
                alertMessageBox.setMessage("SnmpV3ConfigurationException Trap send " + e1.getMessage());
                alertMessageBox.open();
            }
            catch (GeneralSecurityException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
                alertMessageBox.setMessage("GeneralSecurityException Trap send " + e1.getMessage());
                alertMessageBox.open();
            }
            catch (SnmpBadValueException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
                alertMessageBox.setMessage("Abort Trap send " + e1.getMessage());
                alertMessageBox.open();
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
                alertMessageBox.setMessage("Abort Trap send " + e1.getMessage());
                alertMessageBox.open();
            }
        }
        finally {
            sendTrapRepeatCounterText.setText(DEFAULT_VAR_BIND_VALUE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SnmpSequence createTrapPDU(String hostAddress, String community) {
        SnmpSequence trapPDUSequence = null;
        int selectVersion = snmpVersionComboBox.getSelectionIndex();
        logger.info("selectVersion : " + selectVersion);
        AgentTrapPDU trapPdu = AgentTrapPDU.getInstance();
        String additionalVariableOID = additionalVariableOIDText.getText();
        String valueString = valueAdditionalVariableText.getText();
        String valueTypeString = snmpValueTypeCombo.getText();
        int indexSeletcSnmpTrapOID = snmpTrapOIDValueComboBox.getSelectionIndex();
        String snmpTrapOIDValueOid = this.snmpTrapOidValueList.get(indexSeletcSnmpTrapOID);
        try {
            switch (selectVersion) {
                case 0: {
                    int specificTrap = 0;
                    try {
                        specificTrap = Integer.parseInt(specificTrapCombo.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        Shell shell = new Shell();
                        MessageBox alertMessageBox = new MessageBox(shell, 72);
                        alertMessageBox.setMessage("Illegal Specific Trap code");
                        alertMessageBox.open();
                        specificTrapCombo.setFocus();
                        shell.dispose();
                        return null;
                    }
                    this.version = 0;
                    String agentIPAddressString = agentIPAddressText.getText();
                    String agentIPAddress = "";
                    try {
                        InetAddress host = InetAddress.getByName(agentIPAddressString);
                        agentIPAddress = host.getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("UnknownHostException Agent IP Address = " + agentIPAddressText.getText()));
                        shell.dispose();
                        agentIPAddressText.setFocus();
                        return null;
                    }
                    String enterpriseOidString = this.enterpriseOidCombo.getText();
                    String enterpriseOID = ENTERPRISE_OID;
                    Pattern pattern = Pattern.compile("[ \t]");
                    String[] item = pattern.split(enterpriseOidString, 2);
                    if (item == null || item.length < 1 || item[0] == null || item[0].equals("")) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("Illegal Enterprise Oid = " + this.enterpriseOidCombo.getText()));
                        shell.dispose();
                        this.enterpriseOidCombo.setFocus();
                        return null;
                    }
                    if (item.length >= 1) {
                        enterpriseOID = item[0];
                        System.out.println("item[0] " + item[0]);
                    }
                    int genericTrap = genericTrapCombo.getSelectionIndex();
                    trapPDUSequence = trapPdu.createV1TrapPDU(agentIPAddress, enterpriseOID, genericTrap, specificTrap, additionalVariableOID, valueString, valueTypeString);
                    logger.info("Sent trap to " + targetIPText.getText());
                    logger.info("  enterprise OID:     " + ((SnmpTrapPDU)trapPDUSequence).getEnterpriseOID().toString());
                    logger.info("  agent address:      " + ((SnmpTrapPDU)trapPDUSequence).getAgentAddress().toString());
                    logger.info("  generic trap:       " + ((SnmpTrapPDU)trapPDUSequence).getGenericTrap());
                    logger.info("  specific trap:      " + ((SnmpTrapPDU)trapPDUSequence).getSpecificTrap());
                    logger.info("  timestamp:          " + ((SnmpTrapPDU)trapPDUSequence).getTimestampData());
                    logger.info("  supplementary vars: " + ((SnmpTrapPDU)trapPDUSequence).getVarBindList().toString());
                    break;
                }
                case 1: {
                    this.version = 1;
                    trapPDUSequence = trapPdu.createV2Trap2PDU(snmpTrapOIDValueOid, additionalVariableOID, valueString, valueTypeString);
                    break;
                }
                case 2: {
                    this.version = 3;
                    trapPDUSequence = trapPdu.createV3Trap2PDU(snmpTrapOIDValueOid, additionalVariableOID, valueString, valueTypeString);
                    break;
                }
                default: {
                    logger.warning("Snmp Version : " + snmpValueTypeCombo.getText());
                    this.version = 0;
                }
            }
            logger.info("Trap send execute Version : " + snmpValueTypeCombo.getText());
            return trapPDUSequence;
        }
        catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
            alertMessageBox.setMessage("Abort Trap send " + e1.getMessage());
            alertMessageBox.open();
        }
        return trapPDUSequence;
    }

    private void setSnmpTrapOIDValueComboBox(Composite composite) {
        snmpTrapOIDValueComboBox = new Combo(composite, 12);
        snmpTrapOIDValueComboBox.add("ifIndex.1(1.3.6.1.2.1.2.2.1.1.1)");
        snmpTrapOIDValueComboBox.add("coldStart(1.3.6.1.6.3.1.1.5.1)");
        snmpTrapOIDValueComboBox.add("warmStart(1.3.6.1.6.3.1.1.5.2)");
        snmpTrapOIDValueComboBox.add("linkDown(1.3.6.1.6.3.1.1.5.3)");
        snmpTrapOIDValueComboBox.add("linkUp(1.3.6.1.6.3.1.1.5.4)");
        snmpTrapOIDValueComboBox.add("authenticationFailure(1.3.6.1.6.3.1.1.5.5)");
        snmpTrapOIDValueComboBox.add("egpNeiborLoss(1.3.6.1.6.3.1.1.5.6)");
        this.snmpTrapOidValueList.add(DEFAULT_VAR_BIND_OID);
        this.snmpTrapOidValueList.add("1.3.6.1.6.3.1.1.5.1");
        this.snmpTrapOidValueList.add("1.3.6.1.6.3.1.1.5.2");
        this.snmpTrapOidValueList.add("1.3.6.1.6.3.1.1.5.3");
        this.snmpTrapOidValueList.add("1.3.6.1.6.3.1.1.5.4");
        this.snmpTrapOidValueList.add("1.3.6.1.6.3.1.1.5.5");
        this.snmpTrapOidValueList.add("1.3.6.1.6.3.1.1.5.6");
        snmpTrapOIDValueComboBox.select(0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        snmpTrapOIDValueComboBox.setLayoutData((Object)gridData);
        snmpTrapOIDValueComboBox.setEnabled(false);
    }

    private void setSnmpValueTypeCombo(Composite composite) {
        snmpValueTypeCombo = new Combo(composite, 12);
        snmpValueTypeCombo.add("INTEGER");
        snmpValueTypeCombo.add("COUNTER32");
        snmpValueTypeCombo.add("COUNTER64");
        snmpValueTypeCombo.add("GAUGE32");
        snmpValueTypeCombo.add("OCTETSTRING");
        snmpValueTypeCombo.add("IPADDRESS");
        snmpValueTypeCombo.add("NSAPADDRESS");
        snmpValueTypeCombo.add("OBJECTIDENTIFIER");
        snmpValueTypeCombo.add("TIMETICKS");
        snmpValueTypeCombo.add("INTEGER32");
        snmpValueTypeCombo.add("BITSTRING");
        snmpValueTypeCombo.add("OPAQUE");
        snmpValueTypeCombo.select(0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        snmpValueTypeCombo.setLayoutData((Object)gridData);
    }

    private void setGenericTrapCombo(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Generic-trap");
        label.setLayoutData((Object)new GridData());
        genericTrapCombo = new Combo(composite, 12);
        genericTrapCombo.add(COLDSTART);
        genericTrapCombo.add(WARMSTART);
        genericTrapCombo.add(LINKDOWN);
        genericTrapCombo.add(LINKUP);
        genericTrapCombo.add(AUTHENTICATIONFAILURE);
        genericTrapCombo.add(EGPNEIBORLOSS);
        genericTrapCombo.add(ENTERPRISE_SPECIFIC);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        genericTrapCombo.setLayoutData((Object)gridData);
        genericTrapCombo.select(0);
    }

    private void setSpecificTrapCombo(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Specific-trap");
        label.setLayoutData((Object)new GridData());
        specificTrapCombo = new Combo(composite, 4);
        specificTrapCombo.add("0");
        specificTrapCombo.add(DEFAULT_VAR_BIND_VALUE);
        specificTrapCombo.add("2");
        specificTrapCombo.add("3");
        specificTrapCombo.add("4");
        specificTrapCombo.add("5");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        specificTrapCombo.setLayoutData((Object)gridData);
        specificTrapCombo.setText("0");
    }

    private void selectSnmpVersionComboBox() {
        int index = snmpVersionComboBox.getSelectionIndex();
        switch (index) {
            case 0: {
                snmpTrapOIDText.setEditable(false);
                snmpTrapOIDValueComboBox.setEnabled(false);
                agentIPAddressText.setEnabled(true);
                this.enterpriseOidCombo.setEnabled(true);
                genericTrapCombo.setEnabled(true);
                specificTrapCombo.setEnabled(true);
                break;
            }
            case 1: {
                snmpTrapOIDText.setEditable(true);
                snmpTrapOIDValueComboBox.setEnabled(true);
                agentIPAddressText.setEnabled(false);
                this.enterpriseOidCombo.setEnabled(false);
                genericTrapCombo.setEnabled(false);
                specificTrapCombo.setEnabled(false);
                break;
            }
            case 2: {
                snmpTrapOIDText.setEditable(true);
                snmpTrapOIDValueComboBox.setEnabled(true);
                agentIPAddressText.setEnabled(false);
                this.enterpriseOidCombo.setEnabled(false);
                genericTrapCombo.setEnabled(false);
                specificTrapCombo.setEnabled(false);
                break;
            }
            default: {
                logger.warning("Illegal SNMP Version Index " + index);
            }
        }
    }

    private String getLocalAddress() {
        String addr = DEFAULT_AGENT_ADDRESS;
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            addr = localAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warning("UnknownHostException " + e.getMessage());
        }
        return addr;
    }

    public Text getAdditionalVariableOIDText() {
        return additionalVariableOIDText;
    }

    public Text getValueAdditionalVariableText() {
        return valueAdditionalVariableText;
    }

    public Combo getSnmpValueTypeCombo() {
        return snmpValueTypeCombo;
    }

    public Text getAdditionalVariableOIDDiscriprionText() {
        return additionalVariableOIDDescriprionText;
    }

    public Combo getSnmpTrapOIDValueComboBox() {
        return snmpTrapOIDValueComboBox;
    }

    public List getSnmpTrapOidValueList() {
        return this.snmpTrapOidValueList;
    }

    public void setSnmpTrapOidValueList(List snmpTrapOidValueList) {
        this.snmpTrapOidValueList = snmpTrapOidValueList;
    }
}

