/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.process;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.logging.Logger;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmpagent.process.AgentDispatcher;
import org.jdom.Document;

public final class ThreadAgent
extends DataStringDisplay
implements Runnable {
    private static Logger logger;
    private DatagramSocket dSocket;
    private String allowHost;
    private Thread agentThread;
    private long startEngineTime = System.currentTimeMillis();
    private int snmpPort = 161;

    private ThreadAgent() {
        logger = Logger.getLogger(this.getClass().getName());
        SnmpAgentConfigInfo info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        this.allowHost = info.getAllowHost();
    }

    public boolean checkThread() {
        return this.agentThread != null && this.agentThread.isAlive();
    }

    public synchronized boolean startThread(boolean isExceptionThrow) throws SocketException {
        if (this.agentThread == null || !this.agentThread.isAlive()) {
            if (this.dSocket == null) {
                try {
                    this.snmpPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpPort();
                    this.dSocket = new DatagramSocket(this.snmpPort);
                    logger.info("Socket create, port=" + this.snmpPort);
                    this.dSocket.setSoTimeout(0);
                }
                catch (SocketException e) {
                    logger.warning("Abort start agnet thread : " + e.getMessage() + " Snmp port=" + this.snmpPort);
                    e.printStackTrace();
                    if (isExceptionThrow) {
                        throw e;
                    }
                    return false;
                }
            } else {
                logger.info("Already Socket create, port =" + this.snmpPort);
            }
            logger.info("Agent Thread Start");
            this.agentThread = new Thread(ThreadAgent.getInstance());
            this.agentThread.start();
            SnmpAgentConfigInfo info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
            this.updateSnmpEngineBoots(info);
        }
        return true;
    }

    public void stopReceiving() {
        logger.info("Agent thread stop");
        if (this.agentThread != null) {
            this.agentThread.interrupt();
            this.agentThread = null;
        }
        if (this.dSocket != null) {
            this.dSocket.close();
            this.dSocket = null;
        }
    }

    public void setSocketTimeout(int socketTimeout) throws SocketException {
        this.dSocket.setSoTimeout(socketTimeout);
    }

    public void closeConnection() {
        this.dSocket.close();
    }

    public void run() {
        while (this.agentThread != null && !this.agentThread.isInterrupted()) {
            DatagramPacket inPacket = new DatagramPacket(new byte[512], 512);
            AgentDispatcher agentDispacher = new AgentDispatcher(this.dSocket);
            try {
                this.dSocket.receive(inPacket);
                String remoteIPAddress = inPacket.getAddress().getHostAddress();
                logger.info("allowHost : " + this.allowHost);
                logger.info("Remote IP Address(Manager IP Address) : " + remoteIPAddress);
                boolean isAllowClient = true;
                if (!this.allowHost.equals("all") && !remoteIPAddress.equals("127.0.0.1")) {
                    String[] checkRemoteAddress = remoteIPAddress.split("[.]", 4);
                    String[] allowRemoteAddress = this.allowHost.split("[.]", 4);
                    int i = 0;
                    while (i < allowRemoteAddress.length) {
                        if (!allowRemoteAddress[i].equals("*") && !allowRemoteAddress[i].equals(checkRemoteAddress[i])) {
                            logger.info("Reject Connect Remote address : " + remoteIPAddress);
                            logger.info("Reject Allow host address : " + this.allowHost);
                            isAllowClient = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (!isAllowClient) {
                    logger.info("Client connect reject : " + remoteIPAddress);
                    this.dSocket.close();
                    continue;
                }
                byte[] encodedMessage = inPacket.getData();
                agentDispacher.dispath(inPacket, encodedMessage, inPacket.getLength());
            }
            catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
            }
            catch (SocketException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                break;
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                break;
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                break;
            }
        }
    }

    public static ThreadAgent getInstance() {
        return SingletonResource.RESOURCE;
    }

    private void updateSnmpEngineBoots(SnmpAgentConfigInfo info) {
        SnmpV3AgentConfigInfo snmpV3ConfigInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        int engineBoots = 0;
        try {
            engineBoots = Integer.parseInt(snmpV3ConfigInfo.getSnmpEngineBoots());
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("snmpEngineBoots illegal");
        }
        snmpV3ConfigInfo.setSnmpEngineBoots(Integer.toString(++engineBoots));
        Document dom = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().updateDocument(info, snmpV3ConfigInfo);
        BufferedWriter bufWriter = null;
        bufWriter = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getResourceFileWriter();
        SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for snmp V3 EngineBoots : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public long getStartEngineTime() {
        return this.startEngineTime;
    }

    public void setStartEngineTime(long startEngineTime) {
        this.startEngineTime = startEngineTime;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.dSocket != null) {
            this.dSocket.close();
            this.dSocket = null;
        }
        this.agentThread = null;
    }

    /* synthetic */ ThreadAgent(ThreadAgent threadAgent) {
        this();
    }

    private static class SingletonResource {
        static final ThreadAgent RESOURCE = new ThreadAgent(null);

        private SingletonResource() {
        }
    }
}

