/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.socketclient;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resourceconfig.EngineResourceInfo;
import netjfwatcher.socketclient.ConnectionEngineThread;

public final class XMLSocketConnectThread
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    public static final String UNCONNECT_MSG = " Unconnect";
    public static final String CONNECT_MSG = " Connect";
    private static Logger logger;
    private ArrayList engineList;
    private Map engineConnectStateMap;
    private List connectThreadList;
    private Thread xmlSocketConnectThread;
    private List engineConnectList;
    private boolean isAccess = false;

    private XMLSocketConnectThread() {
        logger = Logger.getLogger(this.getClass().getName());
        this.engineConnectList = Collections.synchronizedList(new LinkedList());
        this.connectThreadList = Collections.synchronizedList(new LinkedList());
        this.engineConnectStateMap = Collections.synchronizedMap(new HashMap());
    }

    public boolean checkThread() {
        return this.xmlSocketConnectThread != null && this.xmlSocketConnectThread.isAlive();
    }

    public boolean startXMLSocketConnectThread(ArrayList engineList) {
        this.isAccess = false;
        this.engineList = engineList;
        if (this.xmlSocketConnectThread == null || !this.xmlSocketConnectThread.isAlive()) {
            this.xmlSocketConnectThread = new Thread(this);
            if (this.xmlSocketConnectThread != null) {
                this.xmlSocketConnectThread.start();
            }
            return true;
        }
        return false;
    }

    public void stopXMLSocketConnectThread() {
        this.isAccess = false;
        if (this.xmlSocketConnectThread == null) {
            return;
        }
        int i = 0;
        while (i < this.connectThreadList.size()) {
            ConnectionEngineThread connectEngine = (ConnectionEngineThread)this.connectThreadList.get(i);
            connectEngine.setThreadRun(false);
            ++i;
        }
        this.engineConnectList.clear();
        this.engineConnectStateMap.clear();
        int j = 0;
        while (j < this.engineList.size()) {
            String engineAddress = ((EngineResourceInfo)this.engineList.get(j)).getEngineIPaddress();
            this.engineConnectList.add(String.valueOf(engineAddress) + UNCONNECT_MSG);
            this.engineConnectStateMap.put(engineAddress, UNCONNECT_MSG);
            ++j;
        }
        this.xmlSocketConnectThread.interrupt();
        while (this.xmlSocketConnectThread != null && this.xmlSocketConnectThread.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                break;
            }
        }
        this.isAccess = true;
        this.xmlSocketConnectThread = null;
    }

    public void run() {
        this.connectThreadList.clear();
        this.engineConnectList.clear();
        this.engineConnectStateMap.clear();
        String engineAddress = "";
        String enginePortString = "";
        int i = 0;
        while (i < this.engineList.size()) {
            engineAddress = ((EngineResourceInfo)this.engineList.get(i)).getEngineIPaddress();
            enginePortString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getXmlSocketPort();
            String timeoutString = ((EngineResourceInfo)this.engineList.get(i)).getEngineTimeout();
            try {
                ConnectionEngineThread connectEngine = new ConnectionEngineThread(this.engineConnectStateMap);
                connectEngine.setXMLSocket(engineAddress, Integer.parseInt(enginePortString), Integer.parseInt(timeoutString));
                Thread connectEngineThread = new Thread(connectEngine);
                connectEngineThread.start();
                this.connectThreadList.add(connectEngine);
                this.engineConnectList.add(String.valueOf(engineAddress) + CONNECT_MSG);
                this.engineConnectStateMap.put(engineAddress, CONNECT_MSG);
            }
            catch (ConnectException e) {
                logger.warning("ConnectException : " + e.getMessage() + " EngineAddress=" + engineAddress + " Port=" + enginePortString);
                this.engineConnectList.add(String.valueOf(engineAddress) + UNCONNECT_MSG);
                this.engineConnectStateMap.put(engineAddress, UNCONNECT_MSG);
            }
            catch (NumberFormatException e) {
                logger.warning("NumberFormatException : " + e.getMessage() + " EngineAddress=" + engineAddress + " Port=" + enginePortString);
                this.engineConnectList.add(String.valueOf(engineAddress) + UNCONNECT_MSG);
                this.engineConnectStateMap.put(engineAddress, UNCONNECT_MSG);
            }
            catch (IOException e) {
                logger.warning("IOException : " + e.getMessage() + " EngineAddress=" + engineAddress + " Port=" + enginePortString);
                this.engineConnectList.add(String.valueOf(engineAddress) + UNCONNECT_MSG);
                this.engineConnectStateMap.put(engineAddress, UNCONNECT_MSG);
            }
            ++i;
        }
        this.isAccess = true;
        while (this.xmlSocketConnectThread != null && !this.xmlSocketConnectThread.isInterrupted()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                break;
            }
        }
    }

    public static XMLSocketConnectThread getInstance() {
        return SingletonResource.RESOURCE;
    }

    public List getEngineConnectList() {
        return this.engineConnectList;
    }

    public List getConnectThreadList() {
        return this.connectThreadList;
    }

    public boolean isAccess() {
        return this.isAccess;
    }

    public Map getEngineConnectStateMap() {
        return this.engineConnectStateMap;
    }

    /* synthetic */ XMLSocketConnectThread(XMLSocketConnectThread xMLSocketConnectThread) {
        this();
    }

    private static class SingletonResource {
        static final XMLSocketConnectThread RESOURCE = new XMLSocketConnectThread(null);

        private SingletonResource() {
        }
    }
}

