/*
 * Created on 2003/08/16
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.util.HashMap;
import java.util.logging.Logger;


/**
 * C^tF[XR[hTypeC^tF[Xʖ擾郁\bh
 * NXłB
 *
 * ifType OBJECT-TYPE
 *        SYNTAX INTEGER
 *        {
 *        other(1),
 *        regular1822(2),
 *        hdh1822(3),
 *        ddn-x25(4),
 *        rfc877-x25(5),
 *        ethernet-csmacd(6),
 *        iso88023-csmacd(7),
 *        iso88024-tokenBus(8),
 *        iso88025-tokenRing(9),
 *        iso88026-man(10),
 *        starLan(11),
 *        proteon-10Mbit(12),
 *        proteon-80Mbit(13),
 *        hyperchannel(14),
 *        fddi(15),
 *        lapb(16),
 *        sdlc(17),
 *        ds1(18),
 *        e1(19),
 *        basicISDN(20),
 *        primaryISDN(21),
 *        propPointToPointSerial(22),
 *        ppp(23),
 *        softwareLoopback(24),
 *        eon(25),
 *        ethernet-3Mbit(26),
 *        nsip(27),
 *        slip(28),
 *        ultra(29),
 *        ds3(30),
 *        sip(31),
 *        frame-relay(32)
 * }
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
*/
public class IfTypeMibDisplay {
    private static Logger logger = null;

    /**
     * C^tF[XR[hTypeC^tF[Xʖ擾
     * 郁\bhNXCX^X𐶐܂B
     *
     */
    public IfTypeMibDisplay() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * C^tF[XR[hTypeC^tF[XʖԂ܂B
     * ỸR[h݂Ȃꍇ́A"undefine"Ԃ܂B
     *
     * @param ifType C^tF[XR[hType
     * @return ifTypename C^tF[Xʖ
     */
    public String getIfTypeString(final String ifType) {
        String ifTypename = null;

        HashMap ifTypeMap = IfTypeDetectFile.getInstance().getIfTypeMap();

        ifTypename = (String) ifTypeMap.get(ifType);

        if ((ifTypename == null) || ifTypename.equals("")) {
            logger.warning("Undefine IF Type : " + ifType);
            ifTypename = "undefine";
        }

        return ifTypename;
    }
}
