/*
 * Created on 2004/04/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;

import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;



/**
 * A[bZ[W\[Xt@C擾āAIDɑΉ
 * AlarmCodeInformationNXCX^XMAPƂĕێ
 * NXłB
 * ܂AIDɑΉAlarmCodeInformationNXCX^X
 * Ԃ\bhVOgNXłB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AlarmMessageResource {
    /** Ping Timeout̃A[bZ[WID */
    public static final String PING_TIMEOUT = "1";

    /** Ping Timeout̃A[bZ[WID */
    public static final String PING_HOST_UNREACHABLE = "2";

    /** PingԂ臒l𒴂ꍇ̃A[bZ[WID */
    public static final String PING_OVER_AT_THRESHHOLD = "3";

    /** SNMPM^CAEg̃A[bZ[WID */
    public static final String SNMP_GET_TIMEOUT = "4";

    /** SNMPR}hMłNoRouteToHost̃A[bZ[WID */
    public static final String SNMP_NO_ROUTE_TOHOST = "5";

    /** SNMPR}hMłNoRouteToHost̃A[bZ[WID */
    public static final String SNMP_IOEXCEPTION = "6";

    /** Ping Timeout ̃A[bZ[WID */
    public static final String RECOVERY_PING_TIMEOUT = "7";

    /** PingԂ臒l𒴂ɕꍇ̃A[bZ[WID */
    public static final String RECOVERY_PING_OVER_AT_THRESHHOLD = "8";

    /** SNMPM^CAEg畜ꍇ̃A[bZ[WID */
    public static final String RECOVERY_SNMP_GET_TIMEOUT = "9";

    /** SNMPR}hMłNoRouteToHost畜ꍇ̃A[bZ[WID */
    public static final String RECOVERY_SNMP_NO_ROUTE_TOHOST = "10";

    /** SNMPR}hMłNoRouteToHost畜ꍇ̃A[bZ[WID */
    public static final String RECOVERY_SNMP_IOEXCEPTION = "11";

    /** SNMP TrapM̃A[bZ[WID */
    public static final String SNMP_TRAP_RECEIVE = "12";

    /** A[MailMɎsꍇ̃A[bZ[WID */
    public static final String SEND_MAIL_ERROR = "13";

    /** A[MailML[I[o[t[ꍇ̃A[bZ[WID */
    public static final String SEND_MAIL_QUEUE_OVERFLOW = "14";

    /** PingԂ臒l𒴂ꍇ̃A[bZ[WID */
    public static final String STATISTICS_MIB_OVER_AT_THRESHHOLD = "15";

    /** PingԂ臒l𒴂ꍇ̃A[bZ[WID */
    public static final String RECOVERY_STATISTICS_MIB_OVER_AT_THRESHHOLD =
        "16";

    /** HTTPŎwURL GetŃG[ꍇ̃A[bZ[WID */
    public static final String HTTP_GET_ERROR = "17";

    /** HTTPŎwURL GetŃG[畜ꍇ̃A[bZ[WID */
    public static final String RECOVERY_HTTP_GET_ERROR = "18";

    /** HTTPŎwURL GetŃG[ꍇ̃A[bZ[WID */
    public static final String POP3_CHECK_ERROR = "19";

    /** HTTPŎwURL GetŃG[畜ꍇ̃A[bZ[WID */
    public static final String RECOVERY_POP3_CHECK_ERROR = "20";

    /** HTTPŎwURL GetŃG[ꍇ̃A[bZ[WID */
    public static final String SMTP_CHECK_ERROR = "21";

    /** HTTPŎwURL GetŃG[畜ꍇ̃A[bZ[WID */
    public static final String RECOVERY_SMTP_CHECK_ERROR = "22";

    /** C^tF[XԂωꍇ̃A[bZ[WID */
    public static final String CHANGE_INTERFACE_STATUS_WARNING = "23";

    /** C^tF[Xωꍇ̃A[bZ[WID */
    public static final String CHANGE_INTERFACE_WARNING = "24";

    /** m[hύXꂽꍇ̃A[bZ[WID */
    public static final String CHANGE_NODE_WARNING = "25";

    /** m[h̃VXe񂪕ύXꂽꍇ̃A[bZ[WID */
    public static final String CHANGE_NODE_SYSTEM_INFO_WARNING = "26";

    /** SNMPMŃG[Xe[^Xoꍇ̃A[bZ[WID */
    public static final String SNMP_RECEIVE_ERROR_STATUS_WARNING = "27";

    /** SNMP MIB̎Ɏsꍇ̃A[bZ[WID */
    public static final String ABORT_GET_SNMP_MIB_ERROR = "28";

    /** SNMP V3 Report OIDMꍇ̃A[bZ[WID */
    public static final String SNMP_V3_RECEIVE_REPORT_OID_WARNING = "29";

    /** SNMP V3 Report OIDMꍇ̃A[bZ[WID */
    public static final String SNMP_UNMUCH_REQUEST_ID_WARNING = "30";

    /** SNMP V3 Report OIDMꍇ̃A[bZ[WID */
    public static final String SNMP_V3_UNMUCH_REQUEST_MSG_ID_WARNING = "31";

    /** SNMP V3 Report OIDMꍇ̃A[bZ[WID */
    public static final String UNKNOWN_HOST_ID_ERROR = "32";

    /** SnmpV3 }l[Wł̎wIPAhXɑ΂vpeB񂪌Ȃꍇ̃A[bZ[WID */
    public static final String SNMPV3_CONFIG_ERROR = "33";

    /** syslog-ngM̃A[bZ[WID */
    public static final String SYSLOG_NG = "34";
    
    /** Honey port scanõA[bZ[WID */
    public static final String HONEY_PORT_SCAN = "35";
    /** Port scan NG̃A[bZ[WID */
    public static final String PORT_SCAN_NG = "36";
    /** Port scan NG畜̃A[bZ[WID */
    public static final String RECOVERY_PORT_SCAN_NG = "37";
    
    /** PrinterԂωꍇ̃A[bZ[WID */
    public static final String CHANGE_PRINT_STATUS_WARNING = "38";

    /** PrinterC^tF[Xωꍇ̃A[bZ[WID */
    public static final String CHANGE_PRINTER_INTERFACE_WARNING = "39";
    
    /** DatabaseڑG[̃A[bZ[WID */
    public static final String DATABASE_CONNECTION_ERROR = "40";

    /** DatabaseڑG[畜̃A[bZ[WID */
    public static final String RECOVERY_DATABASE_CONNECTION_ERROR = "41";
    
    /** Database SQLsG[̃A[bZ[WID */
    public static final String DATABASE_SQL_EXCEPTION_ERROR = "42";

    /** Database SQLsG[畜̃A[bZ[WID */
    public static final String RECOVERY_DATABASE_SQL_EXCEPTION_ERROR = "43";
    
    /* bZ[Wp\[XXMLt@CAlert/Confirm^Ȏ */
    private static final String MESSAGE_TAG_ATTRIBUTE = "ID";

    /* Y郁bZ[W݂ȂꍇɕԂbZ[W */
    private static final String MESSAGE_ID_NOTFOUND = "Application Error";

    /* AlertbZ[Wi[Map */
    private static HashMap alertMessageMap = new HashMap();

    /* ConfirmbZ[Wi[Map */
    private static HashMap confirmMessageMap = new HashMap();

    /* Logging */
    private static Logger logger = null;

    /**
     *
     *
     */
    private AlarmMessageResource() {
        logger = Logger.getLogger(DialogMessageResource.class.getName());
    }

    /**
     * Confirm_CAOEBhEɕ\郁bZ[W
     * Ԃ܂B<BR>
     *
     * @param keyId ConfirmbZ[WID
     * @return ConfirmbZ[W
     */
    public static String getConfirmMessage(final String keyId) {
        if (confirmMessageMap.containsKey(keyId)) {
            return (String) confirmMessageMap.get(keyId);
        }

        /* A[bZ[W\[XǂݍMapƂĕێ */
        parseURLAlarmMessageXMLFile();

        if (confirmMessageMap.containsKey(keyId)) {
            return (String) confirmMessageMap.get(keyId);
        }

        return MESSAGE_ID_NOTFOUND;
    }

    /**
     * Alert_CAOEBhEɕ\郁bZ[W
     * Ԃ܂B<BR>
     *
     * @param keyId AlermbZ[WID
     * @return AlertbZ[W
     */
    public static AlarmCodeInformation getAlertMessage(final String keyId) {
        // AlermbZ[WIDɊYA[擾
        if (alertMessageMap.containsKey(keyId)) {
            return (AlarmCodeInformation) alertMessageMap.get(keyId);
        }

        /* A[bZ[W\[XǂݍMapƂĕێ */
        parseURLAlarmMessageXMLFile();

        if (alertMessageMap.containsKey(keyId)) {
            return (AlarmCodeInformation) alertMessageMap.get(keyId);
        }

        AlarmCodeInformation returnAlarm = new AlarmCodeInformation();
        returnAlarm.setMessage(MESSAGE_ID_NOTFOUND);
        returnAlarm.setCode("unkonown");

        return returnAlarm;
    }

    /**
     *
     * w̃fBNg̃A[XMLt@C͂܂B
     *
     */
    public static void parseDirectryAlarmMessageXMLFile() {
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;

        File f = new File(FilePreference.ALARM_MESSAGE_XML_FILE);

        try {
            /* XMLt@ĆADOMp[Tpt@Ng̐ */
            dbfactory = DocumentBuilderFactory.newInstance();

            /* Ó؂s */
            dbfactory.setValidating(true);

            /* DOM DocumentCX^Xpt@Ng̐ */
            builder = dbfactory.newDocumentBuilder();

            /* G[nh̓o^ */
            builder.setErrorHandler(new DocumentParseErrorHandler());
            dom = builder.parse(f);
        } catch (Exception e) {
            /* ȉ̗Ocatch
             * EDocumentBuilderŗOiParserConfigurationExceptionj
             * EXMLt@C͂ō\̓G[iSAXExceptionj
             * EXMLt@C͂œo̓G[iIOExceptionj
             */
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        Element root = dom.getDocumentElement();
        Node firstNode = root.getFirstChild();

        /*  */
        setMessageMap(
            alertMessageMap, firstNode, "info", MESSAGE_TAG_ATTRIBUTE);
    }

    /**
     * jart@C猟
     *
     * bZ[WXMLt@C͂āAbZ[WIDɑΉ
     * bZ[Wi[Map𐶐܂B<BR>
     *
     */
    public static void parseURLAlarmMessageXMLFile() {
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;
        logger = Logger.getLogger(DialogMessageResource.class.getName());

        /* bZ[W\[Xt@C */
        URL url = null;

        /* 摜肷邽߂PluginResource bundle */
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        url = bundle.getEntry(FilePreference.ALARM_MESSAGE_XML_FILE);

        if (url == null) {
            /* bZ[W\[Xt@CȂꍇMO̎ */
            logger.severe(url + " : Not Found");
            logger.severe(
                "Alert/Confirm Dialog Window Message XML file url : " + url);
        }

        try {
            /* XMLt@ĆADOMp[Tpt@Ng̐ */
            dbfactory = DocumentBuilderFactory.newInstance();

            /* Ó؂s */
            dbfactory.setValidating(true);

            /* DOM DocumentCX^Xpt@Ng̐ */
            builder = dbfactory.newDocumentBuilder();

            /* G[nh̓o^ */
            builder.setErrorHandler(new DocumentParseErrorHandler());
            dom = builder.parse(url.openStream());
        } catch (Exception e) {
            /* ȉ̗Ocatch
             * EDocumentBuilderŗOiParserConfigurationExceptionj
             * EXMLt@C͂ō\̓G[iSAXExceptionj
             * EXMLt@C͂œo̓G[iIOExceptionj
             */
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        Element root = dom.getDocumentElement();
        Node firstFlightInfoNode = root.getFirstChild();


        setMessageMap(
            alertMessageMap, firstFlightInfoNode, "info", MESSAGE_TAG_ATTRIBUTE);

        /* Confirm_CAObZ[Wmapɐݒ */
        /* Element root = dom.getDocumentElement();
        Node firstFlightInfoNode = root.getFirstChild();
        setMessageMap(
                confirmMessageMap, firstFlightInfoNode, CONFIRM_MESSAGE_TAG,
                MESSAGE_TAG_ATTRIBUTE);
        */
        /* Alert_CAObZ[Wmapɐݒ */
        /*
        firstFlightInfoNode = root.getFirstChild();
        setMessageMap(
                alertMessageMap, firstFlightInfoNode, ALERT_MESSAGE_TAG,
                MESSAGE_TAG_ATTRIBUTE);
        */
    }

    /**
     * w肵^OyёɑΉlw肵MapɊi[܂B
     * <BR>
     *
     * @param messageMap olL[Ƃă^OɑΉ
     * li[Map
     * @param rootNode ͂m[h
     * @param tagName o^O
     * @param tagAttribute o^Ȏ
     */
    private static void setMessageMap(
        final HashMap<String, AlarmCodeInformation> messageMap, final Node rootNode, final String tagName,
        final String tagAttribute) {
        Node targetNode = rootNode;

        /*  */
        while (targetNode != null) {
            if (targetNode.getNodeType() == Node.ELEMENT_NODE) {
                /*  */
                if (targetNode.getNodeName().equals(tagName)) {
                    break; // w^Oo
                }
            }

            targetNode = targetNode.getNextSibling();
        }

        // w^Oo
        if (targetNode != null) {
            Node nodeLeaf = targetNode.getFirstChild();

            while (nodeLeaf != null) {
                if (nodeLeaf.getNodeType() == Node.ELEMENT_NODE) {
                    String id = "";
                    String level = "";
                    String code = "";
                    String message = "";

                    NodeList testlist = nodeLeaf.getChildNodes();

                    if (nodeLeaf.getNodeName().equals("alarm")) {
                        NamedNodeMap map = nodeLeaf.getAttributes();

                        // ^O
                        for (int j = 0; j < map.getLength(); j++) {
                            Node node = map.item(j);

                            // ^Oƈv瑮lIDƂĊi[
                            if (node.getNodeName().equals(tagAttribute)) {
                                id = node.getNodeValue();
                            }
                        }
                    }

                    for (int i = 0; i < testlist.getLength(); i++) {
                        Node testnode2 = testlist.item(i);

                        if (testnode2.getNodeName().equals("level")) {
                            level = testnode2.getFirstChild().getNodeValue();
                        }

                        if (testnode2.getNodeName().equals("code")) {
                            code = testnode2.getFirstChild().getNodeValue();
                        }

                        if (testnode2.getNodeName().equals("message")) {
                            message = testnode2.getFirstChild().getNodeValue();
                        }
                    }

                    if (!id.equals("")) {
                        AlarmCodeInformation alarmInfo =
                            new AlarmCodeInformation();
                        alarmInfo.setId(id);
                        alarmInfo.setLevel(level);
                        alarmInfo.setCode(code);
                        alarmInfo.setMessage(message);

                        /* oIDIDɑΉ郁bZ[WMapɊi[ */
                        messageMap.put(id, alarmInfo);
                    }
                }

                nodeLeaf = nodeLeaf.getNextSibling();
            }
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNgԂ
     * ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static AlarmMessageResource getInstance() {
        return SingletonMessage.MESSAGE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonMessage {
        static final AlarmMessageResource MESSAGE = new AlarmMessageResource();
    }
}
