/*
 * Created on 2004/04/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.control;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

import netjfwatcher.authentication.AuthenticationManager;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.AuthenticationInfo;


/**
 * R}hۃNX̃ev[gƂāA
 * <A HREF="{@docRoot}/suncertify/command/concrete/package-summary.html">
 * eR}hۃNX</A>Ɍp钊ۃNXłB<BR>
 * [UC^tF[X̗viR}hANVj̃f[^
 * JvZAvɑΉ
 * <A HREF="{@docRoot}/suncertify/command/concrete/package-summary.html">
 * R}hۃNX
 * </A>̃\bh̃p[^ƂăC^tF[Xėp
 * AR}hs܂B<BR><BR>
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class TemplateCommandImpl implements ICommand {
    /* MO */
    private static Logger logger;

    /**
     *
     *
     */
    public TemplateCommandImpl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * [UC^tF[X̗viR}hANVj
     * ̓f[^
     *
     * Ȃǂf[^z_[NX
     *
     * ɋlߑւĂ
     * R}hۃNX</A>̃\bhĂяo܂B<BR>
     * R}hsev[g\bhłB<BR>
    * if[^z_[p[^Ƃ邱ƂɂAėp
    * VOlC`\bhƂ܂j<BR>
    *
     * @param com [UC^tF[X
     * ̓f[^Ȃǂێf[^z_[NX
     *
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void execute(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        if(!checkAuth(com, ois, oos)) {
        	return;
        }
        this.doInvoke(com, ois, oos);
    }

    /**
     * R}hۃNXT[rXirWlXEWbNjĂ
     * o߂̃tbN\bhłB<BR>
     * ieT[rXɑΉ郁\bh̓TuNXŎ܂j<BR>
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public abstract void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos);

    public boolean checkAuth(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
    	if(!AuthenticationManager.getInstance().checkIP(com.getIpaddress())) {
    		AuthenticationInfo authInfo = com.getAuthInfo();
    		if(authInfo == null) {
    			com.setCode(CommandMappingTableResource.REQUEST_AUTH_RESPONSE);
    			sendResponse(com, ois, oos); 
    			return false;
    		}
    		if(!AuthenticationManager.getInstance().checkUserName(com.getIpaddress(), authInfo.getUserName(), authInfo.getPassword())) {
    			com.setCode(CommandMappingTableResource.REQUEST_AUTH_RESPONSE);
    			sendResponse(com, ois, oos); 
    			return false;
    		}
    	}
    	
    	return true;
    }
    /**
     * R}hsɉԂ܂B
     *
     * @param resObj IuWFNg
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void sendResponse(
        final Object resObj, final ObjectInputStream ois,
        final ObjectOutputStream oos) {
        try {
            /*
             * M
             */
            oos.writeObject(resObj);
            oos.flush();

            CommandInfo resCom = (CommandInfo) ois.readObject();

            if (
                !resCom.getCode().equals(
                        CommandMappingTableResource.ACK_RESPONSE)) {
                /* m艞łȂے艞Ԃꍇɂ̓O̎ */
                logger.warning("No Ack : " + resCom.getCode());
            }
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}
